package com.clustercontrol.notify.monitor.model;

import javax.persistence.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.annotation.HinemosObjectPrivilege;
import com.clustercontrol.accesscontrol.bean.RoleIdConstant;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant.ObjectPrivilegeMode;
import com.clustercontrol.accesscontrol.model.ObjectPrivilegeTargetEntity;
import com.clustercontrol.commons.util.HinemosEntityManager;
import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.jobmanagement.factory.CreateJobSession;
import com.clustercontrol.jobmanagement.model.JobSessionEntity;
import com.clustercontrol.jobmanagement.model.JobSessionJobEntity;
import com.clustercontrol.maintenance.model.MaintenanceInfoEntity;
import com.clustercontrol.monitor.run.model.MonitorInfoEntity;
import com.clustercontrol.notify.monitor.util.OwnerDeterminDispatcher;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;


/**
 * The persistent class for the cc_event_log database table.
 * 
 */
@Entity
@Table(name="cc_event_log")
@HinemosObjectPrivilege(
		objectType=HinemosModuleConstant.MONITOR)
@AttributeOverride(name="objectId",
column=@Column(name="monitor_id", insertable=false, updatable=false))
public class EventLogEntity extends ObjectPrivilegeTargetEntity {
	private static final long serialVersionUID = 1L;
	private EventLogEntityPK id;
	private String application;
	private String comment;
	private Timestamp commentDate;
	private String commentUser;
	private Timestamp confirmDate;
	private Integer confirmFlg;
	private String confirmUser;
	private Long duplicationCount;
	private Timestamp generationDate;
	private Integer inhibitedFlg;
	private String message;
	private String messageId;
	private String messageOrg;
	private Integer priority;
	private String scopeText;

	private static Log m_log = LogFactory.getLog(EventLogEntity.class);
	
	@Deprecated
	public EventLogEntity() {
	}

	public EventLogEntity(EventLogEntityPK pk) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.setObjectId(this.getId().getMonitorId());
		
		// 通知元が監視の場合
		if(this.getId().getPluginId().matches(HinemosModuleConstant.MONITOR+".*")){
			// オブジェクト権限チェックのため、cc_monitor_infoのowner_role_idを設定する
			MonitorInfoEntity monitorInfoEntity
			= ((HinemosEntityManager)em).find(MonitorInfoEntity.class, this.getId().getMonitorId(), ObjectPrivilegeMode.NONE);
			if (monitorInfoEntity != null && monitorInfoEntity.getOwnerRoleId() != null) {
				this.setOwnerRoleId(monitorInfoEntity.getOwnerRoleId());
			} else {
				this.setOwnerRoleId(RoleIdConstant.INTERNAL);
			}
		}
		// 通知元がジョブの場合
		else if(this.getId().getPluginId().matches(HinemosModuleConstant.JOB+".*")) {
			// オブジェクト権限チェックのため、cc_job_session_jobのowner_role_idを設定する
			JobSessionEntity jobSessionEntity 
			= ((HinemosEntityManager)em).find(JobSessionEntity.class, this.getId().getMonitorId(), ObjectPrivilegeMode.NONE);
			JobSessionJobEntity jobSessionJobEntity = null;
			if (jobSessionEntity == null) {
				m_log.warn("EventLogEntity(Job) is null : " + this.getId().getMonitorId());
			} else {
				List<JobSessionJobEntity> jobSessionJobEntityList = jobSessionEntity.getJobSessionJobEntities();
				Iterator<JobSessionJobEntity> it = jobSessionJobEntityList.iterator();
				while(it.hasNext()) {
					jobSessionJobEntity = it.next();
					// ジョブユニット「ROOT」でない場合はwhileを抜ける
					// ジョブユニットが「ROOT」であるものは、オーナーロールIDが「ALL_USERS」であるため
					if(!jobSessionJobEntity.getId().getJobunitId().matches(CreateJobSession.TOP_JOBUNIT_ID)) {
						break;
					}
				}
			}
			
			if (jobSessionJobEntity != null && jobSessionJobEntity.getOwnerRoleId() != null) {
				this.setOwnerRoleId(jobSessionJobEntity.getOwnerRoleId());
			} else {
				this.setOwnerRoleId(RoleIdConstant.INTERNAL);
			}
		}
		// 通知元がメンテナンスの場合
		else if(this.getId().getPluginId().matches(HinemosModuleConstant.SYSYTEM_MAINTENANCE)){
			// オブジェクト権限チェックのため、cc_maintenance_infoのowner_role_idを設定する
			MaintenanceInfoEntity maintenanceInfoEntity
			= ((HinemosEntityManager)em).find(MaintenanceInfoEntity.class, this.getId().getMonitorId(), ObjectPrivilegeMode.NONE);
			if (maintenanceInfoEntity != null && maintenanceInfoEntity.getOwnerRoleId() != null) {
				this.setOwnerRoleId(maintenanceInfoEntity.getOwnerRoleId());
			} else {
				this.setOwnerRoleId(RoleIdConstant.INTERNAL);
			}
		}
		// 通知元が上記以外のプラグインIDの場合
		// ここでオプション等の任意イベント（設定に紐付かないタイプのもの）についてオーナロールを決定することが可能。
		// プラグインIDをキーにして、ObjectSharingServiceにIEventOwnerDeterminerの実装クラスを登録し、
		// そこでオーナロールを決定する。
		// 事前に当該プラグインIDに対応するIEventOwnerDeterminerの実装クラスが登録されていない場合には、
		// オーナはINTERNALとなる。
		// 但し、このルートではリフレクションを使うため、多くのイベントが発生するオプションなどでこの機構を使うと性能的に
		// 問題になる可能性が高いため、そういう場合にはここに分岐を作って直接処理をするべき。
		else {
			setOwnerRoleId(OwnerDeterminDispatcher.getOptionalEventOwner(pk));
		}
	}

	public EventLogEntity(String monitorId,
			String monitorDetailId,
			String pluginId,
			java.util.Date outputDate,
			String facilityId) {
		this(new EventLogEntityPK(monitorId,
				monitorDetailId,
				pluginId,
				outputDate,
				facilityId));
	}

	@EmbeddedId
	public EventLogEntityPK getId() {
		return this.id;
	}

	public void setId(EventLogEntityPK id) {
		this.id = id;
	}


	public String getApplication() {
		return this.application;
	}

	public void setApplication(String application) {
		this.application = application;
	}


	public String getComment() {
		return this.comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}


	@Column(name="comment_date")
	public Timestamp getCommentDate() {
		return this.commentDate;
	}

	public void setCommentDate(Timestamp commentDate) {
		this.commentDate = commentDate;
	}


	@Column(name="comment_user")
	public String getCommentUser() {
		return this.commentUser;
	}

	public void setCommentUser(String commentUser) {
		this.commentUser = commentUser;
	}


	@Column(name="confirm_date")
	public Timestamp getConfirmDate() {
		return this.confirmDate;
	}

	public void setConfirmDate(Timestamp confirmDate) {
		this.confirmDate = confirmDate;
	}


	@Column(name="confirm_flg")
	public Integer getConfirmFlg() {
		return this.confirmFlg;
	}

	public void setConfirmFlg(Integer confirmFlg) {
		this.confirmFlg = confirmFlg;
	}


	@Column(name="confirm_user")
	public String getConfirmUser() {
		return this.confirmUser;
	}

	public void setConfirmUser(String confirmUser) {
		this.confirmUser = confirmUser;
	}


	@Column(name="duplication_count")
	public Long getDuplicationCount() {
		return this.duplicationCount;
	}

	public void setDuplicationCount(Long duplicationCount) {
		this.duplicationCount = duplicationCount;
	}


	@Column(name="generation_date")
	public Timestamp getGenerationDate() {
		return this.generationDate;
	}

	public void setGenerationDate(Timestamp generationDate) {
		this.generationDate = generationDate;
	}


	@Column(name="inhibited_flg")
	public Integer getInhibitedFlg() {
		return this.inhibitedFlg;
	}

	public void setInhibitedFlg(Integer inhibitedFlg) {
		this.inhibitedFlg = inhibitedFlg;
	}


	public String getMessage() {
		return this.message;
	}

	public void setMessage(String message) {
		this.message = message;
	}


	@Column(name="message_id")
	public String getMessageId() {
		return this.messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}


	@Column(name="message_org")
	public String getMessageOrg() {
		return this.messageOrg;
	}

	public void setMessageOrg(String messageOrg) {
		this.messageOrg = messageOrg;
	}


	public Integer getPriority() {
		return this.priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}


	@Column(name="scope_text")
	public String getScopeText() {
		return this.scopeText;
	}

	public void setScopeText(String scopeText) {
		this.scopeText = scopeText;
	}

}