/*
 * Decompiled with CFR 0.152.
 */
package org.vafada.swtcalendar;

import java.util.ArrayList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class RepeatingButton
extends Button {
    public static final int DEFAULT_INITIAL_REPEAT_DELAY = 200;
    public static final int DEFAULT_REPEAT_DELAY = 50;
    private int initialRepeatDelay = 200;
    private int repeatDelay = 50;
    private ArrayList selectionListeners = new ArrayList(3);
    private Repeater repeater;

    public RepeatingButton(Composite parent, int style) {
        super(parent, style);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                RepeatingButton.this.cancelRepeater();
                if (event.button == 1) {
                    RepeatingButton.this.buttonPressed(event.stateMask, event.time);
                    RepeatingButton.this.repeater = new Repeater(event.stateMask);
                    RepeatingButton.this.getDisplay().timerExec(RepeatingButton.this.initialRepeatDelay, (Runnable)RepeatingButton.this.repeater);
                }
            }

            public void mouseUp(MouseEvent event) {
                if (event.button == 1) {
                    RepeatingButton.this.cancelRepeater();
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                RepeatingButton.this.cancelRepeater();
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public int getInitialRepeatDelay() {
        return this.initialRepeatDelay;
    }

    public void setInitialRepeatDelay(int initialRepeatDelay) {
        this.initialRepeatDelay = initialRepeatDelay;
    }

    public int getRepeatDelay() {
        return this.repeatDelay;
    }

    public void setRepeatDelay(int repeatDelay) {
        this.repeatDelay = repeatDelay;
    }

    private void buttonPressed(int stateMask, int time) {
        SelectionListener[] listeners = new SelectionListener[this.selectionListeners.size()];
        this.selectionListeners.toArray(listeners);
        int i = 0;
        while (i < listeners.length) {
            SelectionListener l = listeners[i];
            Event event = new Event();
            event.type = 13;
            event.display = this.getDisplay();
            event.widget = this;
            event.stateMask = stateMask;
            event.time = time;
            l.widgetSelected(new SelectionEvent(event));
            ++i;
        }
    }

    private void cancelRepeater() {
        if (this.repeater != null) {
            this.repeater.cancel();
            this.repeater = null;
        }
    }

    protected void checkSubclass() {
    }

    private class Repeater
    implements Runnable {
        private boolean canceled;
        private int stateMask;

        public Repeater(int stateMask) {
            this.stateMask = stateMask;
        }

        @Override
        public void run() {
            if (!this.canceled) {
                RepeatingButton.this.buttonPressed(this.stateMask, (int)System.currentTimeMillis());
                RepeatingButton.this.getDisplay().timerExec(RepeatingButton.this.repeatDelay, (Runnable)this);
            }
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

