/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.winevent.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.monitor.run.dialog.CommonMonitorStringDialog;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.winevent.bean.WinEventUtil;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.WinEventCheckInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WinEventDialog
extends CommonMonitorStringDialog {
    private static Log m_log = LogFactory.getLog(WinEventDialog.class);
    private Button levelCritical = null;
    private Button levelWarning = null;
    private Button levelVerbose = null;
    private Button levelError = null;
    private Button levelInformational = null;
    private Text logName = null;
    private Text source = null;
    private Text eventId = null;
    private Text category = null;
    private Text keywords = null;

    public WinEventDialog(Shell parent) {
        super(parent);
        this.logLineFlag = true;
    }

    public WinEventDialog(Shell parent, int monitorType) {
        super(parent);
        this.logLineFlag = true;
        this.m_monitorType = monitorType;
    }

    public WinEventDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.logLineFlag = true;
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        super.customizeDialog(parent);
        this.shell.setText(Messages.getString((String)"dialog.winevent.create.modify"));
        Label label = null;
        GridData gridData = null;
        Group groupCheckRule = new Group((Composite)this.groupRule, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        groupCheckRule.setText(Messages.getString((String)"check.rule"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"winevent.level")) + " : ");
        this.levelCritical = new Button((Composite)groupCheckRule, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.levelCritical.setLayoutData((Object)gridData);
        this.levelCritical.setText(Messages.getString((String)"winevent.level.critical"));
        this.levelWarning = new Button((Composite)groupCheckRule, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.levelWarning.setLayoutData((Object)gridData);
        this.levelWarning.setText(Messages.getString((String)"winevent.level.warning"));
        this.levelVerbose = new Button((Composite)groupCheckRule, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.levelVerbose.setLayoutData((Object)gridData);
        this.levelVerbose.setText(Messages.getString((String)"winevent.level.verbose"));
        this.levelError = new Button((Composite)groupCheckRule, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.levelError.setLayoutData((Object)gridData);
        this.levelError.setText(Messages.getString((String)"winevent.level.error"));
        this.levelInformational = new Button((Composite)groupCheckRule, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.levelInformational.setLayoutData((Object)gridData);
        this.levelInformational.setText(Messages.getString((String)"winevent.level.informational"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"winevent.log")) + " : ");
        this.logName = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.logName.setLayoutData((Object)gridData);
        this.logName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WinEventDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"winevent.source")) + " : ");
        this.source = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.source.setLayoutData((Object)gridData);
        this.source.setMessage(Messages.getString((String)"message.winevent.1"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"winevent.id")) + " : ");
        this.eventId = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.eventId.setLayoutData((Object)gridData);
        this.eventId.setMessage(Messages.getString((String)"message.winevent.2"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"winevent.category")) + " : ");
        this.category = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.category.setLayoutData((Object)gridData);
        this.category.setMessage(Messages.getString((String)"message.winevent.3"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"winevent.keywords")) + " : ");
        this.keywords = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.keywords.setLayoutData((Object)gridData);
        this.keywords.setMessage(Messages.getString((String)"message.winevent.4"));
        this.m_monitorRule.setRunIntervalEnabled(false);
        this.adjustDialog();
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            try {
                info = MonitorSettingEndpointWrapper.getMonitor(this.monitorId, "MON_WINEVENT");
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        this.setInputData(info);
        this.update();
    }

    @Override
    public void update() {
        super.update();
        if ("".equals(this.logName.getText())) {
            this.logName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.logName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        super.setInputData(monitor);
        this.inputData = monitor;
        WinEventCheckInfo checkInfo = monitor.getWinEventCheckInfo();
        if (checkInfo == null) {
            checkInfo = new WinEventCheckInfo();
            checkInfo.setLevelCritical(true);
            checkInfo.setLevelWarning(true);
            checkInfo.setLevelVerbose(false);
            checkInfo.setLevelError(true);
            checkInfo.setLevelInformational(false);
            checkInfo.getLogName().add("Application");
            checkInfo.getLogName().add("System");
        }
        this.levelCritical.setSelection(checkInfo.isLevelCritical());
        this.levelWarning.setSelection(checkInfo.isLevelWarning());
        this.levelVerbose.setSelection(checkInfo.isLevelVerbose());
        this.levelError.setSelection(checkInfo.isLevelError());
        this.levelInformational.setSelection(checkInfo.isLevelInformational());
        if (checkInfo.getLogName() != null) {
            this.logName.setText(WinEventDialog.listToCommaSeparatedString(checkInfo.getLogName()));
        }
        if (checkInfo.getSource() != null) {
            this.source.setText(WinEventDialog.listToCommaSeparatedString(checkInfo.getSource()));
        }
        if (checkInfo.getEventId() != null) {
            this.eventId.setText(WinEventDialog.listToCommaSeparatedString(checkInfo.getEventId()));
        }
        if (checkInfo.getCategory() != null) {
            this.category.setText(WinEventDialog.listToCommaSeparatedString(checkInfo.getCategory()));
        }
        if (checkInfo.getKeywords() != null) {
            this.keywords.setText(WinEventDialog.keywordLongToString(checkInfo.getKeywords()));
        }
        this.m_stringValueInfo.setInputData(monitor);
    }

    @Override
    protected MonitorInfo createInputData() {
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_WINEVENT");
        WinEventCheckInfo winEventInfo = new WinEventCheckInfo();
        winEventInfo.setMonitorTypeId("MON_WINEVENT");
        winEventInfo.setMonitorId(this.monitorInfo.getMonitorId());
        winEventInfo.setLevelCritical(this.levelCritical.getSelection());
        winEventInfo.setLevelWarning(this.levelWarning.getSelection());
        winEventInfo.setLevelVerbose(this.levelVerbose.getSelection());
        winEventInfo.setLevelError(this.levelError.getSelection());
        winEventInfo.setLevelInformational(this.levelInformational.getSelection());
        for (String logName : WinEventDialog.commaSeparatedStringToStringList(this.logName.getText())) {
            winEventInfo.getLogName().add(logName);
        }
        for (String source : WinEventDialog.commaSeparatedStringToStringList(this.source.getText())) {
            winEventInfo.getSource().add(source);
        }
        for (Integer id : WinEventDialog.commaSeparatedStringToIntegerList(this.eventId.getText())) {
            winEventInfo.getEventId().add(id);
        }
        for (Integer category : WinEventDialog.commaSeparatedStringToIntegerList(this.category.getText())) {
            winEventInfo.getCategory().add(category);
        }
        if (this.keywords.getText() != null && !"".equals(this.keywords.getText())) {
            for (Long keyword : WinEventDialog.keywordStringToLongList(this.keywords.getText())) {
                winEventInfo.getKeywords().add(keyword);
            }
        }
        this.monitorInfo.setWinEventCheckInfo(winEventInfo);
        this.validateResult = this.m_stringValueInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_WINEVENT", (String)this.monitorInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            if (this.validateResult.getID() == null) {
                if (!this.displayQuestion(this.validateResult)) {
                    this.validateResult = null;
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.monitorInfo;
    }

    @Override
    protected boolean action() {
        boolean result;
        block14: {
            result = false;
            MonitorInfo info = this.inputData;
            if (info != null) {
                Object[] args = new String[]{info.getMonitorId()};
                if (!this.updateFlg) {
                    try {
                        result = MonitorSettingEndpointWrapper.addMonitor(info);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.33", (Object[])args));
                            break block14;
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.34", (Object[])args));
                    }
                    catch (MonitorDuplicate_Exception monitorDuplicate_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.53", (Object[])args));
                    }
                    catch (Exception e) {
                        String errMessage = "";
                        if (e instanceof InvalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        } else {
                            errMessage = ", " + e.getMessage();
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.34", (Object[])args)) + errMessage));
                    }
                } else {
                    String errMessage = "";
                    try {
                        result = MonitorSettingEndpointWrapper.modifyMonitor(info);
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        errMessage = ", " + e.getMessage();
                    }
                    if (result) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.35", (Object[])args));
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.36", (Object[])args)) + errMessage));
                    }
                }
            }
        }
        return result;
    }

    private static String listToCommaSeparatedString(List<?> list) {
        if (list != null) {
            String string = list.toString();
            string = string.replace("[", "");
            string = string.replace("]", "");
            return string;
        }
        return null;
    }

    private static List<Integer> commaSeparatedStringToIntegerList(String string) {
        String[] numbers = string.split("\\s*,\\s*");
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            int i = 0;
            while (i < numbers.length) {
                if (numbers[i] != null && !"".equals(numbers[i])) {
                    list.add(Integer.parseInt(numbers[i]));
                }
                ++i;
            }
            return list;
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.winevent.6"));
            return list;
        }
    }

    private static List<Long> keywordStringToLongList(String keywords) {
        ArrayList<Long> longList = new ArrayList<Long>();
        List<String> keywordList = WinEventDialog.commaSeparatedStringToStringList(keywords);
        for (String keyword : keywordList) {
            if (WinEventUtil.containsKeywordString((String)keyword)) {
                longList.add(WinEventUtil.getKeywordLong((String)keyword));
                continue;
            }
            try {
                longList.add(Long.parseLong(keyword));
            }
            catch (NumberFormatException e) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.winevent.7"));
                m_log.error((Object)("unknown keyword : " + keyword));
                throw e;
            }
        }
        return longList;
    }

    private static String keywordLongToString(List<Long> keywordList) {
        ArrayList<String> list = new ArrayList<String>();
        for (Long keyword : keywordList) {
            String keywordStr = WinEventUtil.getKeywordString((long)keyword);
            if (keywordStr != null) {
                list.add(keywordStr);
                continue;
            }
            list.add(keyword.toString());
        }
        return WinEventDialog.listToCommaSeparatedString(list);
    }

    private static List<String> commaSeparatedStringToStringList(String string) {
        String[] strings = string.split("\\s*,\\s*");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < strings.length) {
            if (strings[i] != null && !"".equals(strings[i])) {
                list.add(strings[i]);
            }
            ++i;
        }
        return list;
    }
}

