/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.viewer;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.composite.action.CopyPropertyAction;
import com.clustercontrol.composite.action.DeletePropertyAction;
import com.clustercontrol.editor.ComboPropertyDefine;
import com.clustercontrol.editor.PropertyDefine;
import com.clustercontrol.editor.TextAreaPropertyDefine;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.PropertySheetContentProvider;
import com.clustercontrol.viewer.PropertySheetLabelProvider;
import com.clustercontrol.viewer.PropertySheetModifier;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PropertySheet
extends TableTreeViewer {
    public static final String CLMN_KEY = "key";
    public static final String CLMN_VALUE = "value";
    private TableColumn keyColumn;
    private TableColumn valueColumn;

    public boolean isCopy() {
        TreeSelection selection;
        if (this.getSelection() instanceof TreeSelection && (selection = (TreeSelection)this.getSelection()).getFirstElement() instanceof Property) {
            Property property = (Property)selection.getFirstElement();
            return property.getCopy() == 0;
        }
        return false;
    }

    public PropertySheet(TableTree tree) {
        super(tree);
        Table table = tree.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.keyColumn = new TableColumn(table, 0);
        this.keyColumn.setText(Messages.getString((String)"name"));
        this.valueColumn = new TableColumn(table, 0);
        this.valueColumn.setText(Messages.getString((String)CLMN_VALUE));
        this.setSize(200, 200);
        this.setContentProvider((IContentProvider)new PropertySheetContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new PropertySheetLabelProvider());
        this.setColumnProperties(new String[]{CLMN_KEY, CLMN_VALUE});
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor();
        CellEditor[] editors = cellEditorArray;
        this.setCellEditors(editors);
        this.setCellModifier(new PropertySheetModifier(this));
        this.createContextMenu();
    }

    public void setSize(int keyColumnSize, int valueColumnSize) {
        this.keyColumn.setWidth(keyColumnSize);
        this.valueColumn.setWidth(valueColumnSize);
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (PropertySheet.this.isCopy()) {
                    PropertySheet.this.fillContextMenu(manager);
                }
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.getTableTree());
        this.getTableTree().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)new CopyPropertyAction(this));
        manager.add((IAction)new DeletePropertyAction(this));
    }

    public void setInput(Property property) {
        Object[] childrens = property.getChildren();
        int i = 0;
        while (i < childrens.length) {
            Property children = (Property)childrens[i];
            this.setPropertyDefine(children);
            ++i;
        }
        super.setInput((Object)property);
    }

    public void setPropertyDefine(Property property) {
        if (property.getDefine() == null) {
            PropertyDefine define = null;
            try {
                define = (PropertyDefine)Class.forName(property.getEditor()).newInstance();
                if (property.getEditor().compareTo(PropertyDefineConstant.EDITOR_SELECT) == 0) {
                    ((ComboPropertyDefine)define).setValues(property.getSelectValues());
                } else if (property.getEditor().compareTo(PropertyDefineConstant.EDITOR_TEXTAREA) == 0) {
                    ((TextAreaPropertyDefine)define).setTitle(property.getName());
                    if (property.getModify() == 1) {
                        ((TextAreaPropertyDefine)define).setModify(true);
                    }
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {}
            property.setDefine(define);
        }
        if (property.getEditor().compareTo(PropertyDefineConstant.EDITOR_SELECT) == 0) {
            Object[][] value = property.getSelectValues();
            int j = 0;
            while (j < value[1].length) {
                HashMap map;
                ArrayList propertyList;
                if (value[1][j] instanceof HashMap && (propertyList = (ArrayList)(map = (HashMap)value[1][j]).get("property")) instanceof ArrayList) {
                    int k = 0;
                    while (k < propertyList.size()) {
                        Property children = (Property)propertyList.get(k);
                        this.setPropertyDefine(children);
                        ++k;
                    }
                }
                ++j;
            }
        }
        Object[] childrens = property.getChildren();
        int i = 0;
        while (i < childrens.length) {
            Property children1 = (Property)childrens[i];
            this.setPropertyDefine(children1);
            ++i;
        }
    }
}

