/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.viewer;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.editor.TextAreaDialogCellEditor;
import com.clustercontrol.viewer.CommonTableContentProvider;
import com.clustercontrol.viewer.CommonTableLabelProvider;
import com.clustercontrol.viewer.CommonTableViewerModifier;
import com.clustercontrol.viewer.CommonTableViewerSorter;
import com.clustercontrol.viewer.ICommonTableLabelProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CommonTableViewer
extends TableViewer {
    private ArrayList<TableColumnInfo> m_tableColumnList = null;
    private boolean m_sortType = true;

    public CommonTableViewer(Composite parent) {
        super(parent);
        this.setLabelProvider((IBaseLabelProvider)new CommonTableLabelProvider(this));
        this.setContentProvider((IContentProvider)new CommonTableContentProvider());
        this.setCellModifier(new CommonTableViewerModifier(this));
    }

    public CommonTableViewer(Composite parent, int style) {
        super(parent, style);
        this.setLabelProvider((IBaseLabelProvider)new CommonTableLabelProvider(this));
        this.setContentProvider((IContentProvider)new CommonTableContentProvider());
        this.setCellModifier(new CommonTableViewerModifier(this));
    }

    public CommonTableViewer(Table table) {
        super(table);
        this.setLabelProvider((IBaseLabelProvider)new CommonTableLabelProvider(this));
        this.setContentProvider((IContentProvider)new CommonTableContentProvider());
        this.setCellModifier(new CommonTableViewerModifier(this));
    }

    public void createTableColumn(ArrayList<TableColumnInfo> tableColumnList, int sortColumnIndex, int sortOrder) {
        this.createTableColumn(tableColumnList, sortColumnIndex, -1, sortOrder);
    }

    public void createTableColumn(ArrayList<TableColumnInfo> tableColumnList, int sortColumnIndex, int sortColumnIndex2, int sortOrder) {
        this.m_tableColumnList = tableColumnList;
        String[] properties = new String[this.m_tableColumnList.size()];
        CellEditor[] editors = new CellEditor[this.m_tableColumnList.size()];
        int i = 0;
        while (i < this.m_tableColumnList.size()) {
            TableColumnInfo tableColumnInfo = this.m_tableColumnList.get(i);
            TableColumn column = new TableColumn(this.getTable(), tableColumnInfo.getStyle(), i);
            column.setText(tableColumnInfo.getName());
            column.setWidth(tableColumnInfo.getWidth());
            properties[i] = String.valueOf(i);
            if (tableColumnInfo.getType() == 19) {
                TextAreaDialogCellEditor dialog = new TextAreaDialogCellEditor((Composite)this.getTable());
                dialog.setTitle(tableColumnInfo.getName());
                dialog.setModify(false);
                editors[i] = dialog;
            } else {
                editors[i] = null;
            }
            if (i == 0) {
                int order = sortOrder;
                tableColumnInfo.setOrder(order);
                this.setSorter(new CommonTableViewerSorter(sortColumnIndex, sortColumnIndex2, order));
            }
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    ArrayList<TableColumnInfo> tableColumnList = CommonTableViewer.this.getTableColumnList();
                    int i = 0;
                    while (i < tableColumnList.size()) {
                        TableColumnInfo tableColumnInfo = tableColumnList.get(i);
                        if (tableColumnInfo.getName().compareTo(column.getText()) == 0) {
                            int order = tableColumnInfo.getOrder() * -1;
                            tableColumnInfo.setOrder(order);
                            CommonTableViewer.this.setSorter(new CommonTableViewerSorter(i, -1, order));
                            break;
                        }
                        ++i;
                    }
                }
            });
            ++i;
        }
        this.setColumnProperties(properties);
        this.setCellEditors(editors);
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            if (fullMap) {
                this.associate(element, (Item)item);
            } else {
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            IBaseLabelProvider prov = this.getLabelProvider();
            ICommonTableLabelProvider tprov = null;
            if (prov instanceof ICommonTableLabelProvider) {
                tprov = (ICommonTableLabelProvider)prov;
                int columnCount = super.getTable().getColumnCount();
                TableItem ti = item;
                int column = 0;
                while (column < columnCount || column == 0) {
                    String text = "";
                    Image image = null;
                    Color color = null;
                    if (tprov != null) {
                        text = tprov.getColumnText(element, column);
                        image = tprov.getColumnImage(element, column);
                        color = tprov.getColumnColor(element, column);
                    }
                    ti.setText(column, text);
                    if (ti.getImage(column) != image) {
                        ti.setImage(column, image);
                    }
                    if (color != null) {
                        ti.setBackground(column, color);
                    }
                    ++column;
                }
                if (prov instanceof IColorProvider) {
                    IColorProvider cprov = (IColorProvider)prov;
                    ti.setForeground(cprov.getForeground(element));
                    ti.setBackground(cprov.getBackground(element));
                }
                if (prov instanceof IFontProvider) {
                    IFontProvider fprov = (IFontProvider)prov;
                    ti.setFont(fprov.getFont(element));
                }
            } else {
                super.doUpdateItem(widget, element, fullMap);
            }
        }
    }

    public ArrayList<TableColumnInfo> getTableColumnList() {
        return this.m_tableColumnList;
    }

    public int getTableColumnIndex(int type) {
        int index = -1;
        int i = 0;
        while (i < this.m_tableColumnList.size()) {
            TableColumnInfo tableColumn = this.m_tableColumnList.get(i);
            if (type == tableColumn.getType()) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public void setInput(ArrayList infoList) {
        super.setInput((Object)infoList);
    }
}

