/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.viewer;

import com.clustercontrol.bean.CheckBoxImageConstant;
import com.clustercontrol.bean.CollectiveRunStatusImageConstant;
import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.EndStatusImageConstant;
import com.clustercontrol.bean.FacilityImageConstant;
import com.clustercontrol.bean.JobImageConstant;
import com.clustercontrol.bean.PerformanceStatusImageConstant;
import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.collectiverun.bean.CollectiveRunStatusConstant;
import com.clustercontrol.jobmanagement.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobParamTypeConstant;
import com.clustercontrol.jobmanagement.bean.JudgmentObjectConstant;
import com.clustercontrol.jobmanagement.bean.ScheduleOnOffImageConstant;
import com.clustercontrol.jobmanagement.bean.StatusImageConstant;
import com.clustercontrol.monitor.bean.ConfirmConstant;
import com.clustercontrol.notify.util.NotifyTypeUtil;
import com.clustercontrol.performance.bean.PerformanceStatusConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.TimeTo48hConverter;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.viewer.ICommonTableLabelProvider;
import com.clustercontrol.ws.common.Schedule;
import java.sql.Time;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class CommonTableLabelProvider
extends LabelProvider
implements ICommonTableLabelProvider {
    private static Log m_log = LogFactory.getLog(CommonTableLabelProvider.class);
    private CommonTableViewer m_viewer;

    public CommonTableLabelProvider(CommonTableViewer viewer) {
        this.m_viewer = viewer;
    }

    public String getColumnText(Object element, int columnIndex) {
        ArrayList<TableColumnInfo> tableColumnList = this.m_viewer.getTableColumnList();
        ArrayList list = (ArrayList)element;
        Object item = list.get(columnIndex);
        TableColumnInfo tableColumn = tableColumnList.get(columnIndex);
        if (item == null) {
            return "";
        }
        if (tableColumn.getType() == 1) {
            return JobConstant.typeToString((int)((Number)item).intValue());
        }
        if (tableColumn.getType() == 0) {
            return StatusConstant.typeToString((int)((Number)item).intValue());
        }
        if (tableColumn.getType() == 14) {
            return CollectiveRunStatusConstant.typeToString((int)((Number)item).intValue());
        }
        if (tableColumn.getType() == 3) {
            return PriorityConstant.typeToString((int)((Number)item).intValue());
        }
        if (tableColumn.getType() == 4) {
            return ValidConstant.typeToString((int)((Number)item).intValue());
        }
        if (tableColumn.getType() == 5) {
            return JudgmentObjectConstant.typeToString((int)((Number)item).intValue());
        }
        if (tableColumn.getType() == 20) {
            return NotifyTypeUtil.typeToString(((Number)item).intValue());
        }
        if (tableColumn.getType() == 6) {
            Class<?> itemClass = item.getClass();
            if (itemClass == Date.class) {
                return TimeTo48hConverter.dateTo48hms((Date)item);
            }
            if (itemClass == String.class) {
                return String.valueOf(item);
            }
            if (itemClass.getSuperclass() == Number.class) {
                return ((Number)item).toString();
            }
        } else {
            if (tableColumn.getType() == 7) {
                Schedule schedule = (Schedule)item;
                String scheduleString = null;
                DecimalFormat format = new DecimalFormat("00");
                if (schedule.getType() == 1) {
                    if (schedule.getMonth() != null) {
                        scheduleString = String.valueOf(format.format(schedule.getMonth())) + "/" + format.format(schedule.getDay()) + " " + format.format(schedule.getHour()) + ":" + format.format(schedule.getMinute());
                    } else if (schedule.getDay() != null) {
                        scheduleString = String.valueOf(format.format(schedule.getDay())) + Messages.getString((String)"monthday") + " " + format.format(schedule.getHour()) + ":" + format.format(schedule.getMinute());
                    } else if (schedule.getHour() != null) {
                        scheduleString = String.valueOf(format.format(schedule.getHour())) + ":" + format.format(schedule.getMinute());
                    } else if (schedule.getMinute() != null) {
                        scheduleString = String.valueOf(format.format(schedule.getMinute())) + Messages.getString((String)"minute");
                    }
                } else if (schedule.getType() == 2) {
                    scheduleString = schedule.getHour() != null ? String.valueOf(DayOfWeekConstant.typeToString(schedule.getWeek())) + " " + format.format(schedule.getHour()) + ":" + format.format(schedule.getMinute()) : String.valueOf(DayOfWeekConstant.typeToString(schedule.getWeek())) + " " + format.format(schedule.getMinute()) + Messages.getString((String)"minute");
                } else {
                    m_log.warn((Object)"CommonTableLabelProvider 165");
                }
                return scheduleString;
            }
            if (tableColumn.getType() == 8) {
                return ConfirmConstant.typeToString((int)((Number)item).intValue());
            }
            if (tableColumn.getType() == 9) {
                return YesNoConstant.typeToString((int)((Number)item).intValue());
            }
            if (tableColumn.getType() == 10) {
                return ProcessConstant.typeToString((int)((Number)item).intValue());
            }
            if (tableColumn.getType() == 11) {
                return EndStatusConstant.typeToString((int)((Number)item).intValue());
            }
            if (tableColumn.getType() == 15) {
                return "";
            }
            if (tableColumn.getType() == 16) {
                return DayOfWeekConstant.typeToString(((Number)item).intValue());
            }
            if (tableColumn.getType() == 17) {
                return "";
            }
            if (tableColumn.getType() == 18) {
                return JobParamTypeConstant.typeToString((int)((Number)item).intValue());
            }
            if (tableColumn.getType() == 24) {
                return PerformanceStatusConstant.typeToString(((Number)item).intValue());
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == String.class) {
                return String.valueOf(item);
            }
            if (itemClass == Date.class) {
                return DateFormat.getDateTimeInstance().format((Date)item);
            }
            if (itemClass == Time.class) {
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
                return formatter.format((Time)item);
            }
            if (itemClass.getSuperclass() == Number.class) {
                return ((Number)item).toString();
            }
            if (itemClass.isEnum()) {
                return ((Enum)item).toString();
            }
        }
        return "";
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ArrayList<TableColumnInfo> tableColumnList = this.m_viewer.getTableColumnList();
        ArrayList list = (ArrayList)element;
        Object item = list.get(columnIndex);
        TableColumnInfo tableColumn = tableColumnList.get(columnIndex);
        if (item == null) {
            return null;
        }
        if (tableColumn.getType() == 1) {
            return JobImageConstant.typeToImage(((Number)item).intValue());
        }
        if (tableColumn.getType() == 2) {
            Pattern p = Pattern.compile(".*>");
            Matcher m = p.matcher((String)item);
            if (m.matches()) {
                return FacilityImageConstant.typeToImage(0);
            }
            return FacilityImageConstant.typeToImage(1);
        }
        if (tableColumn.getType() == 0) {
            return StatusImageConstant.typeToImage(((Number)item).intValue());
        }
        if (tableColumn.getType() == 14) {
            return CollectiveRunStatusImageConstant.typeToImage(((Number)item).intValue());
        }
        if (tableColumn.getType() == 11) {
            return EndStatusImageConstant.typeToImage(((Number)item).intValue());
        }
        if (tableColumn.getType() == 15) {
            return CheckBoxImageConstant.typeToImage((Boolean)item);
        }
        if (tableColumn.getType() == 17) {
            return ScheduleOnOffImageConstant.dateToImage(new Date((Long)item));
        }
        if (tableColumn.getType() == 24) {
            return PerformanceStatusImageConstant.typeToImage(((Number)item).intValue());
        }
        return null;
    }

    @Override
    public Color getColumnColor(Object element, int columnIndex) {
        ArrayList<TableColumnInfo> tableColumnList = this.m_viewer.getTableColumnList();
        ArrayList list = (ArrayList)element;
        Object item = list.get(columnIndex);
        TableColumnInfo tableColumn = tableColumnList.get(columnIndex);
        if (item == null) {
            return null;
        }
        if (tableColumn.getType() == 3) {
            return PriorityColorConstant.typeToColor(((Number)item).intValue());
        }
        return null;
    }
}

