/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.util;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.accesscontrol.dialog.LoginDialog;
import com.clustercontrol.accesscontrol.etc.action.LogoutAction;
import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.util.BasicAuth;
import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PerspectiveUtil;
import com.clustercontrol.ws.access.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import java.net.Authenticator;
import java.net.URL;
import java.rmi.AccessException;
import java.sql.Timestamp;
import javax.naming.CommunicationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;

public class LoginManager {
    private static Log m_log = LogFactory.getLog(LoginManager.class);
    public static final String KEY_EJB_URL = "ejbUrl";
    public static final String KEY_EJB_URL_NUM = "numOfUrlHistory";
    public static final String VALUE_EJB_URL = "http://localhost:8080/HinemosWS/";
    public static final String KEY_EJB_UID = "ejbUid";
    public static final String VALUE_EJB_UID = "hinemos";
    public static final String KEY_INTERVAL = "managerPollingInterval";
    public static final int VALUE_INTERVAL = 60;
    public static final String USER_OBJECT_ID = "com.clustercontrol.accesscontrol.user";
    public static final String URL_OBJECT_ID = "com.clustercontrol.accesscontrol.url";
    public static final String ACTION_SET_ID = "com.clustercontrol.accesscontrol.ActionSet";
    public static final String ACTION_ID_LOGIN = "com.clustercontrol.accesscontrol.etc.action.LoginAction";
    public static final String ACTION_ID_LOGOUT = "com.clustercontrol.accesscontrol.etc.action.LogoutAction";
    public static final String KEY_HTTP_CONNECT_TIMEOUT = "httpConnectTimeout";
    public static final int VALUE_HTTP_CONNECT_TIMEOUT = 10;
    public static final String KEY_HTTP_REQUEST_TIMEOUT = "httpRequestTimeout";
    public static final int VALUE_HTTP_REQUEST_TIMEOUT = 60;
    public static final String KEY_HTTPS_KEYSTORE_PATH = "httpsKeystorePath";
    public static final String VALUE_HTTPS_KEYSTORE_PATH = "";
    public static final String KEY_HTTPS_KEYSTORE_PASSWORD = "httpsKeystorePassword";
    public static final String VALUE_HTTPS_KEYSTORE_PASSWORD = "";
    public static final String KEY_PROXY_HOST = "proxyHost";
    public static final String VALUE_PROXY_HOST = "";
    public static final String KEY_PROXY_PORT = "proxyPort";
    public static final int VALUE_PROXY_PORT = 8080;
    public static final String KEY_PROXY_USER = "proxyUser";
    public static final String VALUE_PROXY_USER = "";
    public static final String KEY_PROXY_PASSWORD = "proxyPassword";
    public static final String VALUE_PROXY_PASSWORD = "";
    private static String m_url = null;
    private static String m_uid = null;
    private static String m_password = null;
    private static Display m_dislpay = null;
    private static IStatusLineManager m_lineManager = null;
    private static boolean openInformation = false;

    private LoginManager() {
    }

    private static synchronized void login(String uid, String password, String url) throws Exception {
        m_uid = uid;
        m_password = password;
        m_url = url;
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        int httpConnectTimeout = store.getInt(KEY_HTTP_CONNECT_TIMEOUT);
        int httpRequestTimeout = store.getInt(KEY_HTTP_REQUEST_TIMEOUT);
        m_log.info((Object)("connect.timeout=" + httpConnectTimeout + ", request.timeout=" + httpRequestTimeout));
        URL u = new URL(url);
        String keyStorePath = store.getString(KEY_HTTPS_KEYSTORE_PATH);
        String keyStorePassword = store.getString(KEY_HTTPS_KEYSTORE_PASSWORD);
        if ("https".equals(u.getProtocol())) {
            System.setProperty("javax.net.ssl.trustStore", keyStorePath);
            System.setProperty("javax.net.ssl.trustStorePassword", keyStorePassword);
            m_log.info((Object)("keystore.path=" + System.getProperty("javax.net.ssl.trustStore")));
        }
        String proxyHost = store.getString(KEY_PROXY_HOST);
        int proxyPort = store.getInt(KEY_PROXY_PORT);
        String proxyUser = store.getString(KEY_PROXY_USER);
        String proxyPassword = store.getString(KEY_PROXY_PASSWORD);
        if (!"".equals(proxyHost)) {
            System.setProperty(String.valueOf(u.getProtocol()) + ".proxyHost", proxyHost);
            System.setProperty(String.valueOf(u.getProtocol()) + ".proxyPort", Integer.toString(proxyPort));
            BasicAuth basicAuth = new BasicAuth(proxyUser, proxyPassword);
            Authenticator.setDefault(basicAuth);
            m_log.info((Object)("proxy.host=" + System.getProperty(String.valueOf(u.getProtocol()) + ".proxyHost") + ", proxy.port=" + System.getProperty("http.proxyPort") + ", proxy.user=" + proxyUser));
        }
        EndpointManager.init(uid, password, url, httpConnectTimeout, httpRequestTimeout);
        try {
            AccessEndpointWrapper.checkLogin();
            IWorkbench workbench = PlatformUI.getWorkbench();
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
            WWinActionBars bars = workbenchWindow.getActionBars();
            m_lineManager = bars.getStatusLineManager();
            m_dislpay = workbench.getDisplay();
            StatusLineContributionItem statusLine = new StatusLineContributionItem(USER_OBJECT_ID, 100);
            statusLine.setText(String.valueOf(Messages.getString((String)"hinemos.user")) + " : " + m_uid + "     " + Messages.getString((String)"connection.url") + " : " + m_url);
            m_lineManager.add((IContributionItem)statusLine);
            m_lineManager.update(true);
            store.setValue(KEY_EJB_URL, url);
            store.setValue(KEY_EJB_UID, uid);
            int numOfUrlHistory = store.getInt(KEY_EJB_URL_NUM);
            boolean urlExist = false;
            int i = 0;
            while (i < numOfUrlHistory) {
                String histUrl = store.getString("ejbUrl_" + i);
                if (url.equals(histUrl)) {
                    urlExist = true;
                    break;
                }
                ++i;
            }
            if (!urlExist && !url.equals("")) {
                store.setValue("ejbUrl_" + numOfUrlHistory, url);
                store.setValue(KEY_EJB_URL_NUM, ++numOfUrlHistory);
            }
            LocalSession.clearSessionData();
            LocalSession.getLocalSession().startChecktask(LoginManager.getInterval());
        }
        catch (Exception e) {
            LoginManager.logout();
            throw e;
        }
    }

    public static synchronized void logout() {
        if (!LoginManager.isLogin()) {
            return;
        }
        if (JobEditStateUtil.getLockedJobunitList().size() > 0) {
            for (JobInfo jobunit : JobEditStateUtil.getLockedJobunitList()) {
                try {
                    JobEndpointWrapper.releaseEditLock(JobEditStateUtil.getEditSession(jobunit));
                    JobEditStateUtil.removeLockedJobunit(jobunit);
                }
                catch (Exception e) {
                    m_log.warn((Object)("dispose() : " + e.getMessage()));
                }
            }
        }
        JobEditStateUtil.clearEditStateAll();
        PerspectiveUtil.closeAllHinemosPerspective();
        EndpointManager.logout();
        m_uid = null;
        m_url = null;
        if (m_lineManager != null) {
            IContributionItem item = m_lineManager.find(USER_OBJECT_ID);
            m_lineManager.remove(item);
            m_lineManager.update(true);
        }
        LocalSession.clearSessionData();
        LocalSession.getLocalSession().stopChecktask();
    }

    public static boolean isLogin() {
        return m_uid != null;
    }

    public static synchronized void login() {
        if (!LoginManager.isLogin()) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            LoginDialog dialog = new LoginDialog(shell);
            int loginRet = dialog.open();
            if (loginRet != 0) {
                m_log.info((Object)("login() : cancel, " + loginRet));
                PerspectiveUtil.closeAllHinemosPerspective();
                return;
            }
            try {
                LoginManager.login(dialog.getUserid(), dialog.getPassword(), dialog.getUrl());
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.accesscontrol.5"));
                m_log.info((Object)("Login Success : userId = " + dialog.getUserid() + ", url = " + dialog.getUrl()));
                m_log.info((Object)"Hinemos Client started");
            }
            catch (CommunicationException e) {
                Status status = new Status(4, ClusterControlPlugin.getPluginId(), 0, Messages.getString((String)"message.accesscontrol.22"), (Throwable)e);
                ErrorDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.accesscontrol.21"), (IStatus)status);
                m_log.info((Object)("Login Fail : userId = " + dialog.getUserid() + ", url = " + dialog.getUrl()));
                LoginManager.login();
            }
            catch (AccessException accessException) {
                MessageDialog.openWarning(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.accesscontrol.6"));
                m_log.info((Object)("Login Fail : userId = " + dialog.getUserid() + ", url = " + dialog.getUrl()));
                LoginManager.login();
            }
            catch (InvalidUserPass_Exception invalidUserPass_Exception) {
                MessageDialog.openWarning(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.accesscontrol.45"));
                m_log.info((Object)("Login Fail : userId = " + dialog.getUserid() + ", url = " + dialog.getUrl()));
                LoginManager.login();
            }
            catch (Exception e) {
                Status status = new Status(4, ClusterControlPlugin.getPluginId(), 0, Messages.getString((String)"message.accesscontrol.23"), (Throwable)e);
                ErrorDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.accesscontrol.6"), (IStatus)status);
                m_log.info((Object)("Login Fail : userId = " + dialog.getUserid() + ", url = " + dialog.getUrl()));
                LoginManager.login();
            }
        }
    }

    public static String getUrl() {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        String url = store.getString(KEY_EJB_URL);
        if (url.compareTo("") == 0) {
            url = VALUE_EJB_URL;
        }
        return url;
    }

    private static int getInterval() {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        int interval = store.getInt(KEY_INTERVAL);
        return interval;
    }

    public static String getUserId() {
        return m_uid;
    }

    public static String getPassword() {
        return m_password;
    }

    private static boolean checkAsyncExec(Runnable r) {
        if (m_dislpay == null) {
            return false;
        }
        if (!m_dislpay.isDisposed()) {
            m_dislpay.asyncExec(r);
            return true;
        }
        return false;
    }

    public static void disconnectManager() {
        LoginManager.checkAsyncExec(new Runnable(){

            @Override
            public void run() {
                if (!openInformation) {
                    openInformation = true;
                    Object[] args = new String[]{new Timestamp(System.currentTimeMillis()).toString()};
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.force.disconnect", (Object[])args));
                    new LogoutAction().runLogout();
                    openInformation = false;
                }
            }
        });
    }

    public static void restartChecktask(int interval) {
        LocalSession.getLocalSession().restartChecktask(interval);
    }
}

