/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.util;

import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FacilityTreeItemUtil {
    private static Log m_log = LogFactory.getLog(FacilityTreeItemUtil.class);

    public static synchronized FacilityTreeItem deepCopy(FacilityTreeItem item, FacilityTreeItem parentItem) {
        FacilityTreeItem resultItem = new FacilityTreeItem();
        if (item.getData() != null) {
            FacilityInfo resultData = new FacilityInfo();
            if (item.getData().isBuiltInFlg() != null) {
                resultData.setBuiltInFlg(new Boolean(item.getData().isBuiltInFlg()));
            }
            if (item.getData().getCreateDatetime() != null) {
                resultData.setCreateDatetime(new Long(item.getData().getCreateDatetime()));
            }
            resultData.setCreateUserId(item.getData().getCreateUserId());
            resultData.setDescription(item.getData().getDescription());
            if (item.getData().getDisplaySortOrder() != null) {
                resultData.setDisplaySortOrder(new Integer(item.getData().getDisplaySortOrder()));
            }
            resultData.setFacilityId(item.getData().getFacilityId());
            resultData.setFacilityName(item.getData().getFacilityName());
            if (item.getData().getFacilityType() != null) {
                resultData.setFacilityType(new Integer(item.getData().getFacilityType()));
            }
            if (item.getData().getModifyDatetime() != null) {
                resultData.setModifyDatetime(new Long(item.getData().getModifyDatetime()));
            }
            resultData.setModifyUserId(item.getData().getModifyUserId());
            if (item.getData().isValid() != null) {
                resultData.setValid(new Boolean(item.getData().isValid()));
            }
            resultData.setOwnerRoleId(item.getData().getOwnerRoleId());
            if (item.getData().isNotReferFlg() != null) {
                resultData.setNotReferFlg(new Boolean(item.getData().isNotReferFlg()));
            }
            resultItem.setData(resultData);
        }
        if (item.getChildren() != null) {
            ArrayList<FacilityTreeItem> resultChildren = new ArrayList<FacilityTreeItem>();
            for (FacilityTreeItem child : item.getChildren()) {
                if (child != null) {
                    FacilityTreeItem resultChild = FacilityTreeItemUtil.deepCopy(child, resultItem);
                    resultChildren.add(resultChild);
                    continue;
                }
                resultChildren.add(null);
            }
            resultItem.getChildren().clear();
            resultItem.getChildren().addAll(resultChildren);
        } else {
            resultItem.getChildren().clear();
        }
        resultItem.setParent(parentItem);
        return resultItem;
    }

    public static void addChild(FacilityTreeItem parent, FacilityTreeItem child) {
        List facilityTreeItemList = parent.getChildren();
        facilityTreeItemList.add(child);
        child.setParent(parent);
    }

    public static boolean removeChild(FacilityTreeItem parent, String facilityId) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (facilityId.equals(((FacilityTreeItem)children.get(i)).getData().getFacilityId())) {
                children.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean keepChild(FacilityTreeItem parent, String facilityId) {
        boolean ret = false;
        if (facilityId == null) {
            return ret;
        }
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (!facilityId.equals(((FacilityTreeItem)children.get(i)).getData().getFacilityId())) {
                children.remove(i);
                FacilityTreeItemUtil.keepChild(parent, facilityId);
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    public static boolean removeNode(FacilityTreeItem parent) {
        boolean flag = false;
        List children = parent.getChildren();
        int i = children.size() - 1;
        while (i >= 0) {
            if (((FacilityTreeItem)children.get(i)).getData().getFacilityType() == 1) {
                children.remove(i);
                flag = true;
            } else {
                boolean tmpFlag = FacilityTreeItemUtil.removeNode((FacilityTreeItem)children.get(i));
                flag = flag || tmpFlag;
            }
            --i;
        }
        return flag;
    }
}

