/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.monitor.run.dialog.CommonMonitorDialog;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.snmptrap.composite.OidListComposite;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.MonitorTrapValueInfo;
import com.clustercontrol.ws.monitor.TrapCheckInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SnmpTrapCreateDialog
extends CommonMonitorDialog {
    public static final int MAX_COLUMN = 20;
    public static final int MAX_COLUMN_SMALL = 15;
    public static final int WIDTH_TITLE = 6;
    public static final int WIDTH_TITLE_WIDE = 8;
    public static final int WIDTH_TITLE_SMALL = 4;
    public static final int WIDTH_VALUE = 2;
    private final int sizeX = 750;
    private final int sizeY = 760;
    private Button buttonCommunityCheckOff = null;
    private Button buttonCommunityCheckOn = null;
    private Text textCommunityName = null;
    private Button buttonCharsetConvertOff = null;
    private Button buttonCharsetConvertOn = null;
    private Text textCharsetName = null;
    private OidListComposite oidListComposite = null;

    public SnmpTrapCreateDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public SnmpTrapCreateDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    protected Point getInitialSize() {
        return new Point(750, 760);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.snmptrap.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 20;
        parent.setLayout((Layout)layout);
        this.m_monitorBasic = new MonitorBasicScopeComposite(parent, 0, true, this);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorBasic.setLayoutData(gridData);
        this.groupRule = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 20;
        this.groupRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupRule.setLayoutData((Object)gridData);
        this.groupRule.setText(Messages.getString((String)"monitor.rule"));
        this.m_monitorRule = new MonitorRuleComposite((Composite)this.groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorRule.setLayoutData(gridData);
        this.m_monitorRule.setRunIntervalEnabled(false);
        this.groupMonitor = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 20;
        this.groupMonitor.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupMonitor.setLayoutData((Object)gridData);
        this.groupMonitor.setText(Messages.getString((String)"monitor.run"));
        this.confirmMonitorValid = new Button((Composite)this.groupMonitor, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmMonitorValid.setLayoutData((Object)gridData);
        this.confirmMonitorValid.setText(Messages.getString((String)"monitor.run"));
        this.confirmMonitorValid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SnmpTrapCreateDialog.this.confirmMonitorValid.getSelection()) {
                    SnmpTrapCreateDialog.this.setMonitorEnabled(true);
                } else {
                    SnmpTrapCreateDialog.this.setMonitorEnabled(false);
                }
            }
        });
        Group groupCheckRule = new Group((Composite)this.groupMonitor, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 20;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        groupCheckRule.setText(Messages.getString((String)"trap.definition"));
        Group groupCommunity = new Group((Composite)groupCheckRule, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 20;
        groupCommunity.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        groupCommunity.setLayoutData((Object)gridData);
        groupCommunity.setText(Messages.getString((String)"community"));
        this.buttonCommunityCheckOff = new Button((Composite)groupCommunity, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonCommunityCheckOff.setLayoutData((Object)gridData);
        this.buttonCommunityCheckOff.setText(Messages.getString((String)"community.no.check"));
        this.buttonCommunityCheckOn = new Button((Composite)groupCommunity, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonCommunityCheckOn.setLayoutData((Object)gridData);
        this.buttonCommunityCheckOn.setText(String.valueOf(Messages.getString((String)"community.name")) + " : ");
        this.textCommunityName = new Text((Composite)groupCommunity, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textCommunityName.setLayoutData((Object)gridData);
        this.textCommunityName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SnmpTrapCreateDialog.this.update();
            }
        });
        this.buttonCommunityCheckOff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnmpTrapCreateDialog.this.update();
                SnmpTrapCreateDialog.this.textCommunityName.setEnabled(false);
            }
        });
        this.buttonCommunityCheckOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnmpTrapCreateDialog.this.update();
                SnmpTrapCreateDialog.this.textCommunityName.setEnabled(true);
            }
        });
        label = new Label((Composite)groupCommunity, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Group groupCharset = new Group((Composite)groupCheckRule, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 20;
        groupCharset.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        groupCharset.setLayoutData((Object)gridData);
        groupCharset.setText(Messages.getString((String)"charset.convert"));
        this.buttonCharsetConvertOff = new Button((Composite)groupCharset, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonCharsetConvertOff.setLayoutData((Object)gridData);
        this.buttonCharsetConvertOff.setText(Messages.getString((String)"charset.no.convert"));
        this.buttonCharsetConvertOn = new Button((Composite)groupCharset, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonCharsetConvertOn.setLayoutData((Object)gridData);
        this.buttonCharsetConvertOn.setText(String.valueOf(Messages.getString((String)"charset.snmptrap.code")) + " : ");
        this.textCharsetName = new Text((Composite)groupCharset, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textCharsetName.setLayoutData((Object)gridData);
        this.textCharsetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SnmpTrapCreateDialog.this.update();
            }
        });
        this.buttonCharsetConvertOff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnmpTrapCreateDialog.this.update();
                SnmpTrapCreateDialog.this.textCharsetName.setEnabled(false);
            }
        });
        this.buttonCharsetConvertOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnmpTrapCreateDialog.this.update();
                SnmpTrapCreateDialog.this.textCharsetName.setEnabled(true);
            }
        });
        label = new Label((Composite)groupCharset, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Group groupOid = new Group((Composite)groupCheckRule, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupOid.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        groupOid.setLayoutData((Object)gridData);
        groupOid.setText("OID");
        this.oidListComposite = new OidListComposite((Composite)groupOid, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.oidListComposite.setLayoutData(gridData);
        this.groupNotifyAttribute = new Group((Composite)this.groupMonitor, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        this.groupNotifyAttribute.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 20;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.groupNotifyAttribute.setLayoutData((Object)gridData);
        this.groupNotifyAttribute.setText(Messages.getString((String)"notify.attribute"));
        this.m_notifyInfo = new NotifyInfoComposite((Composite)this.groupNotifyAttribute, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_notifyInfo.setLayoutData(gridData);
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 20;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(800, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            try {
                info = MonitorSettingEndpointWrapper.getMonitor(this.monitorId, "MON_SNMP_TRP");
            }
            catch (Exception e) {
                String errMessage = "";
                if (e instanceof InvalidRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                } else {
                    errMessage = ", " + e.getMessage();
                }
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.traputil.4")) + errMessage));
            }
        }
        this.setInputData(info);
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        ArrayList monitorTrapValueInfoList;
        super.setInputData(monitor);
        this.inputData = monitor;
        TrapCheckInfo checkInfo = monitor.getTrapCheckInfo();
        if (checkInfo == null) {
            checkInfo = new TrapCheckInfo();
            checkInfo.setCheckMode(Integer.valueOf(0));
            checkInfo.setCommunityCheck(Integer.valueOf(0));
            checkInfo.setCharsetConvert(Integer.valueOf(0));
        }
        if ((monitorTrapValueInfoList = monitor.getTrapValueInfo()) == null) {
            monitorTrapValueInfoList = new ArrayList();
        }
        if (checkInfo.getCommunityName() != null) {
            this.textCommunityName.setText(checkInfo.getCommunityName());
        }
        if (checkInfo.getCommunityCheck() == 1) {
            this.buttonCommunityCheckOn.setSelection(true);
            this.buttonCommunityCheckOff.setSelection(false);
            this.textCommunityName.setEnabled(true);
        } else {
            this.buttonCommunityCheckOn.setSelection(false);
            this.buttonCommunityCheckOff.setSelection(true);
            this.textCommunityName.setEnabled(false);
        }
        if (checkInfo.getCharsetName() != null) {
            this.textCharsetName.setText(checkInfo.getCharsetName());
        }
        if (checkInfo.getCharsetConvert() == 1) {
            this.buttonCharsetConvertOn.setSelection(true);
            this.buttonCharsetConvertOff.setSelection(false);
            this.textCharsetName.setEnabled(true);
        } else {
            this.buttonCharsetConvertOn.setSelection(false);
            this.buttonCharsetConvertOff.setSelection(true);
            this.textCharsetName.setEnabled(false);
        }
        this.oidListComposite.setCheckMode(checkInfo.getCheckMode());
        this.oidListComposite.setMonitorId(monitor.getMonitorId());
        this.oidListComposite.setOidList(monitor.getTrapValueInfo());
        this.oidListComposite.update();
    }

    @Override
    protected MonitorInfo createInputData() {
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_SNMP_TRP");
        this.monitorInfo.setMonitorType(3);
        TrapCheckInfo trapInfo = new TrapCheckInfo();
        trapInfo.setCheckMode(Integer.valueOf(0));
        trapInfo.setCommunityCheck(Integer.valueOf(0));
        trapInfo.setCharsetConvert(Integer.valueOf(0));
        trapInfo.setMonitorId(this.monitorInfo.getMonitorId());
        trapInfo.setMonitorTypeId("MON_SNMP_TRP");
        this.monitorInfo.setTrapCheckInfo(trapInfo);
        this.monitorInfo.getTrapValueInfo();
        new ArrayList();
        if (this.buttonCommunityCheckOn.getSelection()) {
            this.monitorInfo.getTrapCheckInfo().setCommunityCheck(Integer.valueOf(1));
        } else {
            this.monitorInfo.getTrapCheckInfo().setCommunityCheck(Integer.valueOf(0));
        }
        if (this.textCommunityName.getText() != null && !"".equals(this.textCommunityName.getText().trim())) {
            this.monitorInfo.getTrapCheckInfo().setCommunityName(this.textCommunityName.getText());
        }
        if (this.buttonCharsetConvertOn.getSelection()) {
            this.monitorInfo.getTrapCheckInfo().setCharsetConvert(Integer.valueOf(1));
        } else {
            this.monitorInfo.getTrapCheckInfo().setCharsetConvert(Integer.valueOf(0));
        }
        if (this.textCharsetName.getText() != null && !"".equals(this.textCharsetName.getText().trim())) {
            this.monitorInfo.getTrapCheckInfo().setCharsetName(this.textCharsetName.getText());
        }
        this.monitorInfo.getTrapCheckInfo().setCheckMode(Integer.valueOf(this.oidListComposite.getCheckMode()));
        List monitorTrapValueInfoList_old = this.monitorInfo.getTrapValueInfo();
        monitorTrapValueInfoList_old.clear();
        if (this.oidListComposite.getOidList() != null) {
            monitorTrapValueInfoList_old.addAll(this.oidListComposite.getOidList());
        }
        int i = 0;
        while (i < this.monitorInfo.getTrapValueInfo().size()) {
            MonitorTrapValueInfo oidInfo = (MonitorTrapValueInfo)this.monitorInfo.getTrapValueInfo().get(i);
            if (oidInfo.getMonitorId() == null || oidInfo.getMonitorId().equals(this.monitorInfo.getMonitorId())) {
                oidInfo.setMonitorId(this.monitorInfo.getMonitorId());
            }
            ++i;
        }
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_SNMP_TRP", (String)this.monitorInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            if (this.validateResult.getID() == null) {
                if (!this.displayQuestion(this.validateResult)) {
                    this.validateResult = null;
                    return null;
                }
            } else {
                return null;
            }
        }
        this.monitorInfo.setRunInterval(0);
        if (this.confirmMonitorValid.getSelection()) {
            this.monitorInfo.setMonitorFlg(1);
        } else {
            this.monitorInfo.setMonitorFlg(0);
        }
        return this.monitorInfo;
    }

    @Override
    protected boolean action() {
        boolean result;
        block14: {
            result = false;
            MonitorInfo info = this.inputData;
            if (info != null) {
                Object[] args = new String[]{info.getMonitorId()};
                if (!this.updateFlg) {
                    try {
                        result = MonitorSettingEndpointWrapper.addMonitor(info);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.33", (Object[])args));
                            break block14;
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.34", (Object[])args));
                    }
                    catch (MonitorDuplicate_Exception monitorDuplicate_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.53", (Object[])args));
                    }
                    catch (Exception e) {
                        String errMessage = "";
                        if (e instanceof InvalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        } else {
                            errMessage = ", " + e.getMessage();
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.34", (Object[])args)) + errMessage));
                    }
                } else {
                    String errMessage = "";
                    try {
                        result = MonitorSettingEndpointWrapper.modifyMonitor(info);
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        errMessage = ", " + e.getMessage();
                    }
                    if (result) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.35", (Object[])args));
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.36", (Object[])args)) + errMessage));
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected void setMonitorEnabled(boolean enabled) {
        super.setMonitorEnabled(enabled);
        this.buttonCommunityCheckOff.setEnabled(enabled);
        this.buttonCommunityCheckOn.setEnabled(enabled);
        this.textCommunityName.setEnabled(enabled);
        this.buttonCharsetConvertOff.setEnabled(enabled);
        this.buttonCharsetConvertOn.setEnabled(enabled);
        this.textCharsetName.setEnabled(enabled);
        this.oidListComposite.setEnabled(enabled);
    }

    @Override
    protected void update() {
        super.update();
        if (this.buttonCommunityCheckOn.getSelection() && "".equals(this.textCommunityName.getText())) {
            this.textCommunityName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textCommunityName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.buttonCharsetConvertOn.getSelection() && "".equals(this.textCharsetName.getText())) {
            this.textCharsetName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textCharsetName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }
}

