/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dialog;

import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.repository.util.ScopePropertyUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.PropertySheet;
import com.clustercontrol.ws.repository.FacilityDuplicate_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.ScopeInfo;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScopeCreateDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(ScopeCreateDialog.class);
    private String facilityId = "";
    private String parentFacilityId = "";
    private boolean isModifyDialog = false;
    private PropertySheet propertySheet = null;
    private TableTree table = null;
    private RoleIdListComposite m_ownerRoleId = null;

    public ScopeCreateDialog(Shell parent, String facilityId, boolean isModifyDialog) {
        super(parent);
        this.facilityId = facilityId;
        this.isModifyDialog = isModifyDialog;
    }

    protected Point getInitialSize() {
        return new Point(450, 400);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        ScopeInfo scopeInfo;
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.repository.scope.create.modify"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        GridData gridData = new GridData();
        Label labelRoleId = new Label(parent, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelRoleId.setLayoutData((Object)gridData);
        labelRoleId.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : ");
        this.m_ownerRoleId = !this.isModifyDialog() ? new RoleIdListComposite(parent, 0, true, RoleIdListComposite.Mode.OWNER_ROLE) : new RoleIdListComposite(parent, 0, false, RoleIdListComposite.Mode.OWNER_ROLE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_ownerRoleId.setLayoutData(gridData);
        Label label = new Label(parent, 16384);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        this.table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.table.setLayoutData((Object)gridData);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeCreateDialog.this.update();
            }
        });
        this.propertySheet = new PropertySheet(this.table);
        Property property = null;
        if (this.isModifyDialog) {
            try {
                scopeInfo = RepositoryEndpointWrapper.getScope(this.facilityId);
                if (scopeInfo != null && scopeInfo.getOwnerRoleId() != null) {
                    this.m_ownerRoleId.setText(scopeInfo.getOwnerRoleId());
                }
                property = ScopeCreateDialog.getScopeProperty(scopeInfo, 1);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("getScopeProperty(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        } else {
            try {
                scopeInfo = RepositoryEndpointWrapper.getScope(null);
                if (scopeInfo != null && scopeInfo.getOwnerRoleId() != null) {
                    this.m_ownerRoleId.setText(scopeInfo.getOwnerRoleId());
                }
                property = ScopeCreateDialog.getScopeProperty(scopeInfo, 0);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("getScopeProperty(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        this.propertySheet.setInput(property);
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        this.update();
    }

    public void update() {
        if ("".equals(this.table.getItem(0).getText(1))) {
            this.table.getItem(0).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.table.getItem(0).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.table.getItem(1).getText(1))) {
            this.table.getItem(1).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.table.getItem(1).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    protected ValidateResult validate() {
        return null;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        Property property = this.getInputData();
        if (property != null) {
            String errMessage = "";
            Property copy = PropertyUtil.copy(property);
            PropertyUtil.deletePropertyDefine(copy);
            if (!this.isModifyDialog()) {
                try {
                    ScopeInfo scopeinfo = ScopePropertyUtil.property2scope(copy);
                    if (this.m_ownerRoleId.getText().length() > 0) {
                        scopeinfo.setOwnerRoleId(this.m_ownerRoleId.getText());
                    }
                    RepositoryEndpointWrapper.addScope(this.parentFacilityId, scopeinfo);
                    LocalSession.doCheck();
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.repository.14"));
                    result = true;
                }
                catch (FacilityDuplicate_Exception facilityDuplicate_Exception) {
                    ArrayList values = PropertyUtil.getPropertyValue(copy, "facilityId");
                    Object[] args = new String[]{(String)values.get(0)};
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.repository.26", (Object[])args));
                }
                catch (Exception e) {
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else {
                        errMessage = ", " + e.getMessage();
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.repository.15")) + errMessage));
                }
            } else {
                try {
                    ScopeInfo scopeInfo = ScopePropertyUtil.property2scope(copy);
                    if (this.m_ownerRoleId.getText().length() > 0) {
                        scopeInfo.setOwnerRoleId(this.m_ownerRoleId.getText());
                    }
                    RepositoryEndpointWrapper.modifyScope(scopeInfo);
                    LocalSession.doCheck();
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.repository.18"));
                    result = true;
                }
                catch (Exception e) {
                    if (e instanceof InvalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    } else {
                        errMessage = ", " + e.getMessage();
                    }
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.repository.19")) + errMessage));
                }
            }
        }
        return result;
    }

    public boolean isModifyDialog() {
        return this.isModifyDialog;
    }

    public Property getInputData() {
        return (Property)this.propertySheet.getInput();
    }

    public String getParentFacilityId() {
        return this.parentFacilityId;
    }

    public void setParentFacilityId(String parentFacilityId) {
        this.parentFacilityId = parentFacilityId;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"register");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private static Property getScopeProperty(ScopeInfo scopeInfo, int mode) {
        Property property = ScopePropertyUtil.scope2property(scopeInfo, mode, Locale.getDefault());
        return property;
    }
}

