/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.composite;

import com.clustercontrol.repository.action.GetNodeScopeTableDefine;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class NodeScopeComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(NodeScopeComposite.class);
    private Label facilityIdLabel = null;
    private Label facilityNameLabel = null;
    private CommonTableViewer tableViewer = null;

    public NodeScopeComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.facilityIdLabel = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.facilityIdLabel.setLayoutData((Object)gridData);
        this.facilityNameLabel = new Label((Composite)this, 16384);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.facilityNameLabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetNodeScopeTableDefine.get(), 0, 1);
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void update(String facilityId, String facilityName) {
        List<String> data = null;
        if (facilityId != null) {
            try {
                data = RepositoryEndpointWrapper.getNodeScopeList(facilityId);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
            this.facilityIdLabel.setText(String.valueOf(Messages.getString((String)"facility.id")) + " : " + facilityId);
        } else {
            this.facilityIdLabel.setText(String.valueOf(Messages.getString((String)"facility.id")) + " : ");
        }
        if (facilityName != null) {
            this.facilityNameLabel.setText(String.valueOf(Messages.getString((String)"facility.name")) + " : " + facilityName);
        } else {
            this.facilityNameLabel.setText(String.valueOf(Messages.getString((String)"facility.name")) + " : ");
        }
        if (data == null) {
            data = new ArrayList<String>();
        }
        ArrayList dataInput = new ArrayList();
        for (String path : data) {
            ArrayList<String> a = new ArrayList<String>();
            a.add(path);
            dataInput.add(a);
        }
        this.tableViewer.setInput(dataInput);
    }
}

