/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.action.GetNodeList;
import com.clustercontrol.repository.action.GetNodeListTableDefine;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.NodeInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class NodeFilterComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(NodeFilterComposite.class);
    private CommonTableViewer tableViewer = null;
    private Label statuslabel = null;
    private Label totalLabel = null;
    private Property condition = null;
    private String scopeId = null;
    private boolean assignFlag = true;

    public NodeFilterComposite(Composite parent, int style, String facilityId, boolean assignFlag) {
        super(parent, style);
        this.assignFlag = assignFlag;
        this.scopeId = facilityId;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.statuslabel = new Label((Composite)this, 16384);
        this.statuslabel.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.statuslabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetNodeListTableDefine.get(), 0, 1);
        this.totalLabel = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
        this.update();
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void update() {
        List<NodeInfo> list = null;
        if (this.assignFlag) {
            List<NodeInfo> allList = null;
            if (this.condition == null) {
                this.statuslabel.setText("");
                allList = new GetNodeList().getAll();
            } else {
                this.statuslabel.setText(Messages.getString((String)"filtered.list"));
                allList = new GetNodeList().get(this.condition);
            }
            try {
                List<NodeInfo> assignedList = RepositoryEndpointWrapper.getNodeList(this.scopeId, 1);
                list = new ArrayList<NodeInfo>();
                for (NodeInfo node : allList) {
                    boolean flag = true;
                    for (NodeInfo assignedNode : assignedList) {
                        if (!node.getFacilityId().equals(assignedNode.getFacilityId())) continue;
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    list.add(node);
                }
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        } else {
            this.statuslabel.setText("");
            try {
                list = RepositoryEndpointWrapper.getNodeList(this.scopeId, 1);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        ArrayList listInput = new ArrayList();
        for (NodeInfo node : list) {
            ArrayList<String> a = new ArrayList<String>();
            a.add(node.getFacilityId());
            a.add(node.getFacilityName());
            a.add(node.getPlatformFamily());
            if (node.getIpAddressVersion() == 6) {
                a.add(node.getIpAddressV6());
            } else {
                a.add(node.getIpAddressV4());
            }
            a.add(node.getDescription());
            a.add(node.getOwnerRoleId());
            listInput.add(a);
        }
        this.tableViewer.setInput(listInput);
        Object[] args = new String[]{String.valueOf(list.size())};
        String message = null;
        message = this.assignFlag ? (this.condition == null ? Messages.getString((String)"records", (Object[])args) : Messages.getString((String)"filtered.records", (Object[])args)) : Messages.getString((String)"records", (Object[])args);
        this.totalLabel.setText(message);
    }

    public void update(Property condition) {
        this.condition = condition;
        this.update();
    }
}

