/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.preference;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.util.EndpointManager;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PasswordFieldEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ClusterControlCorePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static Log m_log = LogFactory.getLog(ClusterControlCorePreferencePage.class);
    public static final String EJB_URL = "ejbUrl";
    public static final String KEY_INTERVAL = "managerPollingInterval";
    public static final String KEY_HTTP_CONNECT_TIMEOUT = "httpConnectTimeout";
    public static final String KEY_HTTP_REQUEST_TIMEOUT = "httpRequestTimeout";
    public static final int VALUE_INTERVAL_MAX = 60;
    public static final int VALUE_INTERVAL_MIN = 1;
    public static final int VALUE_HTTP_TIMEOUT_MAX = 600;
    public static final int VALUE_HTTP_TIMEOUT_MIN = 1;
    public static final String KEY_PROXY_HOST = "proxyHost";
    public static final String KEY_PROXY_PORT = "proxyPort";
    public static final String KEY_PROXY_USER = "proxyUser";
    public static final String KEY_PROXY_PASSWORD = "proxyPassword";
    public static final int VALUE_PROXY_PORT_MAX = 65535;
    public static final int VALUE_PROXY_PORT_MIN = 0;
    public static final String KEY_HTTPS_KEYSTORE_PATH = "httpsKeystorePath";
    public static final String KEY_HTTPS_KEYSTORE_PASSWORD = "httpsKeystorePassword";
    StringFieldEditor url = null;
    IntegerFieldEditor managerPollingInterval = null;
    IntegerFieldEditor httpConnectTimeout = null;
    IntegerFieldEditor httpRequestTimeout = null;
    public static final String EJB_UID = "ejbUid";
    StringFieldEditor proxyHost = null;
    IntegerFieldEditor proxyPort = null;
    StringFieldEditor proxyUser = null;
    PasswordFieldEditor proxyPassword = null;
    StringFieldEditor keyStorePath = null;
    PasswordFieldEditor keyStorePassword = null;

    public ClusterControlCorePreferencePage() {
        super(1);
        this.setPreferenceStore(ClusterControlPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        Group group = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString((String)"connection.setting"));
        this.url = new StringFieldEditor(EJB_URL, Messages.getString((String)"connection.url"), (Composite)group);
        this.url.setTextLimit(256);
        this.addField((FieldEditor)this.url);
        this.managerPollingInterval = new IntegerFieldEditor(KEY_INTERVAL, Messages.getString((String)"manager.polling.interval"), (Composite)group);
        this.managerPollingInterval.setValidRange(1, 60);
        Object[] args1 = new String[]{Integer.toString(1), Integer.toString(60)};
        this.managerPollingInterval.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])args1));
        this.addField((FieldEditor)this.managerPollingInterval);
        this.httpConnectTimeout = new IntegerFieldEditor(KEY_HTTP_CONNECT_TIMEOUT, Messages.getString((String)"connection.connect.timeout"), (Composite)group);
        this.httpConnectTimeout.setValidRange(1, 600);
        Object[] args2 = new String[]{Integer.toString(1), Integer.toString(600)};
        this.httpConnectTimeout.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])args2));
        this.addField((FieldEditor)this.httpConnectTimeout);
        this.httpRequestTimeout = new IntegerFieldEditor(KEY_HTTP_REQUEST_TIMEOUT, Messages.getString((String)"connection.request.timeout"), (Composite)group);
        this.httpRequestTimeout.setValidRange(1, 600);
        this.httpRequestTimeout.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])args2));
        this.addField((FieldEditor)this.httpRequestTimeout);
        Group proxyGroup = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        proxyGroup.setLayoutData((Object)gridData);
        proxyGroup.setText(Messages.getString((String)"proxy.connection.setting"));
        this.proxyHost = new StringFieldEditor(KEY_PROXY_HOST, Messages.getString((String)"proxy.connection.host"), (Composite)proxyGroup);
        this.proxyHost.setTextLimit(256);
        this.addField((FieldEditor)this.proxyHost);
        this.proxyPort = new IntegerFieldEditor(KEY_PROXY_PORT, Messages.getString((String)"proxy.connection.port"), (Composite)proxyGroup);
        this.proxyPort.setValidRange(0, 65535);
        Object[] args3 = new String[]{Integer.toString(0), Integer.toString(65535)};
        this.proxyPort.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])args3));
        this.addField((FieldEditor)this.proxyPort);
        this.proxyUser = new StringFieldEditor(KEY_PROXY_USER, Messages.getString((String)"proxy.connection.user"), (Composite)proxyGroup);
        this.proxyUser.setTextLimit(256);
        this.addField((FieldEditor)this.proxyUser);
        this.proxyPassword = new PasswordFieldEditor(KEY_PROXY_PASSWORD, Messages.getString((String)"proxy.connection.password"), (Composite)proxyGroup);
        this.proxyPassword.setTextLimit(256);
        this.addField((FieldEditor)this.proxyPassword);
        Group httpsGroup = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        httpsGroup.setLayoutData((Object)gridData);
        httpsGroup.setText(Messages.getString((String)"https.connection.setting"));
        this.keyStorePath = new StringFieldEditor(KEY_HTTPS_KEYSTORE_PATH, Messages.getString((String)"https.connection.keystore.path"), (Composite)httpsGroup);
        this.keyStorePath.setTextLimit(256);
        this.addField((FieldEditor)this.keyStorePath);
        this.keyStorePassword = new PasswordFieldEditor(KEY_HTTPS_KEYSTORE_PASSWORD, Messages.getString((String)"https.connection.keystore.password"), (Composite)httpsGroup);
        this.keyStorePassword.setTextLimit(256);
        this.addField((FieldEditor)this.keyStorePassword);
    }

    public boolean performOk() {
        String urlStr = this.url.getStringValue();
        if (urlStr.length() == 0 || !urlStr.startsWith("http://") && !urlStr.startsWith("https://")) {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.hinemos.9"));
            return false;
        }
        LoginManager.restartChecktask(this.managerPollingInterval.getIntValue());
        EndpointManager.m_httpConnectTimeout = this.httpConnectTimeout.getIntValue();
        EndpointManager.m_httpRequestTimeout = this.httpRequestTimeout.getIntValue();
        m_log.info((Object)("connect.timeout=" + EndpointManager.m_httpConnectTimeout + ", request.timeout=" + EndpointManager.m_httpRequestTimeout));
        boolean result = super.performOk();
        IPreferenceStore store = this.getPreferenceStore();
        store.getString(EJB_URL);
        return result;
    }

    public void init(IWorkbench workbench) {
    }
}

