/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view.action;

import com.clustercontrol.performance.action.GetPerformanceDataSettings;
import com.clustercontrol.performance.view.PerformanceGraphView;
import com.clustercontrol.performance.view.PerformanceListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collector.PerformanceDataSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AddGraphAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(AddGraphAction.class);
    public static final String ID = "com.clustercontrol.performance.view.action.AddGraphAction";
    private IViewPart viewPart;

    public void init(IViewPart view) {
        this.viewPart = view;
    }

    public void run(IAction action) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        PerformanceListView listView = (PerformanceListView)page.findView("com.clustercontrol.performance.view.PerformanceListView");
        String monitorId = listView.getSelectedMonitorId();
        (new String[1])[0] = monitorId;
        if (monitorId != null) {
            PerformanceDataSettings perfDataSettings = GetPerformanceDataSettings.getPerformanceGraphInfo(monitorId);
            if (perfDataSettings != null) {
                if (perfDataSettings.getOldestDate() == null || perfDataSettings.getOldestDate() == 0L) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.collection.6"));
                    return;
                }
                PerformanceGraphView.setPerformanceDataSettings(monitorId, perfDataSettings);
                try {
                    PerformanceGraphView graphView = (PerformanceGraphView)page.showView("com.clustercontrol.performance.view.PerformanceGraphView", monitorId, 1);
                    graphView.setFocus();
                }
                catch (PartInitException e) {
                    m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.collection.9"));
                    return;
                }
            } else {
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.collection.9"));
            }
        } else {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.collection.10"));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

