/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.view;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.performance.action.GetPerformanceDataSettings;
import com.clustercontrol.performance.composite.PerformanceGraphComposite;
import com.clustercontrol.performance.view.PerformanceListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.view.ScopeListBaseView;
import com.clustercontrol.ws.collector.PerformanceDataSettings;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.JFreeChart;

public class PerformanceGraphView
extends ScopeListBaseView {
    private static Log log = LogFactory.getLog(PerformanceGraphView.class);
    public static final String ID = "com.clustercontrol.performance.view.PerformanceGraphView";
    public static int GRAPH_MAX;
    private String monitorId = null;
    private PerformanceGraphComposite graphComposite;
    private static HashMap<String, PerformanceDataSettings> settingMap;

    static {
        settingMap = new HashMap();
        GRAPH_MAX = ClusterControlPlugin.getDefault().getPreferenceStore().getInt("graphMax");
        log.info((Object)("PerformanceGraphView : GRAPH_MAX = " + GRAPH_MAX));
    }

    public PerformanceGraphView() {
        super(false, false, false, false);
    }

    @Override
    protected Composite createListContents(Composite parent) {
        log.debug((Object)"createListContents()");
        super.getScopeTreeComposite().setScopeTree(null);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        PerformanceListView listView = (PerformanceListView)page.findView("com.clustercontrol.performance.view.PerformanceListView");
        this.monitorId = listView.getSelectedMonitorId();
        Object[] args = new String[]{this.monitorId};
        this.setPartName(Messages.getString((String)"view.performance.graph", (Object[])args));
        PerformanceDataSettings perfDataSettings = this.getPerformanceDataSettings(this.monitorId);
        super.getScopeTreeComposite().setScopeTree(perfDataSettings.getFacilityTreeItem());
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.graphComposite = new PerformanceGraphComposite(perfDataSettings, parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.graphComposite.setLayoutData(gridData);
        return this.graphComposite;
    }

    @Override
    public void update() {
        log.debug((Object)"update()");
        this.graphComposite.update();
    }

    @Override
    protected void doSelectTreeItem(FacilityTreeItem item) {
        super.doSelectTreeItem(item);
        log.debug((Object)"doSelectTreeItem()");
        this.graphComposite.updateGraph(item);
    }

    @Override
    public void startAutoReload() {
        log.debug((Object)("startAutoReload() title = " + this.getTitle()));
        super.startAutoReload();
    }

    @Override
    public void stopAutoReload() {
        log.debug((Object)("stopAutoReload() title = " + this.getTitle()));
        super.stopAutoReload();
    }

    @Override
    public void setInterval(int interval) {
        log.debug((Object)("setInterval() interval = " + interval));
        super.setInterval(interval);
    }

    public JFreeChart getChart() {
        log.debug((Object)"getChart()");
        return this.graphComposite.getChart();
    }

    public static void setGraphMax(int max) {
        log.info((Object)("setGraphMax() max = " + max));
        GRAPH_MAX = max;
    }

    private PerformanceDataSettings getPerformanceDataSettings(String moniorId) {
        PerformanceDataSettings perfDataSettings = settingMap.get(moniorId);
        if (perfDataSettings == null) {
            perfDataSettings = GetPerformanceDataSettings.getPerformanceGraphInfo(this.monitorId);
        }
        return perfDataSettings;
    }

    public static void setPerformanceDataSettings(String monitorId, PerformanceDataSettings perfDataSettings) {
        settingMap.put(monitorId, perfDataSettings);
    }
}

