/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.preference;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.performance.view.PerformanceGraphView;
import com.clustercontrol.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PerformancePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static Log log = LogFactory.getLog(PerformancePreferencePage.class);
    public static final String P_GRAPH_MAX = "graphMax";
    private static final String MSG_GRAPH_MAX = Messages.getString((String)"collection.graph.max.line");
    public static final String P_DL_MAX_WAIT = "downloadMaxWait";
    private static final String MSG_DL_MAX_WAIT = Messages.getString((String)"collection.export.max.wait");

    public PerformancePreferencePage() {
        super(1);
        log.debug((Object)"PerformancePreferencePage()");
        this.setPreferenceStore(ClusterControlPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        log.debug((Object)"createFieldEditors()");
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        Group perfGroup = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        perfGroup.setLayoutData((Object)gridData);
        perfGroup.setText(Messages.getString((String)"view.performance.graph.default"));
        IntegerFieldEditor graphMax = new IntegerFieldEditor(P_GRAPH_MAX, MSG_GRAPH_MAX, (Composite)perfGroup);
        graphMax.setValidRange(1, Short.MAX_VALUE);
        Object[] args1 = new String[]{Integer.toString(1), Integer.toString(Short.MAX_VALUE)};
        graphMax.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])args1));
        this.addField((FieldEditor)graphMax);
        IntegerFieldEditor downloadMaxWait = new IntegerFieldEditor(P_DL_MAX_WAIT, MSG_DL_MAX_WAIT, (Composite)perfGroup);
        downloadMaxWait.setValidRange(1, Short.MAX_VALUE);
        Object[] args2 = new String[]{Integer.toString(1), Integer.toString(Short.MAX_VALUE)};
        graphMax.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])args2));
        this.addField((FieldEditor)downloadMaxWait);
    }

    public boolean performOk() {
        log.debug((Object)"performOk()");
        this.applySetting();
        return super.performOk();
    }

    private void applySetting() {
        log.debug((Object)"applySetting()");
        IPreferenceStore store = this.getPreferenceStore();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        int max = store.getInt(P_GRAPH_MAX);
        PerformanceGraphView.setGraphMax(max);
    }

    public void init(IWorkbench workbench) {
    }
}

