/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.dialog;

import com.clustercontrol.monitor.run.dialog.CommonMonitorNumericDialog;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.performance.monitor.composite.CollectorItemComboComposite;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.PerfCheckInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PerformanceCreateDialog
extends CommonMonitorNumericDialog {
    private static Log m_log = LogFactory.getLog(PerformanceCreateDialog.class);
    private CollectorItemComboComposite m_comboCollectorItem = null;
    private Button m_breakdownFlg = null;

    public PerformanceCreateDialog(Shell parent) {
        super(parent);
    }

    public PerformanceCreateDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.item1 = Messages.getString((String)"select.value");
        this.item2 = Messages.getString((String)"select.value");
        super.customizeDialog(parent);
        this.itemName.setEditable(false);
        this.measure.setEditable(false);
        this.shell.setText(Messages.getString((String)"dialog.performance.monitor.create.modify"));
        GridData gridData = null;
        Group groupCheckRule = new Group((Composite)this.groupRule, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        groupCheckRule.setText(Messages.getString((String)"check.rule"));
        this.m_comboCollectorItem = new CollectorItemComboComposite((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboCollectorItem.setLayoutData(gridData);
        this.m_comboCollectorItem.setCollectorItemCombo(null);
        this.m_monitorBasic.getButtonScope().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PerformanceCreateDialog.this.m_comboCollectorItem.setCollectorItemCombo(PerformanceCreateDialog.this.m_monitorBasic.getFacilityId());
            }
        });
        this.m_breakdownFlg = new Button((Composite)groupCheckRule, 32);
        this.m_breakdownFlg.setText(Messages.getString((String)"dialog.performance.monitor.collect.detail"));
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_breakdownFlg.setLayoutData((Object)gridData);
        this.m_comboCollectorItem.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                PerformanceCreateDialog.this.itemName.setText(PerformanceCreateDialog.this.m_comboCollectorItem.getCombo().getText());
                if (PerformanceCreateDialog.this.m_comboCollectorItem.getCollectorItem() != null) {
                    PerformanceCreateDialog.this.measure.setText(CollectorItemCodeFactory.getMeasure(PerformanceCreateDialog.this.m_comboCollectorItem.getCollectorItem().getItemCode()));
                    PerformanceCreateDialog.this.update();
                }
            }
        });
        this.itemName.setText(Messages.getString((String)""));
        this.measure.setText(Messages.getString((String)""));
        this.adjustDialog();
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            try {
                info = MonitorSettingEndpointWrapper.getMonitor(this.monitorId, "MON_PRF");
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog() getMonitor, " + e.getMessage()), (Throwable)e);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        this.setInputData(info);
    }

    @Override
    protected void update() {
        super.update();
        try {
            this.item2 = this.item1 = String.valueOf(Messages.getString((String)"select.value")) + "(" + CollectorItemCodeFactory.getMeasure(this.m_comboCollectorItem.getCollectorItem().getItemCode()) + ")";
            this.m_numericValueInfo.setTextItem1(this.item1);
            this.m_numericValueInfo.setTextItem2(this.item2);
        }
        catch (NullPointerException nullPointerException) {}
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        super.setInputData(monitor);
        this.inputData = monitor;
        PerfCheckInfo perfInfo = monitor.getPerfCheckInfo();
        if (perfInfo == null) {
            perfInfo = new PerfCheckInfo();
        }
        this.m_breakdownFlg.setSelection(PerformanceCreateDialog.isBreakdown(perfInfo));
        this.m_comboCollectorItem.select(monitor);
        this.m_numericValueInfo.setInputData(monitor);
        this.update();
    }

    @Override
    protected MonitorInfo createInputData() {
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_PRF");
        this.monitorInfo.setMonitorType(1);
        PerfCheckInfo perfInfo = new PerfCheckInfo();
        perfInfo.setMonitorTypeId("MON_PRF");
        perfInfo.setMonitorId(this.monitorInfo.getMonitorId());
        if (this.m_breakdownFlg.getSelection()) {
            perfInfo.setBreakdownFlg(new Integer(1));
        } else {
            perfInfo.setBreakdownFlg(new Integer(0));
        }
        this.monitorInfo.setPerfCheckInfo(perfInfo);
        this.validateResult = this.m_numericValueInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_comboCollectorItem.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_PRF", (String)this.monitorInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            if (this.validateResult.getID() == null) {
                if (!this.displayQuestion(this.validateResult)) {
                    this.validateResult = null;
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.monitorInfo;
    }

    @Override
    protected boolean action() {
        boolean result;
        block14: {
            result = false;
            MonitorInfo info = this.inputData;
            if (info != null) {
                Object[] args = new String[]{info.getMonitorId()};
                if (!this.updateFlg) {
                    try {
                        result = MonitorSettingEndpointWrapper.addMonitor(info);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.33", (Object[])args));
                            break block14;
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.34", (Object[])args));
                    }
                    catch (MonitorDuplicate_Exception monitorDuplicate_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.53", (Object[])args));
                    }
                    catch (Exception e) {
                        String errMessage = "";
                        if (e instanceof InvalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        } else {
                            errMessage = ", " + e.getMessage();
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.34", (Object[])args)) + errMessage));
                    }
                } else {
                    String errMessage = "";
                    try {
                        result = MonitorSettingEndpointWrapper.modifyMonitor(info);
                    }
                    catch (InvalidRole_Exception invalidRole_Exception) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        errMessage = ", " + e.getMessage();
                    }
                    if (result) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.35", (Object[])args));
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.monitor.36", (Object[])args)) + errMessage));
                    }
                }
            }
        }
        return result;
    }

    private static boolean isBreakdown(PerfCheckInfo perfCheckInfo) {
        if (perfCheckInfo.getBreakdownFlg() == null) {
            return false;
        }
        switch (perfCheckInfo.getBreakdownFlg()) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }
}

