/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.composite;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.performance.util.CollectorEndpointWrapper;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collector.CollectorItemInfo;
import com.clustercontrol.ws.collector.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.PerfCheckInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CollectorItemComboComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(CollectorItemComboComposite.class);
    public static final int WIDTH_TITLE = 2;
    public static final int WIDTH_TITLE_WIDE = 3;
    public static final int WIDTH_VALUE = 10;
    public static final int HEIGHT_PULLDOWN = 30;
    private Combo m_comboCollectorItem = null;

    public CollectorItemComboComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"monitor.item")) + " : ");
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_comboCollectorItem = new Combo((Composite)this, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboCollectorItem.setLayoutData((Object)gridData);
        this.m_comboCollectorItem.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CollectorItemComboComposite.this.update();
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.update();
    }

    public void update() {
        if ("".equals(this.m_comboCollectorItem.getText())) {
            this.m_comboCollectorItem.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_comboCollectorItem.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public void setCollectorItemCombo(String facilityId) {
        List<CollectorItemInfo> itemInfoList = null;
        try {
            itemInfoList = CollectorEndpointWrapper.getAvailableCollectorItemList(facilityId);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("setCollectorItemCombo() getAvailableCollectorItemList, " + e.getMessage()), (Throwable)e);
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (itemInfoList == null) {
            itemInfoList = new ArrayList<CollectorItemInfo>();
        }
        this.m_comboCollectorItem.removeAll();
        this.m_comboCollectorItem.add("");
        this.m_comboCollectorItem.setData("", null);
        for (CollectorItemInfo itemInfo : itemInfoList) {
            String itemName = CollectorItemCodeFactory.getFullItemName(itemInfo);
            this.m_comboCollectorItem.add(itemName);
            this.m_comboCollectorItem.setData(itemName, (Object)itemInfo);
        }
        this.m_comboCollectorItem.setVisibleItemCount(30);
    }

    public CollectorItemInfo getCollectorItem() {
        String itemName = this.m_comboCollectorItem.getText();
        CollectorItemInfo itemInfo = (CollectorItemInfo)this.m_comboCollectorItem.getData(itemName);
        return itemInfo;
    }

    public void select(MonitorInfo monitor) {
        PerfCheckInfo perfCheckInfo = monitor.getPerfCheckInfo();
        if (perfCheckInfo == null) {
            return;
        }
        String facilityId = monitor.getFacilityId();
        this.setCollectorItemCombo(facilityId);
        int index = 0;
        List<CollectorItemInfo> itemInfoList = null;
        try {
            itemInfoList = CollectorEndpointWrapper.getAvailableCollectorItemList(facilityId);
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (Exception e) {
            m_log.warn((Object)("select() getAvailableCollectorItemList, " + e.getMessage()), (Throwable)e);
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (itemInfoList == null) {
            itemInfoList = new ArrayList<CollectorItemInfo>();
        }
        Iterator<CollectorItemInfo> itr = itemInfoList.iterator();
        int i = 1;
        while (itr.hasNext()) {
            CollectorItemInfo itemInfo = itr.next();
            if (itemInfo.getItemCode().equals(perfCheckInfo.getItemCode()) && itemInfo.getDisplayName().equals(perfCheckInfo.getDeviceDisplayName())) {
                index = i;
                break;
            }
            ++i;
        }
        this.m_comboCollectorItem.select(index);
    }

    public ValidateResult createInputData(MonitorInfo info) {
        if (info != null) {
            PerfCheckInfo perfCheckInfo = info.getPerfCheckInfo();
            if (this.m_comboCollectorItem.getText() != null && !"".equals(this.m_comboCollectorItem.getText().trim())) {
                String itemName = this.m_comboCollectorItem.getText();
                CollectorItemInfo itemInfo = (CollectorItemInfo)this.m_comboCollectorItem.getData(itemName);
                perfCheckInfo.setMonitorTypeId("MON_PRF");
                perfCheckInfo.setMonitorId(info.getMonitorId());
                perfCheckInfo.setItemCode(itemInfo.getItemCode());
                if (itemInfo.getDisplayName() != null) {
                    perfCheckInfo.setDeviceDisplayName(itemInfo.getDisplayName());
                } else {
                    perfCheckInfo.setDeviceDisplayName("");
                }
                info.setPerfCheckInfo(perfCheckInfo);
            }
        }
        return null;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    public Combo getCombo() {
        return this.m_comboCollectorItem;
    }
}

