/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.composite.action;

import com.clustercontrol.performance.action.GetPerformanceDataSettings;
import com.clustercontrol.performance.composite.PerformanceListComposite;
import com.clustercontrol.performance.view.PerformanceGraphView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collector.PerformanceDataSettings;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PerformanceListDoubleClickListener
implements IDoubleClickListener {
    private PerformanceListComposite m_composite;

    public PerformanceListDoubleClickListener(PerformanceListComposite composite) {
        this.m_composite = composite;
    }

    public void doubleClick(DoubleClickEvent event) {
        String monitorId = null;
        if (((StructuredSelection)event.getSelection()).getFirstElement() != null) {
            ArrayList info = (ArrayList)((StructuredSelection)event.getSelection()).getFirstElement();
            monitorId = (String)info.get(1);
        }
        if (monitorId != null) {
            PerformanceDataSettings perfDataSettings = GetPerformanceDataSettings.getPerformanceGraphInfo(monitorId);
            if (perfDataSettings != null) {
                if (perfDataSettings.getOldestDate() == null || perfDataSettings.getOldestDate() == 0L) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.collection.6"));
                    return;
                }
                PerformanceGraphView.setPerformanceDataSettings(monitorId, perfDataSettings);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    PerformanceGraphView graphView = (PerformanceGraphView)page.showView("com.clustercontrol.performance.view.PerformanceGraphView", monitorId, 1);
                    graphView.setFocus();
                }
                catch (PartInitException partInitException) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.collection.9"));
                    return;
                }
            } else {
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.collection.9"));
            }
        }
    }
}

