/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.performance.action.GetPerformanceListTableDefine;
import com.clustercontrol.performance.composite.action.PerformanceListDoubleClickListener;
import com.clustercontrol.performance.util.CollectorEndpointWrapper;
import com.clustercontrol.performance.util.PerformanceFilterPropertyUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.collector.HinemosUnknown_Exception;
import com.clustercontrol.ws.collector.InvalidRole_Exception;
import com.clustercontrol.ws.collector.PerformanceFilterInfo;
import com.clustercontrol.ws.collector.PerformanceListInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class PerformanceListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(PerformanceListComposite.class);
    private CommonTableViewer tableViewer = null;
    private Label statuslabel = null;
    private Label totalLabel = null;
    private Property condition = null;

    public PerformanceListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.statuslabel = new Label((Composite)this, 16384);
        this.statuslabel.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.statuslabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetPerformanceListTableDefine.get(), 1, -1);
        this.tableViewer.addDoubleClickListener(new PerformanceListDoubleClickListener(this));
        this.totalLabel = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
    }

    public void update() {
        List<PerformanceListInfo> list = null;
        if (this.condition == null) {
            this.statuslabel.setText("");
            try {
                list = CollectorEndpointWrapper.getPerformanceList();
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.67")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                m_log.warn((Object)("update() getPerformanceList, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        } else {
            this.statuslabel.setText(Messages.getString((String)"filtered.list"));
            PerformanceFilterInfo info = PerformanceFilterPropertyUtil.property2dto(this.condition);
            try {
                list = CollectorEndpointWrapper.getPerformanceList(info);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.67")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                m_log.warn((Object)("update() getPerformanceList, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        if (list == null) {
            list = new ArrayList<PerformanceListInfo>();
        }
        ArrayList listInput = new ArrayList();
        for (PerformanceListInfo perfListInfo : list) {
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(perfListInfo.getCollectorFlg());
            a.add(perfListInfo.getMonitorId());
            a.add(perfListInfo.getMonitorTypeId());
            a.add(perfListInfo.getDescription());
            a.add(perfListInfo.getScopeText());
            if (perfListInfo.getRunInterval() == null || perfListInfo.getRunInterval() == 0) {
                a.add("-");
            } else {
                a.add(String.valueOf(perfListInfo.getRunInterval() / 60) + Messages.getString((String)"minute"));
            }
            if (perfListInfo.getOldestDate() == null) {
                a.add(null);
            } else {
                a.add(new Date(perfListInfo.getOldestDate()));
            }
            if (perfListInfo.getLatestDate() == null) {
                a.add(null);
            } else {
                a.add(new Date(perfListInfo.getLatestDate()));
            }
            listInput.add(a);
        }
        this.tableViewer.setInput(listInput);
        Object[] args = new String[]{String.valueOf(listInput.size())};
        String message = null;
        message = this.condition == null ? Messages.getString((String)"records", (Object[])args) : Messages.getString((String)"filtered.records", (Object[])args);
        this.totalLabel.setText(message);
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update(Property condition) {
        this.condition = condition;
        this.update();
    }

    public String getSelectedMonitorId() {
        Table table = this.tableViewer.getTable();
        int selectionIndex = table.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        return table.getItem(selectionIndex).getText(1);
    }

    public String getSelectedMonitorTypeId() {
        Table table = this.tableViewer.getTable();
        int selectionIndex = table.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        return table.getItem(selectionIndex).getText(2);
    }

    public int getRunStatus() {
        Table table = this.tableViewer.getTable();
        String statusStr = table.getItem(table.getSelectionIndex()).getText(0);
        return StatusConstant.stringToType((String)statusStr);
    }
}

