/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.view.action;

import com.clustercontrol.notify.composite.NotifyListComposite;
import com.clustercontrol.notify.dialog.NotifyBasicCreateDialog;
import com.clustercontrol.notify.dialog.NotifyCommandCreateDialog;
import com.clustercontrol.notify.dialog.NotifyEventCreateDialog;
import com.clustercontrol.notify.dialog.NotifyJobCreateDialog;
import com.clustercontrol.notify.dialog.NotifyLogEscalateCreateDialog;
import com.clustercontrol.notify.dialog.NotifyMailCreateDialog;
import com.clustercontrol.notify.dialog.NotifyStatusCreateDialog;
import com.clustercontrol.notify.view.NotifyListView;
import com.clustercontrol.util.Messages;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class NotifyModifyAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(NotifyModifyAction.class);
    public static final String ID = "com.clustercontrol.monitor.view.action.NotifyModifyAction";
    private IViewPart viewPart;

    public void run(IAction action) {
        NotifyListView view = (NotifyListView)this.viewPart.getAdapter(NotifyListView.class);
        NotifyListComposite composite = (NotifyListComposite)view.getListComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String notifyId = null;
        Integer notifyType = null;
        if (list != null && list.size() > 0) {
            notifyId = (String)list.get(0);
            notifyType = (Integer)list.get(2);
        }
        Table table = composite.getTableViewer().getTable();
        if (notifyId != null && notifyType != null) {
            Shell shell = view.getListComposite().getShell();
            if (this.openDialog(shell, notifyId, notifyType) == 0) {
                int selectIndex = table.getSelectionIndex();
                composite.update();
                table.setSelection(selectIndex);
            }
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.notify.8"));
        }
    }

    public int openDialog(Shell shell, String notifyId, int notifyType) {
        NotifyBasicCreateDialog dialog = null;
        boolean updateFlg = true;
        if (notifyId == null) {
            updateFlg = false;
        }
        if (notifyType == 0) {
            dialog = new NotifyStatusCreateDialog(shell, notifyId, updateFlg);
        } else if (1 == notifyType) {
            dialog = new NotifyEventCreateDialog(shell, notifyId, updateFlg);
        } else if (2 == notifyType) {
            dialog = new NotifyMailCreateDialog(shell, notifyId, updateFlg);
        } else if (3 == notifyType) {
            dialog = new NotifyJobCreateDialog(shell, notifyId, updateFlg);
        } else if (4 == notifyType) {
            dialog = new NotifyLogEscalateCreateDialog(shell, notifyId, updateFlg);
        } else if (5 == notifyType) {
            dialog = new NotifyCommandCreateDialog(shell, notifyId, updateFlg);
        }
        return dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }
}

