/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.view.action;

import com.clustercontrol.notify.composite.NotifyListComposite;
import com.clustercontrol.notify.util.NotifyEndpointWrapper;
import com.clustercontrol.notify.view.NotifyListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.InvalidRole_Exception;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class NotifyDisableAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(NotifyDisableAction.class);
    public static final String ID = "com.clustercontrol.notify.view.action.NotifyDisableAction";
    private IViewPart viewPart;

    public void run(IAction action) {
        NotifyListView view = (NotifyListView)this.viewPart.getAdapter(NotifyListView.class);
        NotifyListComposite composite = (NotifyListComposite)view.getListComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        Object[] objs = selection.toArray();
        if (objs.length == 0) {
            MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.notify.8"));
            return;
        }
        String notifyId = null;
        ArrayList<String> targetIdList = new ArrayList<String>();
        StringBuffer targetList = new StringBuffer();
        StringBuffer successList = new StringBuffer();
        StringBuffer failureList = new StringBuffer();
        int i = 0;
        while (i < objs.length) {
            notifyId = (String)((ArrayList)objs[i]).get(0);
            targetIdList.add(notifyId);
            targetList.append(String.valueOf(notifyId) + "\n");
            ++i;
        }
        Object[] args = new String[]{targetList.toString()};
        if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.notify.37", (Object[])args))) {
            return;
        }
        boolean hasRole = true;
        for (String targetId : targetIdList) {
            try {
                NotifyEndpointWrapper.setNotifyStatus(targetId, false);
                successList.append(String.valueOf(targetId) + "\n");
            }
            catch (InvalidRole_Exception e) {
                failureList.append(String.valueOf(targetId) + "\n");
                m_log.warn((Object)("run() setNotifyStatus targetId=" + targetId + ", " + e.getMessage()), (Throwable)e);
                hasRole = false;
            }
            catch (Exception e) {
                failureList.append(String.valueOf(targetId) + "\n");
                m_log.warn((Object)("run() setNotifyStatus targetId=" + targetId + ", " + e.getMessage()), (Throwable)e);
            }
        }
        if (!hasRole) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        if (successList.length() != 0) {
            args = new String[]{successList.toString()};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.notify.38", (Object[])args));
        }
        if (failureList.length() != 0) {
            args = new String[]{failureList.toString()};
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.notify.39", (Object[])args));
        }
        composite.update();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        this.viewPart = view;
    }
}

