/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.dialog;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.composite.action.JobIdSelectionListener;
import com.clustercontrol.notify.action.AddNotify;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.action.ModifyNotify;
import com.clustercontrol.notify.dialog.NotifyBasicCreateDialog;
import com.clustercontrol.repository.FacilityPath;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyInfo;
import com.clustercontrol.ws.notify.NotifyJobInfo;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NotifyJobCreateDialog
extends NotifyBasicCreateDialog {
    private static final int WIDTH_PRIORITY = 2;
    private static final int WIDTH_JOB_RUN = 2;
    private static final int WIDTH_JOBUNIT_ID = 3;
    private static final int WIDTH_JOB_ID = 4;
    private static final int WIDTH_REF_BTN = 1;
    private static final int WIDTH_FAILURE_PRIORITY = 3;
    private final int TYPE_JOB = 3;
    private NotifyInfo inputData = null;
    protected ValidateResult validateResult = null;
    private Text m_textScope = null;
    private String m_facilityId = null;
    private String m_facilityPath = null;
    private Button m_radioGenerationNodeValue = null;
    private Button m_radioFixedValue = null;
    private Button m_scopeSelect = null;
    private Button m_checkJobRunInfo = null;
    private Button m_checkJobRunWarning = null;
    private Button m_checkJobRunCritical = null;
    private Button m_checkJobRunUnknown = null;
    private Text m_textJobunitIdInfo = null;
    private Text m_textJobunitIdWarning = null;
    private Text m_textJobunitIdCritical = null;
    private Text m_textJobunitIdUnknown = null;
    private Text m_textJobIdInfo = null;
    private Text m_textJobIdWarning = null;
    private Text m_textJobIdCritical = null;
    private Text m_textJobIdUnknown = null;
    private Button m_buttonReferInfo = null;
    private Button m_buttonReferWarning = null;
    private Button m_buttonReferCritical = null;
    private Button m_buttonReferUnknown = null;
    private Combo m_comboFailurePriorityInfo = null;
    private Combo m_comboFailurePriorityWarning = null;
    private Combo m_comboFailurePriorityCritical = null;
    private Combo m_comboFailurePriorityUnknown = null;

    public NotifyJobCreateDialog(Shell parent) {
        super(parent);
    }

    public NotifyJobCreateDialog(Shell parent, int notifyIdType) {
        super(parent, notifyIdType);
    }

    public NotifyJobCreateDialog(Shell parent, String notifyId, boolean updateFlg) {
        super(parent, notifyId, updateFlg);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        super.customizeDialog(parent);
        NotifyInfo info = null;
        info = this.notifyId != null ? new GetNotify().getNotify(this.notifyId) : new NotifyInfo();
        this.setInputData(info);
    }

    @Override
    protected void customizeSettingDialog(Composite parent) {
        final Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.notify.job.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        Group groupJob = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupJob.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupJob.setLayoutData((Object)gridData);
        groupJob.setText(Messages.getString((String)"notifies.job"));
        Group groupScope = new Group((Composite)groupJob, 0);
        groupScope.setText(Messages.getString((String)"notify.job.scope"));
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupScope.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupScope.setLayoutData((Object)gridData);
        this.m_radioGenerationNodeValue = new Button((Composite)groupScope, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioGenerationNodeValue.setLayoutData((Object)gridData);
        this.m_radioGenerationNodeValue.setText(String.valueOf(Messages.getString((String)"notify.node.generation")) + " : ");
        this.m_radioGenerationNodeValue.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    NotifyJobCreateDialog.this.m_radioFixedValue.setSelection(false);
                    NotifyJobCreateDialog.this.m_scopeSelect.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_radioFixedValue = new Button((Composite)groupScope, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioFixedValue.setLayoutData((Object)gridData);
        this.m_radioFixedValue.setText(String.valueOf(Messages.getString((String)"notify.node.fix")) + " : ");
        this.m_radioFixedValue.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    NotifyJobCreateDialog.this.m_radioGenerationNodeValue.setSelection(false);
                    NotifyJobCreateDialog.this.m_scopeSelect.setEnabled(true);
                }
                NotifyJobCreateDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_textScope = new Text((Composite)groupScope, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textScope.setLayoutData((Object)gridData);
        this.m_textScope.setText("");
        this.m_scopeSelect = new Button((Composite)groupScope, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_scopeSelect.setLayoutData((Object)gridData);
        this.m_scopeSelect.setText(Messages.getString((String)"refer"));
        this.m_scopeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(shell, NotifyJobCreateDialog.this.m_notifyBasic.getRoleIdList().getText());
                if (dialog.open() == 0) {
                    FacilityTreeItem selectItem = dialog.getSelectItem();
                    FacilityInfo info = selectItem.getData();
                    FacilityPath path = new FacilityPath(ClusterControlPlugin.getDefault().getSeparator());
                    NotifyJobCreateDialog.this.m_facilityPath = path.getPath(selectItem);
                    NotifyJobCreateDialog.this.m_facilityId = info.getFacilityId();
                    NotifyJobCreateDialog.this.m_textScope.setText(NotifyJobCreateDialog.this.m_facilityPath);
                    NotifyJobCreateDialog.this.update();
                }
            }
        });
        label = new Label((Composite)groupScope, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"priority"));
        label = new Label((Composite)groupJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"notify.attribute"));
        label = new Label((Composite)groupJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"jobunit.id"));
        label = new Label((Composite)groupJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"job.id"));
        label = new Label((Composite)groupJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupJob, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"failure.call.value"));
        label = this.getLabelPriority((Composite)groupJob, Messages.getString((String)"info"), PriorityColorConstant.COLOR_INFO);
        this.m_checkJobRunInfo = this.getCheckJobRun((Composite)groupJob);
        this.m_textJobunitIdInfo = this.getTextJobunitId((Composite)groupJob);
        this.m_textJobIdInfo = this.getTextJobId((Composite)groupJob);
        this.m_buttonReferInfo = this.getButtonJobRefer((Composite)groupJob);
        this.m_comboFailurePriorityInfo = this.getComboPriority((Composite)groupJob);
        this.m_buttonReferInfo.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobunitIdInfo, this.m_textJobIdInfo, this.m_notifyBasic.getRoleIdList()));
        label = this.getLabelPriority((Composite)groupJob, Messages.getString((String)"warning"), PriorityColorConstant.COLOR_WARNING);
        this.m_checkJobRunWarning = this.getCheckJobRun((Composite)groupJob);
        this.m_textJobunitIdWarning = this.getTextJobunitId((Composite)groupJob);
        this.m_textJobIdWarning = this.getTextJobId((Composite)groupJob);
        this.m_buttonReferWarning = this.getButtonJobRefer((Composite)groupJob);
        this.m_comboFailurePriorityWarning = this.getComboPriority((Composite)groupJob);
        this.m_buttonReferWarning.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobunitIdWarning, this.m_textJobIdWarning, this.m_notifyBasic.getRoleIdList()));
        label = this.getLabelPriority((Composite)groupJob, Messages.getString((String)"critical"), PriorityColorConstant.COLOR_CRITICAL);
        this.m_checkJobRunCritical = this.getCheckJobRun((Composite)groupJob);
        this.m_textJobunitIdCritical = this.getTextJobunitId((Composite)groupJob);
        this.m_textJobIdCritical = this.getTextJobId((Composite)groupJob);
        this.m_buttonReferCritical = this.getButtonJobRefer((Composite)groupJob);
        this.m_comboFailurePriorityCritical = this.getComboPriority((Composite)groupJob);
        this.m_buttonReferCritical.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobunitIdCritical, this.m_textJobIdCritical, this.m_notifyBasic.getRoleIdList()));
        label = this.getLabelPriority((Composite)groupJob, Messages.getString((String)"unknown"), PriorityColorConstant.COLOR_UNKNOWN);
        this.m_checkJobRunUnknown = this.getCheckJobRun((Composite)groupJob);
        this.m_textJobunitIdUnknown = this.getTextJobunitId((Composite)groupJob);
        this.m_textJobIdUnknown = this.getTextJobId((Composite)groupJob);
        this.m_buttonReferUnknown = this.getButtonJobRefer((Composite)groupJob);
        this.m_comboFailurePriorityUnknown = this.getComboPriority((Composite)groupJob);
        this.m_buttonReferUnknown.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobunitIdUnknown, this.m_textJobIdUnknown, this.m_notifyBasic.getRoleIdList()));
    }

    public void update() {
        if (this.m_radioFixedValue.getSelection() && "".equals(this.m_textScope.getText())) {
            this.m_textScope.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textScope.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_checkJobRunInfo.getSelection() && "".equals(this.m_textJobunitIdInfo.getText())) {
            this.m_textJobunitIdInfo.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
            this.m_textJobIdInfo.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textJobunitIdInfo.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            this.m_textJobIdInfo.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_checkJobRunWarning.getSelection() && "".equals(this.m_textJobunitIdWarning.getText())) {
            this.m_textJobunitIdWarning.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
            this.m_textJobIdWarning.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textJobunitIdWarning.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            this.m_textJobIdWarning.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_checkJobRunCritical.getSelection() && "".equals(this.m_textJobunitIdCritical.getText())) {
            this.m_textJobunitIdCritical.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
            this.m_textJobIdCritical.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textJobunitIdCritical.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            this.m_textJobIdCritical.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_checkJobRunUnknown.getSelection() && "".equals(this.m_textJobunitIdUnknown.getText())) {
            this.m_textJobunitIdUnknown.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
            this.m_textJobIdUnknown.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textJobunitIdUnknown.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            this.m_textJobIdUnknown.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    public NotifyInfo getInputData() {
        return this.inputData;
    }

    @Override
    protected void setInputData(NotifyInfo notify) {
        this.inputData = notify;
        this.m_notifyBasic.setInputData(notify, this.updateFlg);
        this.m_notifyInitial.setInputData(notify);
        this.m_notifyInhibition.setInputData(notify);
        List list = notify.getNotifyJobInfo();
        if (list != null && list.size() > 0) {
            int index = 0;
            while (index < list.size()) {
                NotifyJobInfo job = (NotifyJobInfo)list.get(index);
                if (job != null) {
                    if (3 == job.getPriority()) {
                        this.setInputDataForJob(job, this.m_checkJobRunInfo, this.m_textJobunitIdInfo, this.m_textJobIdInfo, this.m_comboFailurePriorityInfo);
                        if (job.getJobExecFacility() != null) {
                            this.m_facilityId = job.getJobExecFacility();
                            this.m_textScope.setText(job.getJobExecScope());
                        }
                        if (job.getJobExecFacilityFlg() != null && job.getJobExecFacilityFlg() == 0) {
                            this.m_radioGenerationNodeValue.setSelection(true);
                            this.m_scopeSelect.setEnabled(false);
                        } else {
                            this.m_radioFixedValue.setSelection(true);
                            this.m_scopeSelect.setEnabled(true);
                        }
                    } else if (2 == job.getPriority()) {
                        this.setInputDataForJob(job, this.m_checkJobRunWarning, this.m_textJobunitIdWarning, this.m_textJobIdWarning, this.m_comboFailurePriorityWarning);
                    } else if (job.getPriority() == 0) {
                        this.setInputDataForJob(job, this.m_checkJobRunCritical, this.m_textJobunitIdCritical, this.m_textJobIdCritical, this.m_comboFailurePriorityCritical);
                    } else if (1 == job.getPriority()) {
                        this.setInputDataForJob(job, this.m_checkJobRunUnknown, this.m_textJobunitIdUnknown, this.m_textJobIdUnknown, this.m_comboFailurePriorityUnknown);
                    }
                }
                ++index;
            }
        } else {
            this.m_radioGenerationNodeValue.setSelection(true);
            this.m_scopeSelect.setEnabled(false);
        }
        if (notify.getValidFlg() != null && notify.getValidFlg() == 0) {
            this.m_confirmValid.setSelection(false);
        } else {
            this.m_confirmValid.setSelection(true);
        }
    }

    protected void setInputDataForJob(NotifyJobInfo info, Button checkJobRun, Text textJobunitId, Text textJobId, Combo comboFailurePriority) {
        if (info.getValidFlg() != null && info.getValidFlg() == 1) {
            checkJobRun.setSelection(true);
        }
        if (info.getJobunitId() != null) {
            textJobunitId.setText(info.getJobunitId());
        }
        if (info.getJobId() != null) {
            textJobId.setText(info.getJobId());
        }
        if (info.getJobFailurePriority() != null) {
            comboFailurePriority.setText(PriorityConstant.typeToString((int)info.getJobFailurePriority()));
        }
    }

    @Override
    protected NotifyInfo createInputData() {
        NotifyInfo info = new NotifyInfo();
        info.setNotifyType(Integer.valueOf(3));
        this.validateResult = this.m_notifyBasic.createInputData(info, this.notifyId);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_notifyInitial.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_notifyInhibition.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        ArrayList<NotifyJobInfo> list = new ArrayList<NotifyJobInfo>();
        list = this.createInputDataForJob(list, 3, this.m_checkJobRunInfo, this.m_textJobunitIdInfo, this.m_textJobIdInfo, this.m_comboFailurePriorityInfo);
        list = this.createInputDataForJob(list, 2, this.m_checkJobRunWarning, this.m_textJobunitIdWarning, this.m_textJobIdWarning, this.m_comboFailurePriorityWarning);
        list = this.createInputDataForJob(list, 0, this.m_checkJobRunCritical, this.m_textJobunitIdCritical, this.m_textJobIdCritical, this.m_comboFailurePriorityCritical);
        if ((list = this.createInputDataForJob(list, 1, this.m_checkJobRunUnknown, this.m_textJobunitIdUnknown, this.m_textJobIdUnknown, this.m_comboFailurePriorityUnknown)) == null) {
            return null;
        }
        List notifyJobInfo = info.getNotifyJobInfo();
        notifyJobInfo.clear();
        notifyJobInfo.addAll(list);
        if (this.m_confirmValid.getSelection()) {
            info.setValidFlg(Integer.valueOf(1));
        } else {
            info.setValidFlg(Integer.valueOf(0));
        }
        return info;
    }

    private ArrayList<NotifyJobInfo> createInputDataForJob(ArrayList<NotifyJobInfo> list, int priority, Button checkJobRun, Text textJobunitId, Text textJobId, Combo comboFailurePriority) {
        if (list == null) {
            return null;
        }
        NotifyJobInfo job = new NotifyJobInfo();
        job.setPriority(Integer.valueOf(priority));
        if (checkJobRun.getSelection()) {
            job.setValidFlg(new Integer(1));
        } else {
            job.setValidFlg(new Integer(0));
        }
        if (textJobunitId.getText() != null && !"".equals(textJobunitId.getText().trim())) {
            job.setJobunitId(textJobunitId.getText());
        }
        if (textJobId.getText() != null && !"".equals(textJobId.getText().trim())) {
            job.setJobId(textJobId.getText());
        }
        if (comboFailurePriority.getText() != null && !"".equals(comboFailurePriority.getText())) {
            job.setJobFailurePriority(Integer.valueOf(PriorityConstant.stringToType((String)comboFailurePriority.getText())));
        }
        if (this.m_textScope.getText() != null && !"".equals(this.m_textScope.getText())) {
            job.setJobExecFacility(this.m_facilityId);
            job.setJobExecScope(this.m_textScope.getText());
        }
        if (this.m_radioGenerationNodeValue.getSelection()) {
            job.setJobExecFacilityFlg(Integer.valueOf(0));
        } else if (this.m_radioFixedValue.getSelection()) {
            job.setJobExecFacilityFlg(Integer.valueOf(1));
        }
        list.add(job);
        return list;
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        NotifyInfo info = this.getInputData();
        if (info != null) {
            result = !this.updateFlg ? new AddNotify().add(info) : new ModifyNotify().modify(info);
        }
        return result;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.referenceFlg) {
            super.createButtonsForButtonBar(parent);
        } else {
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }
    }

    @Override
    protected void setEnabled(boolean enable) {
        this.m_notifyBasic.setEnabled(enable);
        this.m_notifyInhibition.setEnabled(enable);
    }

    private Label getLabelPriority(Composite parent, String text, Color background) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        label.setBackground(background);
        return label;
    }

    private Button getCheckJobRun(Composite parent) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NotifyJobCreateDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return button;
    }

    private Text getTextJobunitId(Composite parent) {
        Text text = new Text(parent, 2056);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NotifyJobCreateDialog.this.update();
            }
        });
        return text;
    }

    private Text getTextJobId(Composite parent) {
        Text text = new Text(parent, 2056);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        return text;
    }

    private Button getButtonJobRefer(Composite parent) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(Messages.getString((String)"refer"));
        return button;
    }

    private Combo getComboPriority(Composite parent) {
        Combo combo = new Combo(parent, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        combo.add(PriorityConstant.STRING_CRITICAL);
        combo.add(PriorityConstant.STRING_WARNING);
        combo.add(PriorityConstant.STRING_INFO);
        combo.add(PriorityConstant.STRING_UNKNOWN);
        combo.setText(PriorityConstant.STRING_UNKNOWN);
        return combo;
    }

    @Override
    public void setOwnerRoleId(String ownerRoleId) {
        super.setOwnerRoleId(ownerRoleId);
        this.m_facilityPath = "";
        this.m_facilityId = "";
        this.m_textScope.setText(this.m_facilityPath);
        this.m_textJobunitIdInfo.setText("");
        this.m_textJobunitIdWarning.setText("");
        this.m_textJobunitIdCritical.setText("");
        this.m_textJobunitIdUnknown.setText("");
        this.m_textJobIdInfo.setText("");
        this.m_textJobIdWarning.setText("");
        this.m_textJobIdCritical.setText("");
        this.m_textJobIdUnknown.setText("");
    }
}

