/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.dialog;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.bean.EventConfirmConstant;
import com.clustercontrol.notify.action.AddNotify;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.action.ModifyNotify;
import com.clustercontrol.notify.dialog.NotifyBasicCreateDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyEventInfo;
import com.clustercontrol.ws.notify.NotifyInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NotifyEventCreateDialog
extends NotifyBasicCreateDialog {
    private static final int WIDTH_PRIORITY = 2;
    private static final int WIDTH_NOTIFY = 2;
    private static final int WIDTH_STATE = 3;
    private static final int WIDTH_INHIBITION_FLG = 2;
    private static final int WIDTH_BLANK = 3;
    private final int TYPE_EVENT = 1;
    private NotifyInfo inputData = null;
    protected ValidateResult validateResult = null;
    private Button m_checkEventNormalInfo = null;
    private Button m_checkEventNormalWarning = null;
    private Button m_checkEventNormalCritical = null;
    private Button m_checkEventNormalUnknown = null;
    private Combo m_comboEventNormalInfo = null;
    private Combo m_comboEventNormalWarning = null;
    private Combo m_comboEventNormalCritical = null;
    private Combo m_comboEventNormalUnknown = null;

    public NotifyEventCreateDialog(Shell parent) {
        super(parent);
    }

    public NotifyEventCreateDialog(Shell parent, int notifyIdType) {
        super(parent, notifyIdType);
    }

    public NotifyEventCreateDialog(Shell parent, String notifyId, boolean updateFlg) {
        super(parent, notifyId, updateFlg);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        super.customizeDialog(parent);
        NotifyInfo info = null;
        info = this.notifyId != null ? new GetNotify().getNotify(this.notifyId) : new NotifyInfo();
        this.setInputData(info);
    }

    @Override
    protected void customizeSettingDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.notify.event.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        Group groupEvent = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupEvent.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupEvent.setLayoutData((Object)gridData);
        groupEvent.setText(Messages.getString((String)"notifies.event"));
        label = new Label((Composite)groupEvent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"priority"));
        label = new Label((Composite)groupEvent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"notify.attribute"));
        label = new Label((Composite)groupEvent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"status"));
        label = new Label((Composite)groupEvent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority((Composite)groupEvent, Messages.getString((String)"info"), PriorityColorConstant.COLOR_INFO);
        this.m_checkEventNormalInfo = this.getCheckEventNormal((Composite)groupEvent);
        this.m_comboEventNormalInfo = this.getComboEventNormal((Composite)groupEvent);
        label = new Label((Composite)groupEvent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority((Composite)groupEvent, Messages.getString((String)"warning"), PriorityColorConstant.COLOR_WARNING);
        this.m_checkEventNormalWarning = this.getCheckEventNormal((Composite)groupEvent);
        this.m_comboEventNormalWarning = this.getComboEventNormal((Composite)groupEvent);
        label = new Label((Composite)groupEvent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority((Composite)groupEvent, Messages.getString((String)"critical"), PriorityColorConstant.COLOR_CRITICAL);
        this.m_checkEventNormalCritical = this.getCheckEventNormal((Composite)groupEvent);
        this.m_comboEventNormalCritical = this.getComboEventNormal((Composite)groupEvent);
        label = new Label((Composite)groupEvent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority((Composite)groupEvent, Messages.getString((String)"unknown"), PriorityColorConstant.COLOR_UNKNOWN);
        this.m_checkEventNormalUnknown = this.getCheckEventNormal((Composite)groupEvent);
        this.m_comboEventNormalUnknown = this.getComboEventNormal((Composite)groupEvent);
        label = new Label((Composite)groupEvent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    @Override
    public NotifyInfo getInputData() {
        return this.inputData;
    }

    @Override
    protected void setInputData(NotifyInfo notify) {
        this.inputData = notify;
        this.m_notifyBasic.setInputData(notify, this.updateFlg);
        this.m_notifyInitial.setInputData(notify);
        this.m_notifyInhibition.setInputData(notify);
        List list = notify.getNotifyEventInfo();
        if (list != null && list.size() > 0) {
            int index = 0;
            while (index < list.size()) {
                NotifyEventInfo event = (NotifyEventInfo)list.get(index);
                if (event != null) {
                    if (3 == event.getPriority()) {
                        this.setInputDataForEvent(event, this.m_checkEventNormalInfo, this.m_comboEventNormalInfo);
                    } else if (2 == event.getPriority()) {
                        this.setInputDataForEvent(event, this.m_checkEventNormalWarning, this.m_comboEventNormalWarning);
                    } else if (event.getPriority() == 0) {
                        this.setInputDataForEvent(event, this.m_checkEventNormalCritical, this.m_comboEventNormalCritical);
                    } else if (1 == event.getPriority()) {
                        this.setInputDataForEvent(event, this.m_checkEventNormalUnknown, this.m_comboEventNormalUnknown);
                    }
                }
                ++index;
            }
        }
        if (notify.getValidFlg() != null && notify.getValidFlg() == 0) {
            this.m_confirmValid.setSelection(false);
        } else {
            this.m_confirmValid.setSelection(true);
        }
    }

    protected void setInputDataForEvent(NotifyEventInfo info, Button checkEventNormal, Combo comboEventNormal) {
        if (info.getValidFlg() != null && info.getValidFlg() == 1) {
            checkEventNormal.setSelection(true);
        }
        if (info.getEventNormalState() != null) {
            comboEventNormal.setText(EventConfirmConstant.typeToString((int)info.getEventNormalState()));
        }
    }

    @Override
    protected NotifyInfo createInputData() {
        NotifyInfo info = new NotifyInfo();
        info.setNotifyType(Integer.valueOf(1));
        this.validateResult = this.m_notifyBasic.createInputData(info, this.notifyId);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_notifyInitial.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        this.validateResult = this.m_notifyInhibition.createInputData(info);
        if (this.validateResult != null) {
            return null;
        }
        ArrayList<NotifyEventInfo> list = new ArrayList<NotifyEventInfo>();
        list = this.createInputDataForEvent(list, 3, this.m_checkEventNormalInfo, this.m_comboEventNormalInfo, null, null);
        list = this.createInputDataForEvent(list, 2, this.m_checkEventNormalWarning, this.m_comboEventNormalWarning, null, null);
        list = this.createInputDataForEvent(list, 0, this.m_checkEventNormalCritical, this.m_comboEventNormalCritical, null, null);
        if ((list = this.createInputDataForEvent(list, 1, this.m_checkEventNormalUnknown, this.m_comboEventNormalUnknown, null, null)) == null) {
            return null;
        }
        List notifyEventInfo = info.getNotifyEventInfo();
        notifyEventInfo.clear();
        notifyEventInfo.addAll(list);
        if (this.m_confirmValid.getSelection()) {
            info.setValidFlg(Integer.valueOf(1));
        } else {
            info.setValidFlg(Integer.valueOf(0));
        }
        return info;
    }

    private ArrayList<NotifyEventInfo> createInputDataForEvent(ArrayList<NotifyEventInfo> list, int priority, Button checkEventNormal, Combo comboEventNormal, Button checkEventInhibition, Combo comboEventInhibition) {
        if (list == null) {
            return null;
        }
        NotifyEventInfo event = new NotifyEventInfo();
        event.setEventNormalState(Integer.valueOf(0));
        event.setPriority(Integer.valueOf(priority));
        if (checkEventNormal.getSelection()) {
            event.setValidFlg(new Integer(1));
        } else {
            event.setValidFlg(new Integer(0));
        }
        if (comboEventNormal.getText() != null && !"".equals(comboEventNormal.getText().trim())) {
            event.setEventNormalState(new Integer(EventConfirmConstant.stringToType((String)comboEventNormal.getText())));
        }
        list.add(event);
        return list;
    }

    @Override
    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        NotifyInfo info = this.getInputData();
        if (info != null) {
            result = !this.updateFlg ? new AddNotify().add(info) : new ModifyNotify().modify(info);
        }
        return result;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.referenceFlg) {
            super.createButtonsForButtonBar(parent);
        } else {
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }
    }

    @Override
    protected void setEnabled(boolean enable) {
        this.m_notifyBasic.setEnabled(enable);
        this.m_notifyInhibition.setEnabled(enable);
    }

    private Label getLabelPriority(Composite parent, String text, Color background) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        label.setBackground(background);
        return label;
    }

    private Button getCheckEventNormal(Composite parent) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Combo getComboEventNormal(Composite parent) {
        Combo combo = new Combo(parent, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        combo.add(EventConfirmConstant.STRING_UNCONFIRMED);
        combo.add(EventConfirmConstant.STRING_CONFIRMED);
        combo.setText(EventConfirmConstant.STRING_UNCONFIRMED);
        return combo;
    }

    private Button getCheckEventInhibition(Composite parent) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Combo getComboEventInhibition(Composite parent) {
        Combo combo = new Combo(parent, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        combo.add(EventConfirmConstant.STRING_CONFIRMED);
        combo.add(EventConfirmConstant.STRING_DESTRUCTION);
        combo.setText(EventConfirmConstant.STRING_CONFIRMED);
        return combo;
    }
}

