/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.composite;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.MonitorInfo;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NotifyInfoComposite
extends NotifyIdListComposite {
    private Label labelApplication = null;
    private Text textApplication = null;
    protected ValidateResult validateResult = null;

    public NotifyInfoComposite(Composite parent, int style) {
        super(parent, style, true);
        this.initialize(parent);
    }

    public NotifyInfoComposite(Composite parent, int style, int notifyIdType) {
        super(parent, style, true, notifyIdType);
        this.initialize(parent);
    }

    public NotifyInfoComposite(Composite parent, int style, String text) {
        super(parent, style, text);
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        this.labelApplication = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.labelApplication.setLayoutData((Object)gridData);
        this.labelApplication.setText(String.valueOf(Messages.getString((String)"application")) + " : ");
        this.textApplication = new Text((Composite)this, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textApplication.setLayoutData((Object)gridData);
        this.textApplication.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NotifyInfoComposite.this.update();
            }
        });
        this.update();
    }

    @Override
    public void update() {
        if (this.textApplication.getEnabled() && "".equals(this.textApplication.getText())) {
            this.textApplication.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.textApplication.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textApplication.setEnabled(enabled);
        this.update();
    }

    public String getApplication() {
        return this.textApplication.getText();
    }

    public void setApplication(String string) {
        this.textApplication.setText(string);
    }

    public ValidateResult createInputData(MonitorInfo info) {
        this.validateResult = null;
        if (info != null) {
            if (this.setNotifyGroupId(info.getNotifyGroupId())) {
                List notifyRelationInfoList = info.getNotifyId();
                notifyRelationInfoList.clear();
                if (this.getNotify() != null) {
                    notifyRelationInfoList.addAll(this.getNotify());
                }
            }
            if (this.getApplication() != null && !this.getApplication().equals("")) {
                info.setApplication(this.getApplication());
            }
        }
        return this.validateResult;
    }

    protected void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}

