/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.view.action;

import com.clustercontrol.custom.dialog.MonitorCustomDialog;
import com.clustercontrol.hinemosagent.dialog.AgentCreateDialog;
import com.clustercontrol.http.dialog.HttpNumericCreateDialog;
import com.clustercontrol.http.dialog.HttpStringCreateDialog;
import com.clustercontrol.logfile.dialog.LogfileStringCreateDialog;
import com.clustercontrol.monitor.composite.MonitorListComposite;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.dialog.CommonMonitorDialog;
import com.clustercontrol.monitor.view.MonitorListView;
import com.clustercontrol.performance.monitor.dialog.PerformanceCreateDialog;
import com.clustercontrol.ping.dialog.PingCreateDialog;
import com.clustercontrol.plugin.monitor.IMonitorPlugin;
import com.clustercontrol.plugin.monitor.LoadMonitorPlugin;
import com.clustercontrol.port.dialog.PortCreateDialog;
import com.clustercontrol.process.dialog.ProcessCreateDialog;
import com.clustercontrol.snmp.dialog.SnmpNumericCreateDialog;
import com.clustercontrol.snmp.dialog.SnmpStringCreateDialog;
import com.clustercontrol.snmptrap.dialog.SnmpTrapCreateDialog;
import com.clustercontrol.sql.dialog.SqlNumericCreateDialog;
import com.clustercontrol.sql.dialog.SqlStringCreateDialog;
import com.clustercontrol.systemlog.dialog.SystemlogStringCreateDialog;
import com.clustercontrol.winevent.dialog.WinEventDialog;
import com.clustercontrol.winservice.dialog.WinServiceCreateDialog;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class MonitorModifyAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(MonitorModifyAction.class);
    public static final String ID = "com.clustercontrol.monitor.view.action.MonitorModifyAction";
    private IViewPart viewPart;

    public void run(IAction action) {
        MonitorListView view = (MonitorListView)this.viewPart.getAdapter(MonitorListView.class);
        MonitorListComposite composite = (MonitorListComposite)view.getListComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String pluginId = null;
        String monitorId = null;
        int monitorType = 0;
        if (list != null && list.size() > 0) {
            pluginId = (String)list.get(1);
            monitorId = (String)list.get(0);
            monitorType = MonitorTypeConstant.stringToType((String)((String)list.get(2)));
        }
        this.dialogOpen(this.viewPart.getSite().getShell(), pluginId, monitorId, monitorType);
        view.update();
    }

    public int dialogOpen(Shell shell, String pluginId, String monitorId, int monitorType) {
        CommonMonitorDialog dialog = null;
        boolean updateFlg = true;
        if (monitorId == null) {
            updateFlg = false;
        }
        if (pluginId.equals("MON_AGT")) {
            dialog = new AgentCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_HTP")) {
            dialog = monitorType == 1 ? new HttpNumericCreateDialog(shell, monitorId, updateFlg) : new HttpStringCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_PRF")) {
            dialog = new PerformanceCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_PNG")) {
            dialog = new PingCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_PRT")) {
            dialog = new PortCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_PRC")) {
            dialog = new ProcessCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_SNMP")) {
            dialog = monitorType == 1 ? new SnmpNumericCreateDialog(shell, monitorId, updateFlg) : new SnmpStringCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_SQL")) {
            dialog = monitorType == 1 ? new SqlNumericCreateDialog(shell, monitorId, updateFlg) : new SqlStringCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_SYSLOG")) {
            dialog = new SystemlogStringCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_LOGFILE")) {
            dialog = new LogfileStringCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_CUSTOM")) {
            dialog = new MonitorCustomDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_SNMP_TRP")) {
            dialog = new SnmpTrapCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_WINSERVICE")) {
            dialog = new WinServiceCreateDialog(shell, monitorId, updateFlg);
        } else if (pluginId.equals("MON_WINEVENT")) {
            dialog = new WinEventDialog(shell, monitorId, updateFlg);
        } else {
            for (IMonitorPlugin extensionMonitor : LoadMonitorPlugin.getExtensionMonitorList()) {
                if (!pluginId.equals(extensionMonitor.getMonitorPluginId())) continue;
                return extensionMonitor.create(shell, monitorId, updateFlg);
            }
            m_log.warn((Object)("unknown pluginId " + pluginId));
            return -1;
        }
        return dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }
}

