/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.view.action;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.dialog.EventBatchConfirmDialog;
import com.clustercontrol.monitor.util.EventBatchConfirmPropertyUtil;
import com.clustercontrol.monitor.util.MonitorEndpointWrapper;
import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.monitor.EventBatchConfirmInfo;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class EventBatchConfirmAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(EventBatchConfirmAction.class);
    private IViewPart viewPart;

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    public void run(IAction action) {
        EventBatchConfirmDialog dialog = new EventBatchConfirmDialog(this.viewPart.getSite().getShell());
        EventView view = (EventView)((Object)this.viewPart.getAdapter(EventView.class));
        if (dialog.open() == 0) {
            Property condition = dialog.getInputData();
            FacilityTreeItem item = view.getScopeTreeComposite().getSelectItem();
            String facilityId = null;
            if (item != null) {
                facilityId = item.getData().getFacilityId();
            }
            PropertyUtil.deletePropertyDefine(condition);
            try {
                EventBatchConfirmInfo info = EventBatchConfirmPropertyUtil.property2dto(condition);
                MonitorEndpointWrapper.modifyBatchConfirm(1, facilityId, info);
                view.update();
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"mesasge.monitor.60")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                m_log.warn((Object)("run() modifyBatchConfirm, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

