/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.util;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.util.CalendarEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.calendar.CalendarInfo;
import com.clustercontrol.ws.calendar.CalendarNotFound_Exception;
import com.clustercontrol.ws.calendar.HinemosUnknown_Exception;
import com.clustercontrol.ws.calendar.InvalidRole_Exception;
import com.clustercontrol.ws.calendar.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorFilterInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

public class MonitorFilterPropertyUtil {
    private static Log m_log = LogFactory.getLog(MonitorFilterPropertyUtil.class);

    public static MonitorFilterInfo property2dto(Property property) {
        MonitorFilterInfo info = new MonitorFilterInfo();
        String monitorId = null;
        String monitorTypeId = null;
        String description = null;
        String facilityId = null;
        String calendarId = null;
        String regUser = null;
        Timestamp regFromDate = null;
        Timestamp regToDate = null;
        String updateUser = null;
        Timestamp updateFromDate = null;
        Timestamp updateToDate = null;
        int monitorFlg = -1;
        int collectorFlg = -1;
        String ownerRoleId = null;
        ArrayList values = null;
        values = PropertyUtil.getPropertyValue(property, "monitorId");
        if (!"".equals(values.get(0))) {
            monitorId = (String)values.get(0);
            info.setMonitorId(monitorId);
        }
        if (!"".equals((values = PropertyUtil.getPropertyValue(property, "monitorTypeId")).get(0))) {
            monitorTypeId = (String)values.get(0);
            info.setMonitorTypeId(monitorTypeId);
        }
        if (!"".equals((values = PropertyUtil.getPropertyValue(property, "description")).get(0))) {
            description = (String)values.get(0);
            info.setDescription(description);
        }
        if (!"".equals((values = PropertyUtil.getPropertyValue(property, "facilityId")).get(0))) {
            FacilityTreeItem item = (FacilityTreeItem)values.get(0);
            facilityId = item.getData().getFacilityId();
            info.setFacilityId(facilityId);
        }
        if (!"".equals((values = PropertyUtil.getPropertyValue(property, "calendarId")).get(0))) {
            calendarId = (String)values.get(0);
            info.setCalendarId(calendarId);
        }
        if (!"".equals((values = PropertyUtil.getPropertyValue(property, "regUser")).get(0))) {
            regUser = (String)values.get(0);
            info.setRegUser(regUser);
        }
        if ((values = PropertyUtil.getPropertyValue(property, "regFromDate")).get(0) instanceof Date) {
            regFromDate = new Timestamp(((Date)values.get(0)).getTime());
            regFromDate.setNanos(999999999);
            info.setRegFromDate(Long.valueOf(regFromDate.getTime()));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "regToDate")).get(0) instanceof Date) {
            regToDate = new Timestamp(((Date)values.get(0)).getTime());
            regToDate.setNanos(999999999);
            info.setRegToDate(Long.valueOf(regToDate.getTime()));
        }
        if (!"".equals((values = PropertyUtil.getPropertyValue(property, "updateUser")).get(0))) {
            updateUser = (String)values.get(0);
            info.setUpdateUser(updateUser);
        }
        if ((values = PropertyUtil.getPropertyValue(property, "updateFromDate")).get(0) instanceof Date) {
            updateFromDate = new Timestamp(((Date)values.get(0)).getTime());
            updateFromDate.setNanos(999999999);
            info.setUpdateFromDate(Long.valueOf(updateFromDate.getTime()));
        }
        if ((values = PropertyUtil.getPropertyValue(property, "updateToDate")).get(0) instanceof Date) {
            updateToDate = new Timestamp(((Date)values.get(0)).getTime());
            updateToDate.setNanos(999999999);
            info.setUpdateToDate(Long.valueOf(updateToDate.getTime()));
        }
        if (!"".equals((values = PropertyUtil.getPropertyValue(property, "monitorFlg")).get(0))) {
            monitorFlg = ValidConstant.STRING_VALID.equals(values.get(0)) ? 1 : (ValidConstant.STRING_INVALID.equals(values.get(0)) ? 0 : -1);
        }
        info.setMonitorFlg(Integer.valueOf(monitorFlg));
        values = PropertyUtil.getPropertyValue(property, "collectorFlg");
        if (!"".equals(values.get(0))) {
            collectorFlg = ValidConstant.STRING_VALID.equals(values.get(0)) ? 1 : (ValidConstant.STRING_INVALID.equals(values.get(0)) ? 0 : -1);
        }
        info.setCollectorFlg(Integer.valueOf(collectorFlg));
        values = PropertyUtil.getPropertyValue(property, "ownerRoleId");
        if (!"".equals(values.get(0))) {
            ownerRoleId = (String)values.get(0);
            info.setOwnerRoleId(ownerRoleId);
        }
        return info;
    }

    public static Property getProperty(Locale locale) {
        Property monitorId = new Property("monitorId", Messages.getString((String)"monitor.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT, 64);
        Property monitorTypeId = new Property("monitorTypeId", Messages.getString((String)"plugin.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT, 64);
        Property description = new Property("description", Messages.getString((String)"description", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT, 64);
        Property facilityId = new Property("facilityId", Messages.getString((String)"facility.name", (Locale)locale), PropertyDefineConstant.EDITOR_NODE, 64);
        Property calendarId = new Property("calendarId", Messages.getString((String)"calendar", (Locale)locale), PropertyDefineConstant.EDITOR_SELECT);
        Property regUser = new Property("regUser", Messages.getString((String)"creator.name", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT, 64);
        Property regDate = new Property("regDate", Messages.getString((String)"create.time", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        Property updateUser = new Property("updateUser", Messages.getString((String)"modifier.name", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT, 64);
        Property updateDate = new Property("updateDate", Messages.getString((String)"update.time", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT);
        Property monitorFlg = new Property("monitorFlg", Messages.getString((String)"monitor.valid.name", (Locale)locale), PropertyDefineConstant.EDITOR_SELECT);
        Property collectorFlg = new Property("collectorFlg", Messages.getString((String)"collector.valid.name", (Locale)locale), PropertyDefineConstant.EDITOR_SELECT);
        Property regFromDate = new Property("regFromDate", Messages.getString((String)"start", (Locale)locale), PropertyDefineConstant.EDITOR_DATETIME);
        Property regToDate = new Property("regToDate", Messages.getString((String)"end", (Locale)locale), PropertyDefineConstant.EDITOR_DATETIME);
        Property updateFromDate = new Property("updateFromDate", Messages.getString((String)"start", (Locale)locale), PropertyDefineConstant.EDITOR_DATETIME);
        Property updateToDate = new Property("updateToDate", Messages.getString((String)"end", (Locale)locale), PropertyDefineConstant.EDITOR_DATETIME);
        Property ownerRoleId = new Property("ownerRoleId", Messages.getString((String)"owner.role.id", (Locale)locale), PropertyDefineConstant.EDITOR_TEXT, 64);
        Object[][] monitorFlgValues = new Object[][]{{"", ValidConstant.STRING_VALID, ValidConstant.STRING_INVALID}, {"", ValidConstant.STRING_VALID, ValidConstant.STRING_INVALID}};
        Object[][] collectorFlgValues = new Object[][]{{"", ValidConstant.STRING_VALID, ValidConstant.STRING_INVALID}, {"", ValidConstant.STRING_VALID, ValidConstant.STRING_INVALID}};
        monitorFlg.setSelectValues(monitorFlgValues);
        monitorFlg.setValue(ValidConstant.STRING_VALID);
        collectorFlg.setSelectValues(collectorFlgValues);
        collectorFlg.setValue(ValidConstant.STRING_VALID);
        monitorId.setValue("");
        monitorTypeId.setValue("");
        description.setValue("");
        facilityId.setValue("");
        calendarId.setSelectValues(MonitorFilterPropertyUtil.getCalendarIdList());
        calendarId.setValue("");
        regUser.setValue("");
        regDate.setValue("");
        updateUser.setValue("");
        updateDate.setValue("");
        regFromDate.setValue("");
        regToDate.setValue("");
        updateFromDate.setValue("");
        updateToDate.setValue("");
        ownerRoleId.setValue("");
        monitorId.setModify(1);
        monitorTypeId.setModify(1);
        description.setModify(1);
        facilityId.setModify(1);
        calendarId.setModify(1);
        regUser.setModify(1);
        regDate.setModify(0);
        updateUser.setModify(1);
        updateDate.setModify(0);
        monitorFlg.setModify(1);
        collectorFlg.setModify(1);
        regFromDate.setModify(1);
        regToDate.setModify(1);
        updateFromDate.setModify(1);
        updateToDate.setModify(1);
        ownerRoleId.setModify(1);
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren(monitorId);
        property.addChildren(monitorTypeId);
        property.addChildren(description);
        property.addChildren(facilityId);
        property.addChildren(calendarId);
        property.addChildren(regUser);
        property.addChildren(regDate);
        property.addChildren(updateUser);
        property.addChildren(updateDate);
        property.addChildren(monitorFlg);
        property.addChildren(collectorFlg);
        property.addChildren(ownerRoleId);
        regDate.removeChildren();
        regDate.addChildren(regFromDate);
        regDate.addChildren(regToDate);
        updateDate.removeChildren();
        updateDate.addChildren(updateFromDate);
        updateDate.addChildren(updateToDate);
        return property;
    }

    private static Object[][] getCalendarIdList() {
        List<CalendarInfo> calList = null;
        Object[][] retArray = null;
        try {
            calList = CalendarEndpointWrapper.getAllCalendarList();
        }
        catch (InvalidUserPass_Exception invalidUserPass_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (HinemosUnknown_Exception e) {
            m_log.warn((Object)("getCalendarIdList(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        catch (CalendarNotFound_Exception e) {
            m_log.warn((Object)("getCalendarIdList(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        if (calList != null) {
            retArray = new Object[2][calList.size() + 1];
            retArray[0][0] = "";
            retArray[1][0] = "";
            int i = 0;
            while (i < calList.size()) {
                retArray[0][i + 1] = calList.get(i).getId();
                retArray[1][i + 1] = calList.get(i).getId();
                ++i;
            }
        } else {
            Object[][] nullArray = new Object[][]{{""}, {""}};
            retArray = nullArray;
        }
        return retArray;
    }
}

