/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.MonitorNumericValueInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NumericValueInfoComposite
extends Composite {
    public static final int WIDTH_TITLE = 4;
    public static final int WIDTH_VALUE = 2;
    public static final int INPUT_VERIFICATION_INTEGER_NUMBER = 0;
    public static final int INPUT_VERIFICATION_REAL_NUMBER = 1;
    public static final int INPUT_VERIFICATION_POSITIVE_INTEGER = 2;
    public static final int INPUT_VERIFICATION_POSITIVE_REAL = 3;
    private boolean m_rangeFlg = false;
    private String m_itemName1 = null;
    private String m_itemName2 = null;
    private Label m_textItemName1 = null;
    private Label m_textItemName2 = null;
    private String m_criterion1 = Messages.getString((String)"greater");
    private String m_criterion2 = Messages.getString((String)"less");
    private int m_inputVerifyType1 = 0;
    private int m_inputVerifyType2 = 0;
    private Double m_value1Info = null;
    private Double m_value2Info = null;
    private Double m_value1Warn = null;
    private Double m_value2Warn = null;
    private Text m_textValue1Info = null;
    private Text m_textValue2Info = null;
    private Text m_textValue1Warn = null;
    private Text m_textValue2Warn = null;

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType;
        this.m_inputVerifyType2 = inputVerifyType;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType1, int inputVerifyType2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, String criterion1, String criterion2, int inputVerifyType) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_criterion1 = criterion1;
        this.m_criterion2 = criterion2;
        this.m_inputVerifyType1 = inputVerifyType;
        this.m_inputVerifyType2 = inputVerifyType;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, String criterion1, String criterion2, int inputVerifyType1, int inputVerifyType2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_criterion1 = criterion1;
        this.m_criterion2 = criterion2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType, Double inputValue1, Double inputValue2) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType;
        this.m_inputVerifyType2 = inputVerifyType;
        this.m_value1Info = inputValue1;
        this.m_value1Warn = inputValue1;
        this.m_value2Info = inputValue2;
        this.m_value2Warn = inputValue2;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, int inputVerifyType1, int inputVerifyType2, Double inputValue1Info, Double inputValue2Info, Double inputValue1Warn, Double inputValue2Warn) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.m_value1Info = inputValue1Info;
        this.m_value1Warn = inputValue1Warn;
        this.m_value2Info = inputValue2Info;
        this.m_value2Warn = inputValue2Warn;
        this.initialize();
    }

    public NumericValueInfoComposite(Composite parent, int style, boolean rangeFlg, String item1, String item2, String criterion1, String criterion2, int inputVerifyType1, int inputVerifyType2, Double inputValue1Info, Double inputValue2Info, Double inputValue1Warn, Double inputValue2Warn) {
        super(parent, style);
        this.m_rangeFlg = rangeFlg;
        this.m_itemName1 = item1;
        this.m_itemName2 = item2;
        this.m_criterion1 = criterion1;
        this.m_criterion2 = criterion2;
        this.m_inputVerifyType1 = inputVerifyType1;
        this.m_inputVerifyType2 = inputVerifyType2;
        this.m_value1Info = inputValue1Info;
        this.m_value1Warn = inputValue1Warn;
        this.m_value2Info = inputValue2Info;
        this.m_value2Warn = inputValue2Warn;
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textItemName1 = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textItemName1.setLayoutData((Object)gridData);
        this.m_textItemName1.setText(this.m_itemName1);
        this.m_textItemName2 = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textItemName2.setLayoutData((Object)gridData);
        this.m_textItemName2.setText(this.m_itemName2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority(this, Messages.getString((String)"info"), PriorityColorConstant.COLOR_INFO);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textValue1Info = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textValue1Info.setLayoutData((Object)gridData);
        this.m_textValue1Info.setText("0");
        this.m_textValue1Info.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NumericValueInfoComposite.this.update();
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion1);
        this.m_textValue2Info = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textValue2Info.setLayoutData((Object)gridData);
        this.m_textValue2Info.setText("0");
        this.m_textValue2Info.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NumericValueInfoComposite.this.update();
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority(this, Messages.getString((String)"warning"), PriorityColorConstant.COLOR_WARNING);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.m_textValue1Warn = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textValue1Warn.setLayoutData((Object)gridData);
        this.m_textValue1Warn.setText("0");
        this.m_textValue1Warn.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NumericValueInfoComposite.this.update();
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion1);
        this.m_textValue2Warn = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textValue2Warn.setLayoutData((Object)gridData);
        this.m_textValue2Warn.setText("0");
        this.m_textValue2Warn.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NumericValueInfoComposite.this.update();
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.m_criterion2);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = this.getLabelPriority(this, Messages.getString((String)"critical"), PriorityColorConstant.COLOR_CRITICAL);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"other.priority"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void update() {
        if (this.m_textValue1Info.getEnabled() && "".equals(this.m_textValue1Info.getText())) {
            this.m_textValue1Info.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textValue1Info.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_textValue2Info.getEnabled() && "".equals(this.m_textValue2Info.getText())) {
            this.m_textValue2Info.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textValue2Info.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_textValue1Warn.getEnabled() && "".equals(this.m_textValue1Warn.getText())) {
            this.m_textValue1Warn.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textValue1Warn.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_textValue2Warn.getEnabled() && "".equals(this.m_textValue2Warn.getText())) {
            this.m_textValue2Warn.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textValue2Warn.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public void setInputData(MonitorInfo info) {
        if (info != null) {
            List list = info.getNumericValueInfo();
            if (list != null) {
                int index = 0;
                while (index < list.size()) {
                    MonitorNumericValueInfo numericValueInfo = (MonitorNumericValueInfo)list.get(index);
                    if (numericValueInfo != null) {
                        String upper;
                        String lower;
                        if (3 == numericValueInfo.getPriority()) {
                            lower = "";
                            upper = "";
                            lower = this.m_inputVerifyType1 == 0 || this.m_inputVerifyType1 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdLowerLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdLowerLimit());
                            upper = this.m_inputVerifyType2 == 0 || this.m_inputVerifyType2 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdUpperLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdUpperLimit());
                            this.m_textValue1Info.setText(lower);
                            this.m_textValue2Info.setText(upper);
                        } else if (2 == numericValueInfo.getPriority()) {
                            lower = "";
                            upper = "";
                            lower = this.m_inputVerifyType1 == 0 || this.m_inputVerifyType1 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdLowerLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdLowerLimit());
                            upper = this.m_inputVerifyType2 == 0 || this.m_inputVerifyType2 == 2 ? Long.toString(Double.valueOf(numericValueInfo.getThresholdUpperLimit()).longValue()) : Double.toString(numericValueInfo.getThresholdUpperLimit());
                            this.m_textValue1Warn.setText(lower);
                            this.m_textValue2Warn.setText(upper);
                        }
                    }
                    ++index;
                }
            }
            this.update();
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        ArrayList<MonitorNumericValueInfo> valueList = new ArrayList<MonitorNumericValueInfo>();
        String lowerText = null;
        String upperText = null;
        Double lower = null;
        Double upper = null;
        MonitorNumericValueInfo valueInfo = this.getDefaultValueInfo(info, 3);
        lowerText = this.m_textValue1Info.getText();
        upperText = this.m_textValue2Info.getText();
        if (lowerText != null && !"".equals(lowerText.trim())) {
            try {
                lower = Double.valueOf(lowerText);
                valueInfo.setThresholdLowerLimit(lower);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName1};
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.3", (Object[])args));
            }
        }
        if (upperText != null && !"".equals(upperText.trim())) {
            try {
                upper = Double.valueOf(upperText);
                valueInfo.setThresholdUpperLimit(upper);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName2};
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.4", (Object[])args));
            }
        }
        valueList.add(valueInfo);
        MonitorNumericValueInfo valueWarn = this.getDefaultValueInfo(info, 2);
        lowerText = this.m_textValue1Warn.getText();
        upperText = this.m_textValue2Warn.getText();
        if (lowerText != null && !"".equals(lowerText.trim())) {
            try {
                lower = Double.valueOf(lowerText);
                valueWarn.setThresholdLowerLimit(lower);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName1};
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.5", (Object[])args));
            }
        }
        if (this.m_textValue2Warn.getText() != null && !"".equals(this.m_textValue2Warn.getText().trim())) {
            try {
                upper = Double.valueOf(upperText);
                valueWarn.setThresholdUpperLimit(upper);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] args = new String[]{this.m_itemName2};
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.6", (Object[])args));
            }
        }
        valueList.add(valueWarn);
        MonitorNumericValueInfo valueCritical = this.getDefaultValueInfo(info, 0);
        valueCritical.setThresholdLowerLimit(Double.valueOf(0.0));
        valueCritical.setThresholdUpperLimit(Double.valueOf(0.0));
        valueList.add(valueCritical);
        MonitorNumericValueInfo valueUnknown = this.getDefaultValueInfo(info, 1);
        valueUnknown.setThresholdLowerLimit(Double.valueOf(0.0));
        valueUnknown.setThresholdUpperLimit(Double.valueOf(0.0));
        valueList.add(valueUnknown);
        List valueInfoList = info.getNumericValueInfo();
        valueInfoList.clear();
        valueInfoList.addAll(valueList);
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_textValue1Info.setEnabled(enabled);
        this.m_textValue2Info.setEnabled(enabled);
        this.m_textValue1Warn.setEnabled(enabled);
        this.m_textValue2Warn.setEnabled(enabled);
        this.update();
    }

    private Label getLabelPriority(Composite parent, String text, Color background) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        label.setBackground(background);
        return label;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    private MonitorNumericValueInfo getDefaultValueInfo(MonitorInfo info, int priority) {
        MonitorNumericValueInfo value = new MonitorNumericValueInfo();
        value.setMonitorId(info.getMonitorId());
        value.setMonitorTypeId(info.getMonitorTypeId());
        value.setPriority(Integer.valueOf(priority).intValue());
        return value;
    }

    public void setRangeFlg(boolean rangeFlg) {
        this.m_rangeFlg = rangeFlg;
    }

    public void setTextItem1(String item1) {
        this.m_textItemName1.setText(item1);
    }

    public void setTextItem2(String item2) {
        this.m_textItemName2.setText(item2);
    }

    public void setInfoWarnText(String info1, String info2, String warn1, String warn2) {
        this.m_textValue1Info.setText(info1);
        this.m_textValue2Info.setText(info2);
        this.m_textValue1Warn.setText(warn1);
        this.m_textValue2Warn.setText(warn2);
    }
}

