/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.dialog.CommonMonitorDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.MonitorInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MonitorBasicComposite
extends Composite {
    public static final int WIDTH_TITLE = 4;
    public static final int WIDTH_VALUE = 2;
    public static final int WIDTH_TEXT = 8;
    private Text m_textMonitorId = null;
    private Text m_textDescription = null;
    protected RoleIdListComposite m_ownerRoleId = null;
    private CommonMonitorDialog parentDialog = null;

    public MonitorBasicComposite(Composite parent, int style, CommonMonitorDialog parentDialog) {
        super(parent, style);
        this.parentDialog = parentDialog;
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"monitor.id")) + " : ");
        this.m_textMonitorId = new Text((Composite)this, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMonitorId.setLayoutData((Object)gridData);
        this.m_textMonitorId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MonitorBasicComposite.this.update();
            }
        });
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.m_textDescription = new Text((Composite)this, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Label labelRoleId = new Label((Composite)this, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelRoleId.setLayoutData((Object)gridData);
        labelRoleId.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : ");
        if (this.parentDialog.getUpdateFlg()) {
            this.m_ownerRoleId = new RoleIdListComposite(this, 0, false, RoleIdListComposite.Mode.OWNER_ROLE);
        } else {
            this.m_ownerRoleId = new RoleIdListComposite(this, 0, true, RoleIdListComposite.Mode.OWNER_ROLE);
            this.m_ownerRoleId.getComboRoleId().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MonitorBasicComposite.this.updateOwnerRole();
                }
            });
        }
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_ownerRoleId.setLayoutData(gridData);
    }

    public void update() {
        if (this.m_textMonitorId.getEnabled() && "".equals(this.m_textMonitorId.getText())) {
            this.m_textMonitorId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textMonitorId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    private void updateOwnerRole() {
        this.parentDialog.getMonitorRule().getCalendarId().setOwnerRoleId(this.m_ownerRoleId.getText());
        this.parentDialog.getNotifyInfo().setOwnerRoleId(this.m_ownerRoleId.getText());
        this.parentDialog.getMonitorBasicScope().setOwnerRoleId(this.m_ownerRoleId.getText());
    }

    public void setInputData(MonitorInfo info, boolean updateFlg) {
        if (info != null) {
            if (info.getMonitorId() != null) {
                this.m_textMonitorId.setText(info.getMonitorId());
                if (updateFlg) {
                    this.m_textMonitorId.setEnabled(false);
                }
            }
            if (info.getDescription() != null) {
                this.m_textDescription.setText(info.getDescription());
            }
            if (info.getOwnerRoleId() != null) {
                this.m_ownerRoleId.setText(info.getOwnerRoleId());
            }
        }
        this.updateOwnerRole();
        this.update();
    }

    public ValidateResult createInputData(MonitorInfo info) {
        if (info != null) {
            if (this.m_textMonitorId.getText() != null && !"".equals(this.m_textMonitorId.getText().trim())) {
                info.setMonitorId(this.m_textMonitorId.getText());
            }
            if (this.m_textDescription.getText() != null && !"".equals(this.m_textDescription.getText().trim())) {
                info.setDescription(this.m_textDescription.getText());
            }
            if (this.m_ownerRoleId.getText().length() > 0) {
                info.setOwnerRoleId(this.m_ownerRoleId.getText());
            }
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.m_textMonitorId.setEnabled(enabled);
        this.m_textDescription.setEnabled(enabled);
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

