/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.preference;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.monitor.view.ScopeView;
import com.clustercontrol.monitor.view.StatusView;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

public class MonitorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_SCOPE_UPDATE_FLG = "scopeUpdateFlg";
    public static final String P_SCOPE_UPDATE_CYCLE = "scopeUpdateCycle";
    public static final String P_STATUS_UPDATE_FLG = "statusUpdateFlg";
    public static final String P_STATUS_UPDATE_CYCLE = "stateUpdateCycle";
    public static final String P_EVENT_UPDATE_FLG = "eventUpdateFlg";
    public static final String P_EVENT_UPDATE_CYCLE = "eventUpdateCycle";
    public static final String P_EVENT_MESSAGE_FLG = "eventMessageFlg";
    public static final String P_EVENT_MAX = "eventMaxMessages";
    private static final String MSG_ENABLE = Messages.getString((String)"autoupdate.enable");
    private static final String MSG_CYCLE = String.valueOf(Messages.getString((String)"autoupdate.cycle")) + " : ";
    private static final String MSG_MESSAGE = Messages.getString((String)"over.limit.message");
    private static final String MSG_MAX_EVENTS = String.valueOf(Messages.getString((String)"number.of.display.events")) + " : ";

    public MonitorPreferencePage() {
        super(1);
        this.setPreferenceStore(ClusterControlPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        Group scopeGroup = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        scopeGroup.setLayoutData((Object)gridData);
        scopeGroup.setText(Messages.getString((String)"view.monitor.scope"));
        this.addField((FieldEditor)new BooleanFieldEditor(P_SCOPE_UPDATE_FLG, MSG_ENABLE, (Composite)scopeGroup));
        IntegerFieldEditor scopeCycle = new IntegerFieldEditor(P_SCOPE_UPDATE_CYCLE, MSG_CYCLE, (Composite)scopeGroup);
        scopeCycle.setValidRange(1, Short.MAX_VALUE);
        Object[] args = new String[]{Integer.toString(1), Integer.toString(Short.MAX_VALUE)};
        scopeCycle.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])args));
        this.addField((FieldEditor)scopeCycle);
        Group statusGroup = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        statusGroup.setLayoutData((Object)gridData);
        statusGroup.setText(Messages.getString((String)"view.monitor.status"));
        this.addField((FieldEditor)new BooleanFieldEditor(P_STATUS_UPDATE_FLG, MSG_ENABLE, (Composite)statusGroup));
        IntegerFieldEditor statusCycle = new IntegerFieldEditor(P_STATUS_UPDATE_CYCLE, MSG_CYCLE, (Composite)statusGroup);
        statusCycle.setValidRange(1, Short.MAX_VALUE);
        statusCycle.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])args));
        this.addField((FieldEditor)statusCycle);
        Group eventGroup = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        eventGroup.setLayoutData((Object)gridData);
        eventGroup.setText(Messages.getString((String)"view.monitor.event"));
        this.addField((FieldEditor)new BooleanFieldEditor(P_EVENT_UPDATE_FLG, MSG_ENABLE, (Composite)eventGroup));
        IntegerFieldEditor eventCycle = new IntegerFieldEditor(P_EVENT_UPDATE_CYCLE, MSG_CYCLE, (Composite)eventGroup);
        eventCycle.setValidRange(1, Short.MAX_VALUE);
        eventCycle.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])args));
        this.addField((FieldEditor)eventCycle);
        this.addField((FieldEditor)new BooleanFieldEditor(P_EVENT_MESSAGE_FLG, MSG_MESSAGE, (Composite)eventGroup));
        IntegerFieldEditor eventMax = new IntegerFieldEditor(P_EVENT_MAX, MSG_MAX_EVENTS, (Composite)eventGroup);
        eventMax.setValidRange(1, 1000);
        Object[] argsEvent = new String[]{Integer.toString(1), Integer.toString(1000)};
        eventMax.setErrorMessage(Messages.getString((String)"message.hinemos.8", (Object[])argsEvent));
        this.addField((FieldEditor)eventMax);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.applySetting();
        return result;
    }

    private void applySetting() {
        IPreferenceStore store = this.getPreferenceStore();
        IWorkbench workbench = ClusterControlPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int windowCount = windows.length;
        int i = 0;
        while (i < windowCount) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int pageCount = pages.length;
            int j = 0;
            while (j < pageCount) {
                EventView eventView;
                StatusView statusView;
                ScopeView scopeView = (ScopeView)pages[j].findView("com.clustercontrol.monitor.view.ScopeView");
                if (scopeView != null) {
                    int cycle = store.getInt(P_SCOPE_UPDATE_CYCLE);
                    scopeView.setInterval(cycle);
                    if (store.getBoolean(P_SCOPE_UPDATE_FLG)) {
                        scopeView.startAutoReload();
                    } else {
                        scopeView.stopAutoReload();
                    }
                }
                if ((statusView = (StatusView)pages[j].findView("com.clustercontrol.monitor.view.StatusView")) != null) {
                    int cycle = store.getInt(P_STATUS_UPDATE_CYCLE);
                    statusView.setInterval(cycle);
                    if (store.getBoolean(P_STATUS_UPDATE_FLG)) {
                        statusView.startAutoReload();
                    } else {
                        statusView.stopAutoReload();
                    }
                }
                if ((eventView = (EventView)pages[j].findView("com.clustercontrol.monitor.view.EventView")) != null) {
                    int cycle = store.getInt(P_EVENT_UPDATE_CYCLE);
                    eventView.setInterval(cycle);
                    if (store.getBoolean(P_EVENT_UPDATE_FLG)) {
                        eventView.startAutoReload();
                    } else {
                        eventView.stopAutoReload();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void init(IWorkbench workbench) {
    }
}

