/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.bean.MonitorTypeMstConstant;
import com.clustercontrol.monitor.composite.MonitorTypeListComposite;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.view.MonitorListView;
import com.clustercontrol.monitor.view.action.MonitorModifyAction;
import com.clustercontrol.plugin.monitor.IMonitorPlugin;
import com.clustercontrol.plugin.monitor.LoadMonitorPlugin;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MonitorTypeDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(MonitorTypeDialog.class);
    private final int sizeX = 300;
    private final int sizeY = 300;
    private MonitorTypeListComposite listComposite = null;
    private ListViewer monitorTypeList = null;
    private MonitorListView view = null;

    public MonitorTypeDialog(Shell parent, MonitorListView view) {
        super(parent);
        this.view = view;
    }

    protected Point getInitialSize() {
        return new Point(300, 300);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        parent.getShell().setText(Messages.getString((String)"monitor.type"));
        GridLayout layout = new GridLayout(5, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.listComposite = new MonitorTypeListComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        this.listComposite.setLayoutData(gridData);
        this.monitorTypeList = this.listComposite.getMonitorTypeList();
        this.monitorTypeList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ArrayList list = (ArrayList)element;
                String pluginName = null;
                String pluginId = (String)list.get(0);
                if (pluginId.equals("MON_AGT")) {
                    pluginName = Messages.getString((String)"agent.monitor");
                } else if (pluginId.equals("MON_HTP")) {
                    pluginName = Messages.getString((String)"http.monitor");
                } else if (pluginId.equals("MON_PRF")) {
                    pluginName = Messages.getString((String)"performance.monitor");
                } else if (pluginId.equals("MON_PNG")) {
                    pluginName = Messages.getString((String)"ping.monitor");
                } else if (pluginId.equals("MON_PRT")) {
                    pluginName = Messages.getString((String)"port.monitor");
                } else if (pluginId.equals("MON_PRC")) {
                    pluginName = Messages.getString((String)"process.monitor");
                } else if (pluginId.equals("MON_SNMP")) {
                    pluginName = Messages.getString((String)"snmp.monitor");
                } else if (pluginId.equals("MON_SQL")) {
                    pluginName = Messages.getString((String)"sql.monitor");
                } else if (pluginId.equals("MON_SYSLOG")) {
                    pluginName = Messages.getString((String)"systemlog.monitor");
                } else if (pluginId.equals("MON_LOGFILE")) {
                    pluginName = Messages.getString((String)"logfile.monitor");
                } else if (pluginId.equals("MON_CUSTOM")) {
                    pluginName = Messages.getString((String)"custom.monitor");
                } else if (pluginId.equals("MON_SNMP_TRP")) {
                    pluginName = Messages.getString((String)"snmptrap.monitor");
                } else if (pluginId.equals("MON_WINSERVICE")) {
                    pluginName = Messages.getString((String)"winservice.monitor");
                } else if (pluginId.equals("MON_WINEVENT")) {
                    pluginName = Messages.getString((String)"winevent.monitor");
                } else {
                    for (IMonitorPlugin extensionMonitor : LoadMonitorPlugin.getExtensionMonitorList()) {
                        if (!pluginId.equals(extensionMonitor.getMonitorPluginId())) continue;
                        pluginName = extensionMonitor.getMonitorName();
                    }
                    if (pluginName == null) {
                        pluginName = pluginId;
                    }
                }
                return String.valueOf(pluginName) + " (" + MonitorTypeConstant.typeToString((int)((Integer)list.get(1))) + ")";
            }
        });
        for (ArrayList a : MonitorTypeMstConstant.getListAll()) {
            this.monitorTypeList.add((Object)a);
        }
        this.monitorTypeList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MonitorTypeDialog.this.okPressed();
            }
        });
        shell.pack();
        shell.setSize(new Point(shell.getSize().x, shell.getSize().y));
    }

    public ArrayList getSelectItem() {
        return this.listComposite.getSelectItem();
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"next");
    }

    @Override
    protected void okPressed() {
        if (this.getSelectItem() == null) {
            ValidateResult result = null;
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.monitor.57"));
            this.displayError(result);
        }
        String pluginId = (String)this.getSelectItem().get(0);
        Integer monitorType = (Integer)this.getSelectItem().get(1);
        MonitorModifyAction action = new MonitorModifyAction();
        action.dialogOpen(this.getParentShell(), pluginId, null, monitorType);
        this.view.update();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

