/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.dialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.monitor.util.EventDataPropertyUtil;
import com.clustercontrol.monitor.util.MonitorEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.PropertySheet;
import com.clustercontrol.ws.monitor.EventDataInfo;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EventInfoDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(EventInfoDialog.class);
    private List m_list = null;
    private PropertySheet propertySheet = null;
    private static Property eventCommentProperty = null;

    public EventInfoDialog(Shell parent, List list) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.m_list = list;
    }

    protected Point getInitialSize() {
        return new Point(500, 650);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.monitor.info.events"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        TableTree table = new TableTree(parent, 68356);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.propertySheet = new PropertySheet(table);
        this.propertySheet.setSize(170, 280);
        eventCommentProperty = null;
        if (this.m_list != null) {
            String monitorId = (String)this.m_list.get(4);
            String monitorDetailId = (String)this.m_list.get(5);
            String pluginId = (String)this.m_list.get(3);
            String facilityId = (String)this.m_list.get(6);
            Date receiveTime = (Date)this.m_list.get(1);
            try {
                EventDataInfo info = MonitorEndpointWrapper.getEventInfo(monitorId, monitorDetailId, pluginId, facilityId, receiveTime.getTime());
                eventCommentProperty = EventDataPropertyUtil.dto2property(info, Locale.getDefault());
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("customizeDialog() getEventInfo, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
        }
        this.propertySheet.setInput(eventCommentProperty);
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    public Property getInputData() {
        if (eventCommentProperty != null) {
            Property copy = PropertyUtil.copy(eventCommentProperty);
            return copy;
        }
        return null;
    }

    public void setInputData(Property property) {
        this.propertySheet.setInput(property);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.getString((String)"register"), true);
        this.createButton(parent, 1, Messages.getString((String)"cancel"), false);
    }
}

