/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.composite;

import com.clustercontrol.accesscontrol.util.LocalSession;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.action.GetStatusListTableDefine;
import com.clustercontrol.monitor.util.ConvertListUtil;
import com.clustercontrol.monitor.util.MonitorEndpointWrapper;
import com.clustercontrol.monitor.util.StatusFilterPropertyUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.StatusDataInfo;
import com.clustercontrol.ws.monitor.StatusFilterInfo;
import com.sun.xml.internal.ws.client.ClientTransportException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class StatusListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(StatusListComposite.class);
    private CommonTableViewer tableViewer = null;
    private Label criticalLabel = null;
    private Label warningLabel = null;
    private Label infoLabel = null;
    private Label unknownLabel = null;
    private Label totalLabel = null;

    public StatusListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(5, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 5;
        table.setLayoutData((Object)gridData);
        this.criticalLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.criticalLabel.setLayoutData((Object)gridData);
        this.criticalLabel.setBackground(this.getDisplay().getSystemColor(3));
        this.warningLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.warningLabel.setLayoutData((Object)gridData);
        this.warningLabel.setBackground(this.getDisplay().getSystemColor(7));
        this.infoLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.infoLabel.setLayoutData((Object)gridData);
        this.infoLabel.setBackground(this.getDisplay().getSystemColor(5));
        this.unknownLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.unknownLabel.setLayoutData((Object)gridData);
        this.unknownLabel.setBackground(new Color(null, 128, 192, 255));
        this.totalLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetStatusListTableDefine.getStatusListTableDefine(), 4, 1);
        int i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).setMoveable(true);
            ++i;
        }
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update(String facilityId) {
        ArrayList infoList;
        block9: {
            super.update();
            infoList = null;
            try {
                List<StatusDataInfo> records = null;
                records = MonitorEndpointWrapper.getStatusList(facilityId, null);
                infoList = ConvertListUtil.statusInfoDataListToArrayList(records);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                if (LocalSession.isDialogFlag()) {
                    LocalSession.setDialogFlag(false);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    LocalSession.setDialogFlag(true);
                }
            }
            catch (MonitorNotFound_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.65")) + ", " + e.getMessage()));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.65")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                if (!LocalSession.isDialogFlag()) break block9;
                LocalSession.setDialogFlag(false);
                if (e instanceof ClientTransportException) {
                    m_log.info((Object)("update() getEventList, " + e.getMessage()));
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.transfer")) + ", " + e.getMessage()));
                } else {
                    m_log.warn((Object)("update() getStatusListAll, " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                LocalSession.setDialogFlag(true);
            }
        }
        if (infoList == null) {
            infoList = new ArrayList();
        }
        this.updateStatus(infoList);
        Object[] args = new Object[]{this.totalLabel.getText()};
        this.totalLabel.setText(Messages.getString((String)"records", (Object[])args));
        this.tableViewer.setInput(infoList);
    }

    public void update(String facilityId, Property condition) {
        ArrayList infoList;
        block9: {
            super.update();
            infoList = null;
            try {
                PropertyUtil.deletePropertyDefine(condition);
                List<StatusDataInfo> records = null;
                StatusFilterInfo filter = StatusFilterPropertyUtil.property2dto(condition);
                records = MonitorEndpointWrapper.getStatusList(facilityId, filter);
                infoList = ConvertListUtil.statusInfoDataListToArrayList(records);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                if (LocalSession.isDialogFlag()) {
                    LocalSession.setDialogFlag(false);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    LocalSession.setDialogFlag(true);
                }
            }
            catch (MonitorNotFound_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.65")) + ", " + e.getMessage()));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.65")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                if (!LocalSession.isDialogFlag()) break block9;
                LocalSession.setDialogFlag(false);
                if (e instanceof ClientTransportException) {
                    m_log.info((Object)("update() getEventList, " + e.getMessage()));
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.transfer")) + ", " + e.getMessage()));
                } else {
                    m_log.warn((Object)("update() getEventList, " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
                LocalSession.setDialogFlag(true);
            }
        }
        if (infoList == null) {
            infoList = new ArrayList();
        }
        this.updateStatus(infoList);
        Object[] args = new Object[]{this.totalLabel.getText()};
        this.totalLabel.setText(Messages.getString((String)"filtered.records", (Object[])args));
        this.tableViewer.setInput(infoList);
    }

    private void updateStatus(ArrayList list) {
        int[] status = new int[4];
        if (list != null) {
            int count = list.size();
            int i = 0;
            while (i < count) {
                ArrayList data = (ArrayList)list.get(i);
                int value = (Integer)data.get(0);
                switch (value) {
                    case 0: {
                        status[0] = status[0] + 1;
                        break;
                    }
                    case 2: {
                        status[1] = status[1] + 1;
                        break;
                    }
                    case 3: {
                        status[2] = status[2] + 1;
                        break;
                    }
                    case 1: {
                        status[3] = status[3] + 1;
                    }
                }
                ++i;
            }
        }
        this.criticalLabel.setText(String.valueOf(status[0]));
        this.warningLabel.setText(String.valueOf(status[1]));
        this.infoLabel.setText(String.valueOf(status[2]));
        this.unknownLabel.setText(String.valueOf(status[3]));
        int total = status[0] + status[1] + status[2] + status[3];
        this.totalLabel.setText(String.valueOf(total));
    }
}

