/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.run.action.GetMonitorListTableDefine;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.util.MonitorFilterPropertyUtil;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.monitor.view.action.MonitorModifyAction;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorFilterInfo;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class MonitorListComposite
extends Composite {
    private static Log m_log = LogFactory.getLog(MonitorListComposite.class);
    private CommonTableViewer tableViewer = null;
    private Label statuslabel = null;
    private Label totalLabel = null;
    private Property condition = null;
    private Composite composite = null;

    public MonitorListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.composite = this;
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.statuslabel = new Label((Composite)this, 16384);
        this.statuslabel.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.statuslabel.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetMonitorListTableDefine.get(), 0, 1);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MonitorModifyAction action;
                String pluginId = "";
                String monitorId = "";
                int monitorType = 0;
                if (((StructuredSelection)event.getSelection()).getFirstElement() != null) {
                    ArrayList info = (ArrayList)((StructuredSelection)event.getSelection()).getFirstElement();
                    pluginId = (String)info.get(1);
                    monitorId = (String)info.get(0);
                    monitorType = MonitorTypeConstant.stringToType((String)((String)info.get(2)));
                }
                if (pluginId != null && monitorId != null && (action = new MonitorModifyAction()).dialogOpen(MonitorListComposite.this.composite.getShell(), pluginId, monitorId, monitorType) == 0) {
                    MonitorListComposite.this.composite.update();
                }
            }
        });
        this.totalLabel = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.totalLabel.setLayoutData((Object)gridData);
    }

    public void update() {
        List<MonitorInfo> list = null;
        if (this.condition == null) {
            this.statuslabel.setText("");
            try {
                list = MonitorSettingEndpointWrapper.getMonitorList();
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (MonitorNotFound_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.67")) + ", " + e.getMessage()));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.67")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                m_log.warn((Object)("update() getMonitorList, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
            if (list == null) {
                list = new ArrayList<MonitorInfo>();
            }
        } else {
            this.statuslabel.setText(Messages.getString((String)"filtered.list"));
            PropertyUtil.deletePropertyDefine(this.condition);
            MonitorFilterInfo filter = MonitorFilterPropertyUtil.property2dto(this.condition);
            try {
                list = MonitorSettingEndpointWrapper.getMonitorListByCondition(filter);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (HinemosUnknown_Exception e) {
                MessageDialog.openError(null, (String)Messages.getString((String)"message"), (String)(String.valueOf(Messages.getString((String)"message.monitor.67")) + ", " + e.getMessage()));
            }
            catch (Exception e) {
                m_log.warn((Object)("update() getMonitorListByCondition, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
            if (list == null) {
                list = new ArrayList<MonitorInfo>();
            }
        }
        if (list == null) {
            list = new ArrayList<MonitorInfo>();
        }
        ArrayList listInput = new ArrayList();
        for (MonitorInfo monitor : list) {
            ArrayList<Object> a = new ArrayList<Object>();
            a.add(monitor.getMonitorId());
            a.add(monitor.getMonitorTypeId());
            a.add(MonitorTypeConstant.typeToString((int)monitor.getMonitorType()));
            a.add(monitor.getDescription());
            a.add(monitor.getScope());
            a.add(monitor.getCalendarId());
            if (monitor.getRunInterval() == 0) {
                a.add("-");
            } else {
                a.add(String.valueOf(monitor.getRunInterval() / 60) + Messages.getString((String)"minute"));
            }
            a.add(monitor.getMonitorFlg());
            a.add(monitor.getCollectorFlg());
            a.add(monitor.getOwnerRoleId());
            a.add(monitor.getRegUser());
            a.add(new Date(monitor.getRegDate()));
            a.add(monitor.getUpdateUser());
            a.add(new Date(monitor.getUpdateDate()));
            listInput.add(a);
        }
        this.tableViewer.setInput(listInput);
        Object[] args = new String[]{String.valueOf(list.size())};
        String message = null;
        message = this.condition == null ? Messages.getString((String)"records", (Object[])args) : Messages.getString((String)"filtered.records", (Object[])args);
        this.totalLabel.setText(message);
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void update(Property condition) {
        this.condition = condition;
        this.update();
    }
}

