/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.view.action;

import com.clustercontrol.maintenance.composite.MaintenanceListComposite;
import com.clustercontrol.maintenance.util.MaintenanceEndpointWrapper;
import com.clustercontrol.maintenance.view.MaintenanceListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.maintenance.InvalidRole_Exception;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class MaintenanceDeleteAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(MaintenanceDeleteAction.class);
    public static final String ID = "com.clustercontrol.maintenance.view.action.MaintenanceDeleteAction";
    private IViewPart viewPart;

    public void run(IAction action) {
        MaintenanceListView view = (MaintenanceListView)this.viewPart.getAdapter(MaintenanceListView.class);
        MaintenanceListComposite composite = (MaintenanceListComposite)view.getListComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        List list = (List)selection.getFirstElement();
        String maintenanceId = null;
        if (list != null && list.size() > 0) {
            maintenanceId = (String)list.get(0);
        }
        Object[] args = new String[]{maintenanceId};
        if (maintenanceId != null) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.maintenance.7", (Object[])args))) {
                try {
                    MaintenanceEndpointWrapper.deleteMaintenance(maintenanceId);
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.maintenance.5", (Object[])args));
                    composite.update();
                }
                catch (InvalidRole_Exception invalidRole_Exception) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
                catch (Exception e) {
                    m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                }
            }
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString((String)"warning"), (String)Messages.getString((String)"message.maintenance.9"));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }
}

