/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.util.JobEditStateUtil;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidObjectPrivilege_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class RegisterJobAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(RegisterJobAction.class);
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void run(IAction action) {
        JobTreeComposite tree;
        JobTreeItem selectedItem = null;
        JobListView view = (JobListView)this.m_view.getAdapter(JobListView.class);
        if (view instanceof JobListView && (selectedItem = (tree = view.getJobTreeComposite()).getSelectItem()) instanceof JobTreeItem && MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.job.31"))) {
            boolean error = false;
            HashMap<Object, String> resultList = new HashMap<Object, String>();
            ArrayList<JobTreeItem> releaseList = new ArrayList<JobTreeItem>();
            m_log.debug((Object)("registerJob start " + new Date()));
            Long start = System.currentTimeMillis();
            Long t_start = System.currentTimeMillis();
            m_log.debug((Object)"deleteJobunit start");
            for (JobTreeItem jobunit : JobEditStateUtil.getDeletedJobunitList()) {
                Iterator jobunitId;
                try {
                    String jobunitId2 = jobunit.getData().getJobunitId();
                    m_log.debug((Object)("delete " + jobunitId2));
                    JobEndpointWrapper.checkEditLock(jobunitId2, JobEditStateUtil.getEditSession(jobunit.getData()));
                    JobEndpointWrapper.deleteJobunit(jobunitId2);
                    if (!JobEditStateUtil.getEditedJobunitList().contains(jobunit)) {
                        releaseList.add(jobunit);
                        JobEditStateUtil.removeJobunitUpdateTime(jobunitId2);
                    }
                    resultList.put(jobunitId2, Messages.getString((String)"message.job.75"));
                }
                catch (InvalidRole_Exception e) {
                    m_log.error((Object)("run() delete: " + e.getMessage()));
                    error = true;
                    jobunitId = jobunit.getData().getJobunitId();
                    resultList.put(jobunitId, Messages.getString((String)"message.accesscontrol.16"));
                }
                catch (InvalidObjectPrivilege_Exception e) {
                    m_log.error((Object)("run() delete: " + e.getMessage()));
                    error = true;
                    jobunitId = jobunit.getData().getJobunitId();
                    resultList.put(jobunitId, Messages.getString((String)"message.accesscontrol.16"));
                }
                catch (Exception e) {
                    m_log.error((Object)("run() delete: " + e.getMessage()), (Throwable)e);
                    error = true;
                    jobunitId = jobunit.getData().getJobunitId();
                    resultList.put(jobunitId, String.valueOf(Messages.getString((String)"message.job.76")) + "[" + e.getMessage() + "]");
                }
            }
            long t_end = System.currentTimeMillis();
            m_log.debug((Object)("delete: " + (t_end - t_start) + " ms"));
            t_start = System.currentTimeMillis();
            m_log.debug((Object)"registerJobunit start");
            for (JobInfo info : JobEditStateUtil.getLockedJobunitList()) {
                try {
                    JobTreeItem jobunit = null;
                    for (JobTreeItem item : releaseList) {
                        if (!item.getData().equals(info)) continue;
                        jobunit = item;
                        break;
                    }
                    if (jobunit != null) continue;
                    for (JobTreeItem item : JobEditStateUtil.getEditedJobunitList()) {
                        if (!item.getData().equals(info)) continue;
                        jobunit = item;
                        break;
                    }
                    if (jobunit == null) {
                        JobEndpointWrapper.releaseEditLock(JobEditStateUtil.getEditSession(info));
                        JobEditStateUtil.removeLockedJobunit(info);
                        continue;
                    }
                    m_log.debug((Object)("register " + jobunit.getData().getJobunitId()));
                    String jobunitId = jobunit.getData().getJobunitId();
                    JobEndpointWrapper.checkEditLock(jobunitId, JobEditStateUtil.getEditSession(jobunit.getData()));
                    JobEndpointWrapper.registerJobunit(jobunit);
                    releaseList.add(jobunit);
                    Long updateTime = JobEndpointWrapper.getUpdateTime(jobunitId);
                    JobEditStateUtil.putJobunitUpdateTime(jobunitId, updateTime);
                    resultList.put(jobunitId, Messages.getString((String)"message.job.79"));
                }
                catch (InvalidRole_Exception e) {
                    m_log.error((Object)("run() register: " + e.getMessage()));
                    error = true;
                    resultList.put(info.getJobunitId(), Messages.getString((String)"message.accesscontrol.16"));
                }
                catch (InvalidObjectPrivilege_Exception e) {
                    m_log.error((Object)("run() register: " + e.getMessage()));
                    error = true;
                    resultList.put(info.getJobunitId(), Messages.getString((String)"message.accesscontrol.16"));
                }
                catch (Exception e) {
                    m_log.error((Object)("run() register: " + e.getMessage()), (Throwable)e);
                    error = true;
                    resultList.put(info.getJobunitId(), String.valueOf(Messages.getString((String)"message.job.80")) + "[" + e.getMessage() + "]");
                }
            }
            t_end = System.currentTimeMillis();
            m_log.debug((Object)("register: " + (t_end - t_start) + " ms"));
            for (JobTreeItem item : releaseList) {
                try {
                    m_log.debug((Object)("release " + item.getData().getJobunitId()));
                    JobEndpointWrapper.releaseEditLock(JobEditStateUtil.getEditSession(item.getData()));
                    JobEditStateUtil.exitEditMode(item);
                    String jobunitId = item.getData().getJobunitId();
                    JobEditStateUtil.clearPropertyFull(jobunitId);
                }
                catch (Exception e) {
                    m_log.warn((Object)("run() : " + e.getMessage()));
                }
            }
            String message = "";
            ArrayList entries = new ArrayList(resultList.keySet());
            Collections.sort(entries);
            for (String key : entries) {
                message = String.valueOf(message) + key + ":" + (String)resultList.get(key) + "\n";
            }
            Object[] args = new String[]{message};
            if (error) {
                m_log.info((Object)("run() : register job failure " + message));
                MessageDialog.openWarning(null, (String)Messages.getString((String)"message.hinemos.1"), (String)Messages.getString((String)"message.job.67", (Object[])args));
            } else if (entries.isEmpty()) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.114"));
            } else {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.job.111", (Object[])args));
            }
            Long end = System.currentTimeMillis();
            m_log.debug((Object)("register() : " + (end - start) + "ms"));
            m_log.debug((Object)("registerJob end   " + new Date()));
            view.getJobTreeComposite().refresh();
            view.getJobTreeComposite().getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)selectedItem), true);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

