/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.jobmanagement.composite.JobKickListComposite;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobKickListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class DisableJobKickAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(DisableJobKickAction.class);
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.DisableScheduleAction";
    private IViewPart m_view;

    public void run(IAction action) {
        JobKickListView view = (JobKickListView)this.m_view.getAdapter(JobKickListView.class);
        JobKickListComposite composite = view.getComposite();
        StructuredSelection selection = (StructuredSelection)composite.getTableViewer().getSelection();
        Object[] objs = selection.toArray();
        if (objs.length == 0) {
            MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.job.24"));
            return;
        }
        String scheduleId = null;
        ArrayList<String> targetIdList = new ArrayList<String>();
        StringBuffer targetList = new StringBuffer();
        StringBuffer successList = new StringBuffer();
        StringBuffer failureList = new StringBuffer();
        int i = 0;
        while (i < objs.length) {
            scheduleId = (String)((ArrayList)objs[i]).get(1);
            targetIdList.add(scheduleId);
            targetList.append(String.valueOf(scheduleId) + "\n");
            ++i;
        }
        Object[] args = new String[]{targetList.toString()};
        if (!MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)Messages.getString((String)"message.job.71", (Object[])args))) {
            return;
        }
        boolean hasRole = true;
        Iterator iterator = targetIdList.iterator();
        while (iterator.hasNext()) {
            String targetId;
            scheduleId = targetId = (String)iterator.next();
            try {
                JobEndpointWrapper.setJobKickStatus(scheduleId, false);
                successList.append(String.valueOf(targetId) + "\n");
            }
            catch (InvalidRole_Exception e) {
                failureList.append(String.valueOf(targetId) + "\n");
                m_log.warn((Object)("run() setScheduleStatus scheduleId=" + scheduleId + ", " + e.getMessage()), (Throwable)e);
                hasRole = false;
            }
            catch (Exception e) {
                failureList.append(String.valueOf(targetId) + "\n");
                m_log.warn((Object)("run() setScheduleStatus scheduleId=" + scheduleId + ", " + e.getMessage()), (Throwable)e);
            }
        }
        if (!hasRole) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        if (successList.length() != 0) {
            args = new String[]{successList.toString()};
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.job.72", (Object[])args));
        }
        if (failureList.length() != 0) {
            args = new String[]{failureList.toString()};
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.job.73", (Object[])args));
        }
        composite.update();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        this.m_view = view;
    }
}

