/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view.action;

import com.clustercontrol.jobmanagement.action.GetJobKick;
import com.clustercontrol.jobmanagement.composite.JobKickListComposite;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobKickListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobKick;
import com.clustercontrol.ws.jobmanagement.JobSchedule;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class DeleteJobKickAction
implements IViewActionDelegate {
    private static Log m_log = LogFactory.getLog(DeleteJobKickAction.class);
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.DeleteJobKickAction";
    private IViewPart m_view;

    public void init(IViewPart view) {
        this.m_view = view;
    }

    public void run(IAction action) {
        if (this.m_view instanceof JobKickListView) {
            JobKickListView view = (JobKickListView)this.m_view.getAdapter(JobKickListView.class);
            JobKickListComposite composite = view.getComposite();
            ArrayList item = composite.getSelectItem();
            if (item instanceof ArrayList) {
                String id = view.getSelectedId();
                JobKick jobKick = new JobKick();
                jobKick = GetJobKick.getJobKick(id);
                if (jobKick instanceof JobSchedule) {
                    String message = String.valueOf(Messages.getString((String)"schedule")) + "[" + id + "]" + Messages.getString((String)"message.job.2");
                    if (MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)message)) {
                        try {
                            JobEndpointWrapper.deleteSchedule(id);
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.job.75"));
                        }
                        catch (InvalidRole_Exception invalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        }
                        catch (Exception e) {
                            m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                        }
                    }
                } else {
                    String message = String.valueOf(Messages.getString((String)"file.check")) + "[" + id + "]" + Messages.getString((String)"message.job.2");
                    if (MessageDialog.openQuestion(null, (String)Messages.getString((String)"confirmed"), (String)message)) {
                        try {
                            JobEndpointWrapper.deleteFileCheck(id);
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.job.75"));
                        }
                        catch (InvalidRole_Exception invalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        }
                        catch (Exception e) {
                            m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
                            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
                        }
                    }
                }
            }
            view.update();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

