/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.view;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.composite.action.JobHistorySelectionChangedListener;
import com.clustercontrol.view.AutoUpdateView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class JobHistoryView
extends AutoUpdateView {
    private static Log m_log = LogFactory.getLog(JobHistoryView.class);
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobHistoryView";
    private HistoryComposite m_history = null;
    private Property m_condition = null;

    @Override
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_history = new HistoryComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_history.setLayoutData(gridData);
        this.m_history.setView(this);
        this.createContextMenu();
        this.m_history.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new JobHistorySelectionChangedListener());
        this.update();
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        this.setInterval(store.getInt("historyUpdateCycle"));
        if (store.getBoolean("historyUpdateFlg")) {
            this.startAutoReload();
        }
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobHistoryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.m_history.getTable());
        this.m_history.getTable().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem startJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.StartJobAction");
        ActionContributionItem stopJobAction = (ActionContributionItem)toolbar.find("com.clustercontrol.jobmanagement.view.action.StopJobAction");
        manager.add(startJobAction.getAction());
        manager.add(stopJobAction.getAction());
    }

    public Property getFilterCondition() {
        return this.m_condition;
    }

    public void setFilterCondition(Property condition) {
        this.m_condition = condition;
    }

    @Override
    public void update() {
        try {
            if (this.m_condition == null) {
                this.m_history.update();
            } else {
                this.m_history.update(this.m_condition);
            }
        }
        catch (Exception e) {
            m_log.warn((Object)("update(), " + e.getMessage()), (Throwable)e);
        }
    }

    public HistoryComposite getComposite() {
        return this.m_history;
    }

    public void setEnabledAction(int num, ISelection selection) {
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StartJobAction", selection);
        super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StopJobAction", selection);
        if (num > 0) {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StartJobAction", true);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StopJobAction", true);
        } else {
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StartJobAction", false);
            super.setEnabledAction("com.clustercontrol.jobmanagement.view.action.StopJobAction", false);
        }
    }
}

