/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.util;

import com.clustercontrol.fault.JobInvalid;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.util.JobTreeItemUtil;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobInvalid_Exception;
import com.clustercontrol.ws.jobmanagement.JobNotificationsInfo;
import com.clustercontrol.ws.jobmanagement.JobObjectInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import com.clustercontrol.ws.jobmanagement.OtherUserGetLock_Exception;
import com.clustercontrol.ws.jobmanagement.UpdateTimeNotLatest_Exception;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

public class JobUtil {
    private static Log m_log = LogFactory.getLog(JobUtil.class);
    private static final String COPY_OF = "Copy_Of_";

    private static JobTreeItem copy(JobTreeItem original) {
        JobTreeItem clone = null;
        if (original != null) {
            clone = JobTreeItemUtil.clone(original, null);
            clone.getData().setCreateTime(null);
        }
        return clone;
    }

    public static JobTreeItem copy(JobTreeItem original, JobTreeItem top, String jobunitId, String ownerRoleId) {
        JobTreeItem clone = JobUtil.copy(original);
        clone.getData().setJobunitId(jobunitId);
        clone.getData().setOwnerRoleId(ownerRoleId);
        clone = JobUtil.changeOwnerRoleId(clone, ownerRoleId);
        HashMap<String, String> jobIdMap = JobUtil.changeJobId(clone, top, clone);
        JobUtil.modifyWaitRule(clone, jobIdMap);
        return clone;
    }

    private static String getBaseJobId(String jobId) {
        Pattern p_number = Pattern.compile("Copy_Of_\\[1-9][0-9]*\\_");
        Matcher m_number = p_number.matcher(jobId);
        if (m_number.find()) {
            return jobId.substring(m_number.end());
        }
        Pattern p_org = Pattern.compile(COPY_OF);
        Matcher m_org = p_org.matcher(jobId);
        if (m_org.find()) {
            return jobId.substring(m_org.end());
        }
        return jobId;
    }

    private static JobTreeItem changeOwnerRoleId(JobTreeItem clone, String ownerRoleId) {
        List childrens = clone.getChildren();
        for (JobTreeItem children : new ArrayList(childrens)) {
            children.getData().setOwnerRoleId(ownerRoleId);
            JobTreeItem jobTreeItem = JobUtil.changeOwnerRoleId(children, ownerRoleId);
        }
        return clone;
    }

    private static HashMap<String, String> changeJobId(JobTreeItem item, JobTreeItem top, JobTreeItem clone) {
        if (item == null || top == null) {
            return null;
        }
        HashMap<String, String> jobIdMap = new HashMap<String, String>();
        JobInfo info = item.getData();
        if (info != null && info instanceof JobInfo) {
            int count = 0;
            String jobId = "";
            jobId = info.getId();
            String baseJobId = JobUtil.getBaseJobId(jobId);
            while (JobUtil.findJobId(jobId, top) || JobUtil.findJobId(jobId, clone)) {
                jobId = count == 0 ? COPY_OF : COPY_OF + count + "_";
                jobId = String.valueOf(jobId) + baseJobId;
                if (++count != 1000) continue;
            }
            jobIdMap.put(info.getId(), jobId);
            info.setId(jobId);
            if (info.getType() == 0) {
                info.setJobunitId(jobId.toString());
            }
            List jobNotifyList = info.getNotifications();
            Iterator itrJob = jobNotifyList.iterator();
            Iterator itrNotify = null;
            List ctNotify = null;
            ArrayList<NotifyRelationInfo> modCtNotify = null;
            NotifyRelationInfo notify = null;
            NotifyRelationInfo modNotify = null;
            String newNotifyGroupId = NotifyGroupIdGenerator.createNotifyGroupIdJob((String)info.getJobunitId(), (String)info.getId(), (Integer)0);
            while (itrJob.hasNext()) {
                JobNotificationsInfo jobNotify = (JobNotificationsInfo)itrJob.next();
                jobNotify.setNotifyGroupId(newNotifyGroupId);
                ctNotify = jobNotify.getNotifyId();
                if (ctNotify == null) continue;
                itrNotify = ctNotify.iterator();
                modCtNotify = new ArrayList<NotifyRelationInfo>();
                while (itrNotify.hasNext()) {
                    notify = (NotifyRelationInfo)itrNotify.next();
                    modNotify = new NotifyRelationInfo();
                    modNotify.setNotifyGroupId(newNotifyGroupId);
                    modNotify.setNotifyId(notify.getNotifyId());
                    modNotify.setNotifyType(notify.getNotifyType());
                    modNotify.setNotifyFlg(notify.getNotifyFlg());
                    modCtNotify.add(modNotify);
                }
                if (modCtNotify.size() == 0) continue;
                jobNotify.getNotifyId().clear();
                jobNotify.getNotifyId().addAll(modCtNotify);
            }
        }
        List childrens = item.getChildren();
        int i = 0;
        while (i < childrens.size()) {
            ((JobTreeItem)childrens.get(i)).getData().setJobunitId(info.getJobunitId());
            jobIdMap.putAll(JobUtil.changeJobId((JobTreeItem)childrens.get(i), top, clone));
            ++i;
        }
        return jobIdMap;
    }

    private static void modifyWaitRule(JobTreeItem item, HashMap<String, String> jobIdMap) {
        JobWaitRuleInfo waitRule;
        if (item == null) {
            return;
        }
        JobInfo info = item.getData();
        if (info != null && (waitRule = info.getWaitRule()) != null && waitRule.getObject() != null) {
            ArrayList<JobObjectInfo> list = new ArrayList<JobObjectInfo>();
            for (JobObjectInfo jobObjectInfo : waitRule.getObject()) {
                String jobId = jobIdMap.get(jobObjectInfo.getJobId());
                if (jobId != null) {
                    jobObjectInfo.setJobId(jobId);
                    list.add(jobObjectInfo);
                    continue;
                }
                if (jobObjectInfo.getTime() == null) continue;
                list.add(jobObjectInfo);
            }
            waitRule.getObject().clear();
            waitRule.getObject().addAll(list);
        }
        List childrens = item.getChildren();
        int i = 0;
        while (i < childrens.size()) {
            JobUtil.modifyWaitRule((JobTreeItem)childrens.get(i), jobIdMap);
            ++i;
        }
    }

    public static boolean findJobId(String jobId, JobTreeItem item) {
        boolean find = false;
        JobInfo info = item.getData();
        if (info != null && info instanceof JobInfo && jobId.compareTo(info.getId()) == 0) {
            find = true;
            return find;
        }
        List childrens = item.getChildren();
        int i = 0;
        while (i < childrens.size()) {
            find = JobUtil.findJobId(jobId, (JobTreeItem)childrens.get(i));
            if (find) break;
            ++i;
        }
        return find;
    }

    public static void findDuplicateJobId(JobTreeItem item, boolean isTop) throws JobInvalid {
        m_log.debug((Object)("findDuplicateJobId() start : isTop = " + isTop));
        if (!isTop && item.getData() instanceof JobInfo) {
            String jobId = item.getData().getId();
            m_log.debug((Object)("findDuplicateJobId() jobId = " + jobId));
            List children = item.getChildren();
            for (JobTreeItem child : children) {
                m_log.debug((Object)("findDuplicateJobId() child = " + child.getData().getId()));
                if (JobUtil.findJobId(jobId, child)) {
                    m_log.debug((Object)("findDuplicateJobId() jobId is in child " + JobTreeItemUtil.getPath(child)));
                    Object[] args = new Object[]{jobId, child.getData().getJobunitId()};
                    throw new JobInvalid(Messages.getString((String)"message.job.65", (Object[])args));
                }
                m_log.debug((Object)("findDuplicateJobId() jobId is not in child " + JobTreeItemUtil.getPath(child)));
            }
        }
        List children = item.getChildren();
        for (JobTreeItem child : children) {
            m_log.debug((Object)("findDuplicateJobId() call child " + child.getData().getId()));
            JobUtil.findDuplicateJobId(child, false);
        }
        m_log.debug((Object)"findDuplicateJobId() success!!");
    }

    public static void findDuplicateJobunitId(JobTreeItem item) throws JobInvalid {
        m_log.debug((Object)("findDuplicateJobunitId() start " + JobTreeItemUtil.getPath(item)));
        JobTreeItem top = (JobTreeItem)item.getChildren().get(0);
        List jobunits = top.getChildren();
        HashSet<String> set = new HashSet<String>();
        for (JobTreeItem jobunit : jobunits) {
            String jobunitId = jobunit.getData().getJobunitId();
            m_log.debug((Object)("findDuplicateJobunitId() jobunitId = " + jobunitId));
            if (set.contains(jobunitId)) {
                m_log.debug((Object)("findDuplicateJobunitId() hit " + jobunitId));
                Object[] args = new Object[]{jobunitId};
                throw new JobInvalid(Messages.getString((String)"message.job.64", (Object[])args));
            }
            m_log.debug((Object)("findDuplicateJobunitId() add " + jobunitId + " to set"));
            set.add(jobunitId);
        }
        m_log.debug((Object)"findDuplicateJobunitId() success!!");
    }

    /*
     * Unable to fully structure code
     */
    public static JobTreeItem getTopJobTreeItem(JobTreeItem item) {
        if (item != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if (item.getParent().getData().getType() == -1) {
                item = item.getParent();
                break;
            }
            item = item.getParent();
lbl7:
            // 2 sources

            ** while (item.getParent() != null)
        }
lbl8:
        // 2 sources

        return item;
    }

    /*
     * Unable to fully structure code
     */
    public static JobTreeItem getTopJobUnitTreeItem(JobTreeItem item) {
        if (item != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            if (item.getParent().getData().getType() == 0) {
                item = item.getParent();
                break;
            }
            if (item.getData().getType() == 0) break;
            item = item.getParent();
lbl8:
            // 2 sources

            ** while (item.getParent() != null)
        }
lbl9:
        // 3 sources

        return item;
    }

    public static boolean checkWaitRule(JobTreeItem item) throws JobInvalid {
        boolean check = true;
        if (item == null) {
            return check;
        }
        if (item.getData() != null && item.getData() instanceof JobInfo) {
            String jobId = item.getData().getId();
            JobWaitRuleInfo waitRule = item.getData().getWaitRule();
            if (waitRule != null && waitRule instanceof JobWaitRuleInfo && waitRule.getObject() != null && waitRule.getObject().size() > 0) {
                for (JobObjectInfo objectInfo : waitRule.getObject()) {
                    if (objectInfo.getType() == 2) continue;
                    boolean find = false;
                    String targetJobId = objectInfo.getJobId();
                    List childrens = item.getParent().getChildren();
                    int i = 0;
                    while (i < childrens.size()) {
                        JobInfo childInfo = ((JobTreeItem)childrens.get(i)).getData();
                        if (childInfo != null && childInfo instanceof JobInfo && !jobId.equals(childInfo.getId()) && targetJobId.compareTo(childInfo.getId()) == 0) {
                            find = true;
                            break;
                        }
                        ++i;
                    }
                    if (find) continue;
                    Object[] args = new String[]{jobId, targetJobId};
                    throw new JobInvalid(Messages.getString((String)"message.job.59", (Object[])args));
                }
            }
        }
        List childrens = item.getChildren();
        int i = 0;
        while (i < childrens.size()) {
            check = JobUtil.checkWaitRule((JobTreeItem)childrens.get(i));
            if (!check) break;
            ++i;
        }
        return check;
    }

    public static Integer getEditLock(String jobunitId, Long updateTime, boolean forceFlag) throws OtherUserGetLock_Exception {
        try {
            return JobEndpointWrapper.getEditLock(jobunitId, updateTime, forceFlag);
        }
        catch (OtherUserGetLock_Exception e) {
            throw e;
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (UpdateTimeNotLatest_Exception e) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)e.getMessage());
        }
        catch (JobInvalid_Exception e) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)e.getMessage());
        }
        catch (Exception e) {
            m_log.warn((Object)("run(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return null;
    }

    public static void setJobunitIdAll(JobTreeItem item, String jobunitId) {
        if (item == null || item.getData() == null) {
            return;
        }
        if (item.getData().getType() == 0) {
            jobunitId = item.getData().getJobunitId();
        }
        m_log.trace((Object)("setJobunitIdAll() : jobId = " + item.getData().getId() + ", old jobunitId = " + item.getData().getJobunitId() + ", new jobunitId = " + jobunitId));
        item.getData().setJobunitId(jobunitId);
        if (item.getData().getType() == 5) {
            item.getData().setReferJobUnitId(jobunitId);
        }
        for (JobTreeItem child : item.getChildren()) {
            JobUtil.setJobunitIdAll(child, jobunitId);
        }
    }
}

