/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.ParameterProperty;
import com.clustercontrol.jobmanagement.bean.JobParamTypeConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.PropertySheet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ParameterDialog
extends CommonDialog {
    private PropertySheet m_viewer = null;
    private Shell m_shell = null;
    private ArrayList m_parameter = null;

    public ParameterDialog(Shell parent) {
        super(parent);
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        parent.getShell().setText(Messages.getString((String)"job.parameter"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Label tableTitle = new Label(parent, 0);
        tableTitle.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        tableTitle.setLayoutData((Object)gridData);
        TableTree table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new PropertySheet(table);
        this.m_viewer.setSize(100, 150);
        this.m_viewer.setInput(new ParameterProperty().getProperty(0));
        this.m_viewer.expandAll();
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
        this.reflectParameter();
        this.m_shell.pack();
        this.m_shell.setSize(new Point(this.m_shell.getSize().x, 400));
        this.m_viewer.expandAll();
    }

    private void reflectParameter() {
        Property property = null;
        if (this.m_parameter != null) {
            Integer type = (Integer)this.m_parameter.get(1);
            if (type == 0) {
                property = new ParameterProperty().getProperty(0);
                ArrayList<Property> propertyList = PropertyUtil.getProperty(property, "type");
                Property paramType = propertyList.get(0);
                Object[][] values = paramType.getSelectValues();
                paramType.setValue(JobParamTypeConstant.STRING_SYSTEM);
                HashMap map = (HashMap)values[1][0];
                ArrayList list = (ArrayList)map.get("property");
                String paramId = (String)this.m_parameter.get(0);
                ((Property)list.get(0)).setValue(paramId);
                String description = (String)this.m_parameter.get(3);
                ((Property)list.get(1)).setValue(description);
            } else if (type == 1) {
                property = new ParameterProperty().getProperty(1);
                ArrayList<Property> propertyList = PropertyUtil.getProperty(property, "type");
                Property paramType = propertyList.get(0);
                Object[][] values = paramType.getSelectValues();
                paramType.setValue(JobParamTypeConstant.STRING_USER);
                HashMap map = (HashMap)values[1][1];
                ArrayList list = (ArrayList)map.get("property");
                String paramId = (String)this.m_parameter.get(0);
                ((Property)list.get(0)).setValue(paramId);
                String value = (String)this.m_parameter.get(2);
                ((Property)list.get(1)).setValue(value);
                String description = (String)this.m_parameter.get(3);
                ((Property)list.get(2)).setValue(description);
            }
            this.m_viewer.setInput(property);
            this.m_viewer.refresh();
        }
    }

    private ValidateResult createParameter() {
        ValidateResult result = null;
        this.m_parameter = new ArrayList();
        Property property = (Property)this.m_viewer.getInput();
        ArrayList values = PropertyUtil.getPropertyValue(property, "type");
        String type = (String)values.get(0);
        if (type.equals(JobParamTypeConstant.STRING_SYSTEM)) {
            String paramId = "";
            values = PropertyUtil.getPropertyValue(property, "systemId");
            if (values.get(0) instanceof String) {
                paramId = (String)values.get(0);
            }
            if (paramId == null || paramId.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.19"));
                return result;
            }
            this.m_parameter.add(paramId);
            this.m_parameter.add(0);
            this.m_parameter.add("(" + Messages.getString((String)"auto") + ")");
            values = PropertyUtil.getPropertyValue(property, "description");
            String description = (String)values.get(0);
            this.m_parameter.add(description);
        } else if (type.equals(JobParamTypeConstant.STRING_USER)) {
            values = PropertyUtil.getPropertyValue(property, "useId");
            String paramId = (String)values.get(0);
            if (paramId == null || paramId.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.19"));
                return result;
            }
            if (!Pattern.matches("[a-zA-Z0-9_-]*", paramId)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.60"));
                return result;
            }
            this.m_parameter.add(paramId);
            this.m_parameter.add(1);
            values = PropertyUtil.getPropertyValue(property, "value");
            String value = (String)values.get(0);
            if (value == null || value.length() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.17"));
                return result;
            }
            this.m_parameter.add(value);
            values = PropertyUtil.getPropertyValue(property, "description");
            String description = (String)values.get(0);
            this.m_parameter.add(description);
        }
        return null;
    }

    protected Point getInitialSize() {
        return new Point(350, 400);
    }

    public void setInputData(ArrayList list) {
        this.m_parameter = list;
    }

    public ArrayList getInputData() {
        return this.m_parameter;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createParameter();
        if (result != null) {
            return result;
        }
        return null;
    }
}

