/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.composite.CalendarIdListComposite;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.composite.action.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetJobKick;
import com.clustercontrol.jobmanagement.dialog.JobTreeDialog;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidSetting_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobFileCheck;
import com.clustercontrol.ws.jobmanagement.JobKickDuplicate_Exception;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileCheckDialog
extends CommonDialog {
    private static Log m_log = LogFactory.getLog(FileCheckDialog.class);
    private JobFileCheck m_jobFileCheck;
    private final int DIALOG_WIDTH = 12;
    private Text txtJobKickId = null;
    private Text txtJobKickName = null;
    private Text txtJobId = null;
    private Text txtJobName = null;
    private CalendarIdListComposite cmpCalendarId = null;
    private Button btnJobSelect = null;
    private Text txtScope = null;
    private Button btnScopeSelect = null;
    private String m_facilityId = null;
    private Text txtDirectory = null;
    private Text txtFileName = null;
    private Button btnTypeCreate = null;
    private Button btnTypeDelete = null;
    private Button btnTypeModify = null;
    private Button btnTypeTimeStamp = null;
    private Button btnTypeFileSize = null;
    private Button btnValid = null;
    private Button btnInvalid = null;
    private RoleIdListComposite cmpOwnerRoleId = null;
    private Shell m_shell = null;
    private int mode = 0;
    private String m_jobunitId = null;
    private String m_JobKickId = null;

    public FileCheckDialog(Shell parent) {
        super(parent);
    }

    public FileCheckDialog(Shell parent, String id, int mode) {
        super(parent);
        this.m_JobKickId = id;
        this.mode = mode;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        parent.getShell().setText(Messages.getString((String)"dialog.job.add.modify.filecheck"));
        GridLayout baseLayout = new GridLayout(1, true);
        baseLayout.marginWidth = 10;
        baseLayout.marginHeight = 10;
        baseLayout.numColumns = 12;
        parent.setLayout((Layout)baseLayout);
        Composite composite = null;
        GridData gridData = null;
        composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 12;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 12;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gridData);
        Label labelScheduleId = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelScheduleId.setText(String.valueOf(Messages.getString((String)"jobkick.id")) + " : ");
        labelScheduleId.setLayoutData((Object)gridData);
        this.txtJobKickId = new Text(composite, 2048);
        this.txtJobKickId.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtJobKickId.setLayoutData((Object)gridData);
        this.txtJobKickId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileCheckDialog.this.update();
            }
        });
        Label labelScheduleName = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelScheduleName.setText(String.valueOf(Messages.getString((String)"jobkick.name")) + " : ");
        labelScheduleName.setLayoutData((Object)gridData);
        this.txtJobKickName = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtJobKickName.setLayoutData((Object)gridData);
        this.txtJobKickName.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        this.txtJobKickName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileCheckDialog.this.update();
            }
        });
        Label labelRoleId = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelRoleId.setLayoutData((Object)gridData);
        labelRoleId.setText(String.valueOf(Messages.getString((String)"owner.role.id")) + " : ");
        if (this.mode == 0 || this.mode == 3) {
            this.cmpOwnerRoleId = new RoleIdListComposite(composite, 0, true, RoleIdListComposite.Mode.OWNER_ROLE);
            this.cmpOwnerRoleId.getComboRoleId().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileCheckDialog.this.cmpCalendarId.setOwnerRoleId(FileCheckDialog.this.cmpOwnerRoleId.getText());
                    FileCheckDialog.this.txtJobId.setText("");
                    FileCheckDialog.this.txtJobName.setText("");
                    FileCheckDialog.this.setJobunitId(null);
                    FileCheckDialog.this.m_facilityId = "";
                    FileCheckDialog.this.txtScope.setText(FileCheckDialog.this.m_facilityId);
                }
            });
        } else {
            this.cmpOwnerRoleId = new RoleIdListComposite(composite, 0, false, RoleIdListComposite.Mode.OWNER_ROLE);
        }
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmpOwnerRoleId.setLayoutData(gridData);
        Label labelJobId = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelJobId.setText(String.valueOf(Messages.getString((String)"job.id")) + " : ");
        labelJobId.setLayoutData((Object)gridData);
        this.txtJobId = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtJobId.setLayoutData((Object)gridData);
        this.txtJobId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileCheckDialog.this.update();
            }
        });
        this.btnJobSelect = new Button(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnJobSelect.setText(Messages.getString((String)"refer"));
        this.btnJobSelect.setLayoutData((Object)gridData);
        this.btnJobSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobTreeDialog dialog = new JobTreeDialog(FileCheckDialog.this.m_shell, FileCheckDialog.this.cmpOwnerRoleId.getText(), true);
                if (dialog.open() == 0) {
                    JobTreeItem selectItem = dialog.getSelectItem();
                    if (selectItem.getData().getType() != -1) {
                        FileCheckDialog.this.txtJobId.setText(selectItem.getData().getId());
                        FileCheckDialog.this.txtJobName.setText(selectItem.getData().getName());
                        FileCheckDialog.this.setJobunitId(selectItem.getData().getJobunitId());
                    } else {
                        FileCheckDialog.this.txtJobId.setText("");
                        FileCheckDialog.this.txtJobName.setText("");
                        FileCheckDialog.this.setJobunitId(null);
                    }
                }
            }
        });
        Label labelJobName = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelJobName.setText(String.valueOf(Messages.getString((String)"job.name")) + " : ");
        labelJobName.setLayoutData((Object)gridData);
        this.txtJobName = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtJobName.setLayoutData((Object)gridData);
        Label labelCalendarId = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelCalendarId.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        labelCalendarId.setLayoutData((Object)gridData);
        this.cmpCalendarId = new CalendarIdListComposite(composite, 0, false);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmpCalendarId.setLayoutData(gridData);
        this.createFileCheck(parent);
        Group groupValidOrInvalid = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 6;
        groupValidOrInvalid.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 12;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupValidOrInvalid.setLayoutData((Object)gridData);
        groupValidOrInvalid.setText(String.valueOf(Messages.getString((String)"valid")) + "/" + Messages.getString((String)"invalid"));
        this.btnValid = new Button((Composite)groupValidOrInvalid, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnValid.setText(ValidConstant.STRING_VALID);
        this.btnValid.setLayoutData((Object)gridData);
        this.btnValid.setSelection(true);
        this.btnInvalid = new Button((Composite)groupValidOrInvalid, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnInvalid.setText(ValidConstant.STRING_INVALID);
        this.btnInvalid.setLayoutData((Object)gridData);
        this.adjustDialog();
        this.reflectJobFileCheck();
        this.update();
    }

    private void createFileCheck(Composite parent) {
        Group groupFileCheck = new Group(parent, 0);
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 12;
        groupFileCheck.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 12;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupFileCheck.setLayoutData((Object)gridData);
        groupFileCheck.setText(Messages.getString((String)"file.check.setting"));
        label = new Label((Composite)groupFileCheck, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"scope")) + " : ");
        this.txtScope = new Text((Composite)groupFileCheck, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtScope.setLayoutData((Object)gridData);
        this.txtScope.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileCheckDialog.this.update();
            }
        });
        this.btnScopeSelect = new Button((Composite)groupFileCheck, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.btnScopeSelect.setLayoutData((Object)gridData);
        this.btnScopeSelect.setText(Messages.getString((String)"refer"));
        this.btnScopeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(FileCheckDialog.this.m_shell, FileCheckDialog.this.cmpOwnerRoleId.getText());
                if (dialog.open() == 0) {
                    FacilityTreeItem selectItem = dialog.getSelectItem();
                    FacilityInfo info = selectItem.getData();
                    FileCheckDialog.this.m_facilityId = info.getFacilityId();
                    FileCheckDialog.this.txtScope.setText(FileCheckDialog.this.m_facilityId);
                    FileCheckDialog.this.update();
                }
            }
        });
        label = new Label((Composite)groupFileCheck, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"file.check.directory")) + " : ");
        this.txtDirectory = new Text((Composite)groupFileCheck, 2048);
        this.txtDirectory.addVerifyListener((VerifyListener)new StringVerifyListener(1024));
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtDirectory.setLayoutData((Object)gridData);
        this.txtDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileCheckDialog.this.update();
            }
        });
        label = new Label((Composite)groupFileCheck, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"file.name")) + "(" + Messages.getString((String)"regex") + ") : ");
        this.txtFileName = new Text((Composite)groupFileCheck, 2048);
        this.txtFileName.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.txtFileName.setLayoutData((Object)gridData);
        this.txtFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FileCheckDialog.this.update();
            }
        });
        Group groupCheck = new Group((Composite)groupFileCheck, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 4;
        groupCheck.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 12;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheck.setText(String.valueOf(Messages.getString((String)"file.check.type")) + " : ");
        groupCheck.setLayoutData((Object)gridData);
        this.btnTypeCreate = new Button((Composite)groupCheck, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.btnTypeCreate.setText(Messages.getString((String)"create"));
        this.btnTypeCreate.setLayoutData((Object)gridData);
        this.btnTypeCreate.setSelection(true);
        this.btnTypeCreate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                check.getSelection();
                FileCheckDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnTypeDelete = new Button((Composite)groupCheck, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.btnTypeDelete.setText(Messages.getString((String)"delete2"));
        this.btnTypeDelete.setLayoutData((Object)gridData);
        this.btnTypeDelete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                check.getSelection();
                FileCheckDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnTypeModify = new Button((Composite)groupCheck, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        this.btnTypeModify.setText(Messages.getString((String)"modify2"));
        this.btnTypeModify.setLayoutData((Object)gridData);
        this.btnTypeModify.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                check.getSelection();
                FileCheckDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite composite = new Composite((Composite)groupCheck, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 12;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 12;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gridData);
        Label spaceLabel = new Label(composite, 16384);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        spaceLabel.setLayoutData((Object)gridData);
        this.btnTypeTimeStamp = new Button(composite, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        this.btnTypeTimeStamp.setText(Messages.getString((String)"file.check.type.modify.timestamp"));
        this.btnTypeTimeStamp.setLayoutData((Object)gridData);
        this.btnTypeTimeStamp.setSelection(true);
        this.btnTypeTimeStamp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                check.getSelection();
                FileCheckDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnTypeFileSize = new Button(composite, 16);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 5;
        this.btnTypeFileSize.setText(Messages.getString((String)"file.check.type.modify.file.size"));
        this.btnTypeFileSize.setLayoutData((Object)gridData);
        this.btnTypeFileSize.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                check.getSelection();
                FileCheckDialog.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.adjustDialog();
    }

    private void adjustDialog() {
        this.m_shell.pack();
        this.m_shell.setSize(new Point(500, this.m_shell.getSize().y));
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
    }

    public void update() {
        if ("".equals(this.txtJobKickId.getText())) {
            this.txtJobKickId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtJobKickId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtJobKickName.getText())) {
            this.txtJobKickName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtJobKickName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtJobId.getText())) {
            this.txtJobId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtJobId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtScope.getText())) {
            this.txtScope.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtScope.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtDirectory.getText())) {
            this.txtDirectory.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtDirectory.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.txtFileName.getText())) {
            this.txtFileName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.txtFileName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.btnTypeCreate.getSelection() || this.btnTypeDelete.getSelection()) {
            this.btnTypeTimeStamp.setEnabled(false);
            this.btnTypeFileSize.setEnabled(false);
        } else {
            this.btnTypeTimeStamp.setEnabled(true);
            this.btnTypeFileSize.setEnabled(true);
        }
    }

    private void reflectJobFileCheck() {
        JobFileCheck jobFileCheck = null;
        jobFileCheck = this.mode == 1 || this.mode == 3 ? GetJobKick.getJobFileCheck(this.m_JobKickId) : new JobFileCheck();
        this.m_jobFileCheck = jobFileCheck;
        if (jobFileCheck != null && jobFileCheck.getOwnerRoleId() != null) {
            this.cmpOwnerRoleId.setText(jobFileCheck.getOwnerRoleId());
        }
        this.cmpCalendarId.setOwnerRoleId(this.cmpOwnerRoleId.getText());
        if (jobFileCheck.getId() != null) {
            this.txtJobKickId.setText(jobFileCheck.getId());
            this.m_JobKickId = jobFileCheck.getId();
            if (this.mode == 1) {
                this.txtJobKickId.setEnabled(false);
            }
        }
        if (jobFileCheck.getName() != null) {
            this.txtJobKickName.setText(jobFileCheck.getName());
        }
        if (jobFileCheck.getJobId() != null) {
            this.txtJobId.setText(jobFileCheck.getJobId());
        }
        if (jobFileCheck.getJobName() != null) {
            this.txtJobName.setText(jobFileCheck.getJobName());
        }
        if (jobFileCheck.getJobunitId() != null) {
            String jobunitId = jobFileCheck.getJobunitId();
            this.setJobunitId(jobunitId);
        }
        if (jobFileCheck.getCalendarId() != null) {
            if (!this.cmpCalendarId.getEnabled()) {
                this.cmpCalendarId.addText(jobFileCheck.getCalendarId());
            }
            this.cmpCalendarId.setText(jobFileCheck.getCalendarId());
        }
        if (jobFileCheck.getFacilityId() != null) {
            this.txtScope.setText(jobFileCheck.getFacilityId());
        }
        if (jobFileCheck.getDirectory() != null) {
            this.txtDirectory.setText(jobFileCheck.getDirectory());
        }
        if (jobFileCheck.getFileName() != null) {
            this.txtFileName.setText(jobFileCheck.getFileName());
        }
        if (jobFileCheck.getEventType() != null) {
            switch (jobFileCheck.getEventType()) {
                case 0: {
                    this.btnTypeCreate.setSelection(true);
                    this.btnTypeDelete.setSelection(false);
                    this.btnTypeModify.setSelection(false);
                    break;
                }
                case 1: {
                    this.btnTypeCreate.setSelection(false);
                    this.btnTypeDelete.setSelection(true);
                    this.btnTypeModify.setSelection(false);
                    break;
                }
                case 2: {
                    this.btnTypeCreate.setSelection(false);
                    this.btnTypeDelete.setSelection(false);
                    this.btnTypeModify.setSelection(true);
                    if (jobFileCheck.getModifyType() == null) break;
                    if (jobFileCheck.getModifyType() == 0) {
                        this.btnTypeTimeStamp.setSelection(true);
                        this.btnTypeFileSize.setSelection(false);
                        break;
                    }
                    this.btnTypeTimeStamp.setSelection(false);
                    this.btnTypeFileSize.setSelection(true);
                }
            }
        }
        if (jobFileCheck.getValid() != null) {
            Integer effective = jobFileCheck.getValid();
            if (effective == 1) {
                this.btnValid.setSelection(true);
                this.btnInvalid.setSelection(false);
            } else {
                this.btnValid.setSelection(false);
                this.btnInvalid.setSelection(true);
            }
        }
        this.update();
    }

    private ValidateResult createJobFileCheck() {
        ValidateResult result = null;
        this.m_jobFileCheck = new JobFileCheck();
        if (this.getJobunitId() != null) {
            this.m_jobFileCheck.setJobunitId(this.getJobunitId());
        }
        if (this.cmpOwnerRoleId.getText().length() > 0) {
            this.m_jobFileCheck.setOwnerRoleId(this.cmpOwnerRoleId.getText());
        }
        if (this.txtJobKickId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.88"));
            return result;
        }
        this.m_jobFileCheck.setId(this.txtJobKickId.getText());
        if (this.txtJobKickName.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.89"));
            return result;
        }
        this.m_jobFileCheck.setName(this.txtJobKickName.getText());
        if (this.txtJobId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.22"));
            return result;
        }
        this.m_jobFileCheck.setJobId(this.txtJobId.getText());
        if (this.txtJobName.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.23"));
            return result;
        }
        this.m_jobFileCheck.setJobName(this.txtJobName.getText());
        if (this.cmpCalendarId.getText().length() > 0) {
            this.m_jobFileCheck.setCalendarId(this.cmpCalendarId.getText());
        } else {
            this.m_jobFileCheck.setCalendarId("");
        }
        if (this.txtScope.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.hinemos.3"));
            return result;
        }
        this.m_jobFileCheck.setFacilityId(this.txtScope.getText());
        if (this.txtDirectory.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.92"));
            return result;
        }
        this.m_jobFileCheck.setDirectory(this.txtDirectory.getText());
        if (this.txtFileName.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.90"));
            return result;
        }
        this.m_jobFileCheck.setFileName(this.txtFileName.getText());
        if (this.btnTypeCreate.getSelection()) {
            this.m_jobFileCheck.setEventType(Integer.valueOf(0));
        } else if (this.btnTypeDelete.getSelection()) {
            this.m_jobFileCheck.setEventType(Integer.valueOf(1));
        } else {
            this.m_jobFileCheck.setEventType(Integer.valueOf(2));
            if (this.btnTypeTimeStamp.getSelection()) {
                this.m_jobFileCheck.setModifyType(Integer.valueOf(0));
            } else {
                this.m_jobFileCheck.setModifyType(Integer.valueOf(1));
            }
        }
        if (this.btnValid.getSelection()) {
            this.m_jobFileCheck.setValid(Integer.valueOf(1));
        } else {
            this.m_jobFileCheck.setValid(Integer.valueOf(0));
        }
        return result;
    }

    @Override
    protected String getOkButtonText() {
        return Messages.getString((String)"register");
    }

    @Override
    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    @Override
    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createJobFileCheck();
        if (result != null) {
            return result;
        }
        return null;
    }

    public String getJobunitId() {
        return this.m_jobunitId;
    }

    public void setJobunitId(String jobunitId) {
        this.m_jobunitId = jobunitId;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        try {
            if (this.mode == 1) {
                JobEndpointWrapper.modifyFileCheck(this.m_jobFileCheck);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.job.77"));
            } else {
                JobEndpointWrapper.addFileCheck(this.m_jobFileCheck);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.job.79"));
            }
            result = true;
        }
        catch (InvalidRole_Exception invalidRole_Exception) {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
        }
        catch (JobKickDuplicate_Exception e) {
            Object[] args = new String[]{this.m_jobFileCheck.getId()};
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.job.83", (Object[])args)) + " " + e.getMessage()));
        }
        catch (InvalidUserPass_Exception e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.job.74")) + ", " + e.getMessage()));
        }
        catch (InvalidSetting_Exception e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.job.74")) + ", " + e.getMessage()));
        }
        catch (Exception e) {
            m_log.warn((Object)("action(), " + e.getMessage()), (Throwable)e);
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
        }
        return result;
    }
}

