/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite.action;

import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.composite.JobPlanComposite;
import com.clustercontrol.jobmanagement.dialog.JobDialog;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class SessionJobDoubleClickListener
implements IDoubleClickListener {
    private static Log m_log = LogFactory.getLog(SessionJobDoubleClickListener.class);
    private Composite m_composite;

    public SessionJobDoubleClickListener(Composite composite) {
        this.m_composite = composite;
    }

    public void doubleClick(DoubleClickEvent event) {
        JobTreeItem item;
        String sessionId = null;
        String jobunitId = null;
        String jobId = null;
        if (this.m_composite instanceof HistoryComposite) {
            if (((StructuredSelection)event.getSelection()).getFirstElement() != null) {
                ArrayList info = (ArrayList)((StructuredSelection)event.getSelection()).getFirstElement();
                sessionId = (String)info.get(3);
                jobunitId = (String)info.get(6);
                jobId = (String)info.get(4);
            }
        } else if (this.m_composite instanceof DetailComposite) {
            if (((StructuredSelection)event.getSelection()).getFirstElement() != null) {
                item = (JobTreeItem)((StructuredSelection)event.getSelection()).getFirstElement();
                JobInfo info = item.getData();
                sessionId = ((DetailComposite)this.m_composite).getSessionId();
                jobunitId = ((DetailComposite)this.m_composite).getJobunitId();
                jobId = info.getId();
            }
        } else if (this.m_composite instanceof JobPlanComposite && ((StructuredSelection)event.getSelection()).getFirstElement() != null) {
            ArrayList plan = (ArrayList)((StructuredSelection)event.getSelection()).getFirstElement();
            jobId = (String)plan.get(4);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart viewPart = page.findView("com.clustercontrol.jobmanagement.view.JobListView");
            if (viewPart != null) {
                JobListView view = (JobListView)viewPart.getAdapter(JobListView.class);
                view.update(jobId);
            }
        }
        if (sessionId != null && sessionId.length() > 0 && jobunitId != null && jobunitId.length() > 0 && jobId != null && jobId.length() > 0) {
            item = null;
            try {
                item = JobEndpointWrapper.getSessionJobInfo(sessionId, jobunitId, jobId);
            }
            catch (InvalidRole_Exception invalidRole_Exception) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                m_log.warn((Object)("doubleClick() getSessionJobInfo, " + e.getMessage()), (Throwable)e);
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(String.valueOf(Messages.getString((String)"message.hinemos.failure.unexpected")) + ", " + e.getMessage()));
            }
            if (item != null) {
                JobDialog dialog = new JobDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true);
                dialog.setJobTreeItem(item);
                dialog.open();
            }
        }
    }
}

