/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite.action;

import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.composite.JobKickListComposite;
import com.clustercontrol.jobmanagement.dialog.FileCheckDialog;
import com.clustercontrol.jobmanagement.dialog.ScheduleDialog;
import com.clustercontrol.jobmanagement.view.JobKickListView;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class JobKickDoubleClickListener
implements IDoubleClickListener {
    private static Log m_log = LogFactory.getLog(JobKickDoubleClickListener.class);
    private JobKickListComposite m_composite;

    public JobKickDoubleClickListener(JobKickListComposite jobKickListComposite) {
        this.m_composite = jobKickListComposite;
    }

    public void doubleClick(DoubleClickEvent event) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView("com.clustercontrol.jobmanagement.view.JobKickListView");
        if (viewPart instanceof JobKickListView) {
            JobKickListView view = (JobKickListView)viewPart.getAdapter(JobKickListView.class);
            JobKickListComposite composite = view.getComposite();
            ArrayList item = composite.getSelectItem();
            if (item instanceof ArrayList) {
                String id = view.getSelectedId();
                String type = (String)item.get(0);
                int TypeNum = JobTriggerTypeConstant.stringToType((String)type);
                if (TypeNum == 1) {
                    ScheduleDialog dialog = new ScheduleDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), id, 1);
                    dialog.open();
                } else if (TypeNum == 4) {
                    FileCheckDialog dialog = new FileCheckDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), id, 1);
                    dialog.open();
                }
            }
            view.update();
        }
    }
}

