/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite.action;

import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.view.ForwardFileView;
import com.clustercontrol.jobmanagement.view.JobDetailView;
import com.clustercontrol.jobmanagement.view.JobNodeDetailView;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.ws.jobmanagement.JobInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class JobDetailSelectionChangedListener
implements ISelectionChangedListener {
    private DetailComposite m_composite;

    public JobDetailSelectionChangedListener(DetailComposite composite) {
        this.m_composite = composite;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        CommonViewPart view;
        String sessionId = null;
        String jobunitId = null;
        String jobId = null;
        if (((StructuredSelection)event.getSelection()).getFirstElement() != null) {
            JobTreeItem item = (JobTreeItem)((StructuredSelection)event.getSelection()).getFirstElement();
            JobInfo info = item.getData();
            jobunitId = info.getJobunitId();
            jobId = info.getId();
            this.m_composite.setJobunitId(jobunitId);
            this.m_composite.setJobId(jobId);
        }
        sessionId = this.m_composite.getSessionId();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView("com.clustercontrol.jobmanagement.view.JobNodeDetailView");
        if (viewPart != null) {
            view = (JobNodeDetailView)((Object)viewPart.getAdapter(JobNodeDetailView.class));
            ((JobNodeDetailView)view).update(sessionId, jobunitId, jobId);
        }
        if ((viewPart = page.findView("com.clustercontrol.jobmanagement.view.ForwardFileView")) != null) {
            view = (ForwardFileView)((Object)viewPart.getAdapter(ForwardFileView.class));
            ((ForwardFileView)view).update(sessionId, jobunitId, jobId);
        }
        if ((viewPart = page.findView("com.clustercontrol.jobmanagement.view.JobDetailView")) != null && event.getSelection() != null) {
            view = (JobDetailView)((Object)viewPart.getAdapter(JobDetailView.class));
            ((JobDetailView)view).setEnabledAction(((StructuredSelection)event.getSelection()).size(), event.getSelection());
        }
    }
}

