/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.dialog.JobTreeDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReferComposite
extends Composite {
    private static final int WIDTH_JOBUNIT_ID = 3;
    private static final int WIDTH_JOB_ID = 3;
    private static final int WIDTH_REF_BTN = 2;
    private Text m_textJobunitId = null;
    private Text m_textJobId = null;
    private Button m_buttonRefer = null;
    private Shell m_shell = null;
    private String m_referJobUnitId = null;
    private String m_referJobId = null;
    private JobTreeItem m_jobTreeItem = null;
    private String m_ownerRoleId = null;

    public ReferComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.m_shell = this.getShell();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        GridLayout gridlayout = new GridLayout(8, true);
        gridlayout.marginWidth = 10;
        gridlayout.marginHeight = 10;
        gridlayout.numColumns = 8;
        Label label = null;
        GridData gridData = null;
        composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)gridlayout);
        label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"jobunit.id"));
        label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setText(Messages.getString((String)"job.id"));
        composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)gridlayout);
        this.m_textJobunitId = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textJobunitId.setLayoutData((Object)gridData);
        this.m_textJobunitId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ReferComposite.this.update();
            }
        });
        this.m_textJobId = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textJobId.setLayoutData((Object)gridData);
        this.m_buttonRefer = new Button(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonRefer.setLayoutData((Object)gridData);
        this.m_buttonRefer.setText(Messages.getString((String)"refer"));
        this.m_buttonRefer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobTreeDialog dialog = new JobTreeDialog(ReferComposite.this.m_shell, ReferComposite.this.m_ownerRoleId, ReferComposite.this.m_jobTreeItem, 5);
                if (dialog.open() == 0) {
                    JobTreeItem selectItem = dialog.getSelectItem();
                    if (selectItem.getData().getType() != -1) {
                        ReferComposite.this.m_textJobId.setText(selectItem.getData().getId());
                        ReferComposite.this.m_textJobunitId.setText(selectItem.getData().getJobunitId());
                    } else {
                        ReferComposite.this.m_textJobId.setText("");
                        ReferComposite.this.m_textJobunitId.setText("");
                    }
                }
            }
        });
        this.reflectReferInfo();
        this.update();
    }

    public void update() {
        if ("".equals(this.m_textJobunitId.getText())) {
            this.m_textJobunitId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textJobunitId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("".equals(this.m_textJobId.getText())) {
            this.m_textJobId.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textJobId.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public String getReferJobUnitId() {
        return this.m_referJobUnitId;
    }

    public void setReferJobUnitId(String referJobUnitId) {
        this.m_referJobUnitId = referJobUnitId;
    }

    public String getReferJobId() {
        return this.m_referJobId;
    }

    public void setReferJobId(String referJobId) {
        this.m_referJobId = referJobId;
    }

    public void setJobTreeItem(JobTreeItem jobTreeItem) {
        this.m_jobTreeItem = jobTreeItem;
    }

    public void reflectReferInfo() {
        if (this.m_referJobUnitId != null && this.m_referJobUnitId.length() > 0) {
            this.m_textJobunitId.setText(this.m_referJobUnitId);
        }
        if (this.m_referJobId != null && this.m_referJobId.length() > 0) {
            this.m_textJobId.setText(this.m_referJobId);
        }
        this.update();
    }

    public ValidateResult createReferInfo() {
        ValidateResult result = null;
        if (this.m_textJobId.getText() == null || "".equals(this.m_textJobId.getText().trim())) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.100"));
            return result;
        }
        this.setReferJobId(this.m_textJobId.getText());
        if (this.m_textJobunitId.getText() == null || "".equals(this.m_textJobunitId.getText().trim())) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.99"));
            return result;
        }
        this.setReferJobUnitId(this.m_textJobunitId.getText());
        return null;
    }

    public void setOwnerRoleId(String ownerRoleId) {
        this.m_ownerRoleId = ownerRoleId;
        this.m_textJobunitId.setText("");
        this.m_textJobId.setText("");
        this.m_referJobUnitId = null;
        this.m_referJobId = null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_textJobunitId.setEnabled(enabled);
        this.m_textJobId.setEnabled(enabled);
        this.m_buttonRefer.setEnabled(enabled);
    }
}

