/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.jobmanagement.action.GetJobTableDefine;
import com.clustercontrol.jobmanagement.composite.action.JobDoubleClickListener;
import com.clustercontrol.jobmanagement.util.JobPropertyUtil;
import com.clustercontrol.jobmanagement.util.JobTreeItemUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.jobmanagement.JobCommandInfo;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class JobListComposite
extends Composite {
    private CommonTableViewer m_viewer = null;
    private Label m_path = null;
    private JobTreeItem m_jobTreeItem = null;
    private JobTreeItem m_selectJobTreeItem = null;

    public JobListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_path = new Label((Composite)this, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_path.setLayoutData((Object)gridData);
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_viewer = new CommonTableViewer(table);
        this.m_viewer.createTableColumn(GetJobTableDefine.get(), 0, 1);
        this.m_viewer.addDoubleClickListener(new JobDoubleClickListener(this));
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public void update(JobTreeItem item) {
        if (item instanceof JobTreeItem) {
            this.m_path.setText(String.valueOf(Messages.getString((String)"job")) + " : " + JobTreeItemUtil.getPath(item));
        } else {
            this.m_path.setText(String.valueOf(Messages.getString((String)"job")) + " : ");
        }
        this.m_jobTreeItem = item;
        this.m_selectJobTreeItem = null;
        ArrayList jobInfo = null;
        jobInfo = this.getJobList(item);
        this.m_viewer.setInput(jobInfo);
    }

    public JobTreeItem getSelectJobTreeItem() {
        return this.m_selectJobTreeItem;
    }

    public void setSelectJobTreeItem(JobTreeItem jobTreeItem) {
        this.m_selectJobTreeItem = jobTreeItem;
    }

    public JobTreeItem getJobTreeItem() {
        return this.m_jobTreeItem;
    }

    public void setJobTreeItem(JobTreeItem jobTreeItem) {
        this.m_jobTreeItem = jobTreeItem;
    }

    private ArrayList getJobList(JobTreeItem item) {
        ArrayList jobList = new ArrayList();
        if (item != null) {
            List items = item.getChildren();
            int i = 0;
            while (i < items.size()) {
                ArrayList<Object> line = new ArrayList<Object>();
                JobPropertyUtil.setJobFull(((JobTreeItem)items.get(i)).getData());
                line.add(((JobTreeItem)items.get(i)).getData().getId());
                line.add(((JobTreeItem)items.get(i)).getData().getName());
                line.add(new Integer(((JobTreeItem)items.get(i)).getData().getType()));
                JobCommandInfo exec = ((JobTreeItem)items.get(i)).getData().getCommand();
                if (exec instanceof JobCommandInfo) {
                    line.add(exec.getFacilityID());
                    line.add(exec.getScope());
                } else {
                    line.add(null);
                    line.add(null);
                }
                JobWaitRuleInfo waitRule = ((JobTreeItem)items.get(i)).getData().getWaitRule();
                if (waitRule instanceof JobWaitRuleInfo) {
                    if (waitRule.getObject() != null && waitRule.getObject().size() > 0) {
                        line.add(new Integer(1));
                    } else {
                        line.add(new Integer(0));
                    }
                } else {
                    line.add(new Integer(0));
                }
                line.add(((JobTreeItem)items.get(i)).getData().getOwnerRoleId());
                line.add(((JobTreeItem)items.get(i)).getData().getCreateUser());
                Long createTime = ((JobTreeItem)items.get(i)).getData().getCreateTime();
                if (createTime == null) {
                    line.add(null);
                } else {
                    line.add(new Date(((JobTreeItem)items.get(i)).getData().getCreateTime()));
                }
                line.add(((JobTreeItem)items.get(i)).getData().getUpdateUser());
                Long updateTime = ((JobTreeItem)items.get(i)).getData().getUpdateTime();
                if (updateTime == null) {
                    line.add(null);
                } else {
                    line.add(new Date(((JobTreeItem)items.get(i)).getData().getUpdateTime()));
                }
                jobList.add(line);
                ++i;
            }
        } else {
            return null;
        }
        return jobList;
    }

    public JobTreeItem getSelectItem() {
        return this.m_selectJobTreeItem;
    }
}

