/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.action.NumberVerifyListener;
import com.clustercontrol.composite.action.PositiveNumberVerifyListener;
import com.clustercontrol.composite.action.TimeVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.TimeTo48hConverter;
import com.clustercontrol.ws.jobmanagement.JobWaitRuleInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EndDelayComposite
extends Composite {
    private Button m_sessionCondition = null;
    private Text m_sessionValue = null;
    private Button m_jobCondition = null;
    private Text m_jobValue = null;
    private Button m_timeCondition = null;
    private Text m_timeValue = null;
    private Button m_andCondition = null;
    private Button m_orCondition = null;
    private Button m_notifyCondition = null;
    private Combo m_notifyPriority = null;
    private Button m_operationCondition = null;
    private Group m_operationConditionGroup = null;
    private Combo m_operationType = null;
    private Combo m_operationStatus = null;
    private Text m_operationValue = null;
    private Button m_endDelayCondition = null;
    private Group m_endDelayConditionGroup = null;
    private JobWaitRuleInfo m_waitRule = null;

    public EndDelayComposite(Composite parent, int style, boolean isFileJob) {
        super(parent, style);
        this.initialize(isFileJob);
    }

    private void initialize(boolean isFileJob) {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        Label label = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        composite.setLayout((Layout)rowLayout);
        this.m_endDelayCondition = new Button(composite, 32);
        this.m_endDelayCondition.setText(Messages.getString((String)"end.delay"));
        this.m_endDelayCondition.setLayoutData((Object)new RowData(200, 22));
        this.m_endDelayCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                EndDelayComposite.this.setEndDelayEnabled(check.getSelection());
                EndDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_endDelayConditionGroup = new Group(composite, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_endDelayConditionGroup.setLayout((Layout)rowLayout);
        Group group = new Group((Composite)this.m_endDelayConditionGroup, 0);
        group.setText(Messages.getString((String)"object.list"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_sessionCondition = new Button(composite, 32);
        this.m_sessionCondition.setText(String.valueOf(Messages.getString((String)"time.after.session.start")) + " : ");
        this.m_sessionCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_sessionCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    EndDelayComposite.this.m_sessionValue.setEnabled(true);
                } else {
                    EndDelayComposite.this.m_sessionValue.setEnabled(false);
                }
                EndDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_sessionValue = new Text(composite, 2048);
        this.m_sessionValue.setLayoutData((Object)new RowData(100, 15));
        this.m_sessionValue.addVerifyListener((VerifyListener)new PositiveNumberVerifyListener(0, Short.MAX_VALUE));
        this.m_sessionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndDelayComposite.this.update();
            }
        });
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_jobCondition = new Button(composite, 32);
        this.m_jobCondition.setText(String.valueOf(Messages.getString((String)"time.after.job.start")) + " : ");
        this.m_jobCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_jobCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    EndDelayComposite.this.m_jobValue.setEnabled(true);
                } else {
                    EndDelayComposite.this.m_jobValue.setEnabled(false);
                }
                EndDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_jobValue = new Text(composite, 2048);
        this.m_jobValue.setLayoutData((Object)new RowData(100, 15));
        this.m_jobValue.addVerifyListener((VerifyListener)new PositiveNumberVerifyListener(0, Short.MAX_VALUE));
        this.m_jobValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndDelayComposite.this.update();
            }
        });
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_timeCondition = new Button(composite, 32);
        this.m_timeCondition.setText(String.valueOf(Messages.getString((String)"wait.rule.time.example")) + " : ");
        this.m_timeCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_timeCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    EndDelayComposite.this.m_timeValue.setEnabled(true);
                } else {
                    EndDelayComposite.this.m_timeValue.setEnabled(false);
                }
                EndDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_timeValue = new Text(composite, 2048);
        this.m_timeValue.setLayoutData((Object)new RowData(100, 15));
        this.m_timeValue.addVerifyListener((VerifyListener)new TimeVerifyListener());
        this.m_timeValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndDelayComposite.this.update();
            }
        });
        group = new Group((Composite)this.m_endDelayConditionGroup, 0);
        group.setText(Messages.getString((String)"condition.between.objects"));
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        group.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)group, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_andCondition = new Button(composite, 16);
        this.m_andCondition.setText(Messages.getString((String)"and"));
        this.m_andCondition.setLayoutData((Object)new RowData(100, 22));
        this.m_orCondition = new Button(composite, 16);
        this.m_orCondition.setText(Messages.getString((String)"or"));
        this.m_orCondition.setLayoutData((Object)new RowData(100, 22));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new RowData(77, 15));
        composite = new Composite((Composite)this.m_endDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new RowData(5, 15));
        composite = new Composite((Composite)this.m_endDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_notifyCondition = new Button(composite, 32);
        this.m_notifyCondition.setText(String.valueOf(Messages.getString((String)"notify.attribute")) + " : ");
        this.m_notifyCondition.setLayoutData((Object)new RowData(100, 22));
        this.m_notifyCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    EndDelayComposite.this.m_notifyPriority.setEnabled(true);
                } else {
                    EndDelayComposite.this.m_notifyPriority.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_notifyPriority = new Combo(composite, 0x1000008);
        this.m_notifyPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_notifyPriority.add(PriorityConstant.STRING_INFO);
        this.m_notifyPriority.add(PriorityConstant.STRING_WARNING);
        this.m_notifyPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_notifyPriority.add(PriorityConstant.STRING_UNKNOWN);
        composite = new Composite((Composite)this.m_endDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        this.m_operationCondition = new Button(composite, 32);
        this.m_operationCondition.setText(Messages.getString((String)"operations"));
        this.m_operationCondition.setLayoutData((Object)new RowData(220, 22));
        this.m_operationCondition.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    EndDelayComposite.this.m_operationType.setEnabled(true);
                    int type = EndDelayComposite.this.getSelectOperationName(EndDelayComposite.this.m_operationType);
                    if (type == 0) {
                        EndDelayComposite.this.m_operationStatus.setEnabled(false);
                        EndDelayComposite.this.m_operationValue.setEnabled(false);
                    } else if (type == 2) {
                        EndDelayComposite.this.m_operationStatus.setEnabled(false);
                        EndDelayComposite.this.m_operationValue.setEnabled(false);
                    } else if (type == 10) {
                        EndDelayComposite.this.m_operationStatus.setEnabled(true);
                        EndDelayComposite.this.m_operationValue.setEnabled(true);
                    }
                    EndDelayComposite.this.m_operationConditionGroup.setEnabled(true);
                } else {
                    EndDelayComposite.this.m_operationType.setEnabled(false);
                    EndDelayComposite.this.m_operationStatus.setEnabled(false);
                    EndDelayComposite.this.m_operationValue.setEnabled(false);
                    EndDelayComposite.this.m_operationConditionGroup.setEnabled(false);
                }
                EndDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_operationConditionGroup = new Group((Composite)this.m_endDelayConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.marginWidth = 5;
        rowLayout.marginHeight = 5;
        rowLayout.spacing = 1;
        this.m_operationConditionGroup.setLayout((Layout)rowLayout);
        composite = new Composite((Composite)this.m_operationConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"name")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_operationType = new Combo(composite, 0x1000008);
        this.m_operationType.setLayoutData((Object)new RowData(100, 20));
        if (!isFileJob) {
            this.m_operationType.add(OperationConstant.STRING_STOP_AT_ONCE);
        }
        this.m_operationType.add(OperationConstant.STRING_STOP_SUSPEND);
        this.m_operationType.add(OperationConstant.STRING_STOP_SET_END_VALUE);
        this.m_operationType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo check = (Combo)e.getSource();
                int type = EndDelayComposite.this.getSelectOperationName(check);
                if (type == 0) {
                    EndDelayComposite.this.m_operationStatus.setEnabled(false);
                    EndDelayComposite.this.m_operationValue.setEnabled(false);
                } else if (type == 2) {
                    EndDelayComposite.this.m_operationStatus.setEnabled(false);
                    EndDelayComposite.this.m_operationValue.setEnabled(false);
                } else if (type == 10) {
                    EndDelayComposite.this.m_operationStatus.setEnabled(true);
                    EndDelayComposite.this.m_operationValue.setEnabled(true);
                }
                EndDelayComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        composite = new Composite((Composite)this.m_operationConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"end.status")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_operationStatus = new Combo(composite, 0x1000008);
        this.m_operationStatus.setLayoutData((Object)new RowData(100, 20));
        this.m_operationStatus.add(EndStatusConstant.STRING_NORMAL);
        this.m_operationStatus.add(EndStatusConstant.STRING_WARNING);
        this.m_operationStatus.add(EndStatusConstant.STRING_ABNORMAL);
        composite = new Composite((Composite)this.m_operationConditionGroup, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.getString((String)"end.value")) + " : ");
        label.setLayoutData((Object)new RowData(100, 15));
        this.m_operationValue = new Text(composite, 2048);
        this.m_operationValue.setLayoutData((Object)new RowData(100, 15));
        this.m_operationValue.addVerifyListener((VerifyListener)new NumberVerifyListener(Short.MIN_VALUE, Short.MAX_VALUE));
        this.m_operationValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EndDelayComposite.this.update();
            }
        });
        label = new Label(composite, 0);
        label.setLayoutData((Object)new RowData(70, 15));
    }

    public void update() {
        if (this.m_endDelayCondition.getSelection() && this.m_sessionCondition.getSelection() && "".equals(this.m_sessionValue.getText())) {
            this.m_sessionValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_sessionValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_endDelayCondition.getSelection() && this.m_jobCondition.getSelection() && "".equals(this.m_jobValue.getText())) {
            this.m_jobValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_jobValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_endDelayCondition.getSelection() && this.m_timeCondition.getSelection() && "".equals(this.m_timeValue.getText())) {
            this.m_timeValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_timeValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if (this.m_endDelayCondition.getSelection() && this.m_operationCondition.getSelection() && this.getSelectOperationName(this.m_operationType) == 10 && "".equals(this.m_operationValue.getText())) {
            this.m_operationValue.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_operationValue.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    public void reflectWaitRuleInfo() {
        if (this.m_waitRule != null) {
            this.m_endDelayCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getEndDelay()));
            this.m_sessionCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getEndDelaySession()));
            this.m_sessionValue.setText(String.valueOf(this.m_waitRule.getEndDelaySessionValue()));
            this.m_jobCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getEndDelayJob()));
            this.m_jobValue.setText(String.valueOf(this.m_waitRule.getEndDelayJobValue()));
            this.m_timeCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getEndDelayTime()));
            if (this.m_waitRule.getEndDelayTimeValue() != null) {
                this.m_timeValue.setText(TimeTo48hConverter.dateTo48hms(new Date(this.m_waitRule.getEndDelayTimeValue())));
            } else {
                this.m_timeValue.setText("");
            }
            if (this.m_waitRule.getEndDelayConditionType() == 0) {
                this.m_andCondition.setSelection(true);
                this.m_orCondition.setSelection(false);
            } else {
                this.m_andCondition.setSelection(false);
                this.m_orCondition.setSelection(true);
            }
            this.m_notifyCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getEndDelayNotify()));
            this.setSelectPriority(this.m_notifyPriority, this.m_waitRule.getEndDelayNotifyPriority());
            this.m_operationCondition.setSelection(YesNoConstant.typeToBoolean((int)this.m_waitRule.getEndDelayOperation()));
            this.setSelectOperationName(this.m_operationType, this.m_waitRule.getEndDelayOperationType());
            this.setSelectOperationEndStatus(this.m_operationStatus, this.m_waitRule.getEndDelayOperationEndStatus());
            this.m_operationValue.setText(String.valueOf(this.m_waitRule.getEndDelayOperationEndValue()));
        }
        this.setEndDelayEnabled(this.m_endDelayCondition.getSelection());
    }

    public void setWaitRuleInfo(JobWaitRuleInfo start) {
        this.m_waitRule = start;
    }

    public JobWaitRuleInfo getWaitRuleInfo() {
        return this.m_waitRule;
    }

    public ValidateResult createWaitRuleInfo() {
        block18: {
            ValidateResult result;
            block17: {
                block16: {
                    result = null;
                    this.m_waitRule.setEndDelay(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_endDelayCondition.getSelection())));
                    this.m_waitRule.setEndDelaySession(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_sessionCondition.getSelection())));
                    try {
                        this.m_waitRule.setEndDelaySessionValue(Integer.valueOf(Integer.parseInt(this.m_sessionValue.getText())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.m_waitRule.getEndDelaySession() != 1) break block16;
                        result = new ValidateResult();
                        result.setValid(false);
                        result.setID(Messages.getString((String)"message.hinemos.1"));
                        result.setMessage(Messages.getString((String)"message.job.52"));
                        return result;
                    }
                }
                this.m_waitRule.setEndDelayJob(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_jobCondition.getSelection())));
                try {
                    this.m_waitRule.setEndDelayJobValue(Integer.valueOf(Integer.parseInt(this.m_jobValue.getText())));
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.m_waitRule.getEndDelayJob() != 1) break block17;
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.job.53"));
                    return result;
                }
            }
            this.m_waitRule.setEndDelayTime(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_timeCondition.getSelection())));
            if (this.m_waitRule.getEndDelayTime() == 1) {
                boolean check = false;
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
                Date from = null;
                Date to = null;
                Date date = null;
                try {
                    from = formatter.parse("00:00:00");
                    to = formatter.parse("48:00:00");
                    date = formatter.parse(this.m_timeValue.getText());
                    check = true;
                }
                catch (ParseException parseException) {
                    formatter = new SimpleDateFormat("HH:mm");
                    try {
                        date = formatter.parse(this.m_timeValue.getText());
                        check = true;
                    }
                    catch (ParseException parseException2) {}
                }
                if (check) {
                    if (date.before(from) || date.after(to)) {
                        Object[] args = new String[]{formatter.format(from), TimeTo48hConverter.dateTo48hms(to)};
                        result = new ValidateResult();
                        result.setValid(false);
                        result.setID(Messages.getString((String)"message.hinemos.1"));
                        result.setMessage(Messages.getString((String)"message.hinemos.8", (Object[])args));
                        return result;
                    }
                    this.m_waitRule.setEndDelayTimeValue(Long.valueOf(date.getTime()));
                } else {
                    result = new ValidateResult();
                    result.setValid(false);
                    result.setID(Messages.getString((String)"message.hinemos.1"));
                    result.setMessage(Messages.getString((String)"message.hinemos.6"));
                    return result;
                }
            }
            if (this.m_andCondition.getSelection()) {
                this.m_waitRule.setEndDelayConditionType(Integer.valueOf(0));
            } else {
                this.m_waitRule.setEndDelayConditionType(Integer.valueOf(1));
            }
            this.m_waitRule.setEndDelayNotify(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_notifyCondition.getSelection())));
            this.m_waitRule.setEndDelayNotifyPriority(Integer.valueOf(this.getSelectPriority(this.m_notifyPriority)));
            this.m_waitRule.setEndDelayOperation(Integer.valueOf(YesNoConstant.booleanToType((boolean)this.m_operationCondition.getSelection())));
            this.m_waitRule.setEndDelayOperationType(Integer.valueOf(this.getSelectOperationName(this.m_operationType)));
            try {
                this.m_waitRule.setEndDelayOperationEndStatus(Integer.valueOf(this.getSelectOperationEndStatus(this.m_operationStatus)));
                this.m_waitRule.setEndDelayOperationEndValue(Integer.valueOf(Integer.parseInt(this.m_operationValue.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.m_waitRule.getEndDelayOperation() != 1) break block18;
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.21"));
                return result;
            }
        }
        return null;
    }

    private void setEndDelayEnabled(boolean enabled) {
        if (enabled) {
            this.m_endDelayConditionGroup.setEnabled(true);
            this.m_sessionCondition.setEnabled(true);
            if (this.m_sessionCondition.getSelection()) {
                this.m_sessionValue.setEnabled(true);
            } else {
                this.m_sessionValue.setEnabled(false);
            }
            this.m_jobCondition.setEnabled(true);
            if (this.m_jobCondition.getSelection()) {
                this.m_jobValue.setEnabled(true);
            } else {
                this.m_jobValue.setEnabled(false);
            }
            this.m_timeCondition.setEnabled(true);
            if (this.m_timeCondition.getSelection()) {
                this.m_timeValue.setEnabled(true);
            } else {
                this.m_timeValue.setEnabled(false);
            }
            this.m_andCondition.setEnabled(true);
            this.m_orCondition.setEnabled(true);
            this.m_notifyCondition.setEnabled(true);
            if (this.m_notifyCondition.getSelection()) {
                this.m_notifyPriority.setEnabled(true);
            } else {
                this.m_notifyPriority.setEnabled(false);
            }
            this.m_operationConditionGroup.setEnabled(true);
            this.m_operationCondition.setEnabled(true);
            if (this.m_operationCondition.getSelection()) {
                this.m_operationType.setEnabled(true);
                this.m_operationStatus.setEnabled(false);
                this.m_operationValue.setEnabled(false);
                int type = this.getSelectOperationName(this.m_operationType);
                if (type == 0) {
                    this.m_operationStatus.setEnabled(false);
                    this.m_operationValue.setEnabled(false);
                } else if (type == 2) {
                    this.m_operationStatus.setEnabled(false);
                    this.m_operationValue.setEnabled(false);
                } else if (type == 10) {
                    this.m_operationStatus.setEnabled(true);
                    this.m_operationValue.setEnabled(true);
                }
            } else {
                this.m_operationType.setEnabled(false);
                this.m_operationStatus.setEnabled(false);
                this.m_operationValue.setEnabled(false);
            }
        } else {
            this.m_endDelayConditionGroup.setEnabled(false);
            this.m_sessionCondition.setEnabled(false);
            this.m_sessionValue.setEnabled(false);
            this.m_jobCondition.setEnabled(false);
            this.m_jobValue.setEnabled(false);
            this.m_timeCondition.setEnabled(false);
            this.m_timeValue.setEnabled(false);
            this.m_andCondition.setEnabled(false);
            this.m_orCondition.setEnabled(false);
            this.m_notifyCondition.setEnabled(false);
            this.m_notifyPriority.setEnabled(false);
            this.m_operationCondition.setEnabled(false);
            this.m_operationType.setEnabled(false);
            this.m_operationStatus.setEnabled(false);
            this.m_operationValue.setEnabled(false);
            this.m_operationConditionGroup.setEnabled(false);
        }
    }

    private void setSelectPriority(Combo combo, int priority) {
        String select = "";
        if (priority == 0) {
            select = PriorityConstant.STRING_CRITICAL;
        } else if (priority == 2) {
            select = PriorityConstant.STRING_WARNING;
        } else if (priority == 3) {
            select = PriorityConstant.STRING_INFO;
        } else if (priority == 1) {
            select = PriorityConstant.STRING_UNKNOWN;
        } else if (priority == 4) {
            select = "";
        }
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    private int getSelectPriority(Combo combo) {
        String select = combo.getText();
        if (select.equals(PriorityConstant.STRING_CRITICAL)) {
            return 0;
        }
        if (select.equals(PriorityConstant.STRING_WARNING)) {
            return 2;
        }
        if (select.equals(PriorityConstant.STRING_INFO)) {
            return 3;
        }
        if (select.equals(PriorityConstant.STRING_UNKNOWN)) {
            return 1;
        }
        if (select.equals("")) {
            return 4;
        }
        return -1;
    }

    private void setSelectOperationName(Combo combo, int operation) {
        String select = "";
        if (operation == 0) {
            select = OperationConstant.STRING_START_AT_ONCE;
        } else if (operation == 2) {
            select = OperationConstant.STRING_STOP_SUSPEND;
        } else if (operation == 10) {
            select = OperationConstant.STRING_STOP_SET_END_VALUE;
        }
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    private int getSelectOperationName(Combo combo) {
        String select = combo.getText();
        if (select.equals(OperationConstant.STRING_STOP_AT_ONCE)) {
            return 0;
        }
        if (select.equals(OperationConstant.STRING_STOP_SUSPEND)) {
            return 2;
        }
        if (select.equals(OperationConstant.STRING_STOP_SET_END_VALUE)) {
            return 10;
        }
        return -1;
    }

    private void setSelectOperationEndStatus(Combo combo, int status) {
        String select = "";
        select = EndStatusConstant.typeToString((int)status);
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    private int getSelectOperationEndStatus(Combo combo) {
        String select = combo.getText();
        return EndStatusConstant.stringToType((String)select);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_sessionCondition.setEnabled(enabled);
        this.m_sessionValue.setEnabled(enabled);
        this.m_jobCondition.setEnabled(enabled);
        this.m_jobValue.setEnabled(enabled);
        this.m_timeCondition.setEnabled(enabled);
        this.m_timeValue.setEnabled(enabled);
        this.m_andCondition.setEnabled(enabled);
        this.m_orCondition.setEnabled(enabled);
        this.m_notifyCondition.setEnabled(enabled);
        this.m_notifyPriority.setEnabled(enabled);
        this.m_operationCondition.setEnabled(enabled);
        this.m_operationType.setEnabled(enabled);
        this.m_operationStatus.setEnabled(enabled);
        this.m_operationValue.setEnabled(enabled);
        this.m_endDelayCondition.setEnabled(enabled);
    }
}

