/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.http.dialog;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.composite.TextWithParameterComposite;
import com.clustercontrol.http.action.AddHttp;
import com.clustercontrol.http.action.GetHttp;
import com.clustercontrol.http.action.ModifyHttp;
import com.clustercontrol.monitor.run.dialog.CommonMonitorNumericDialog;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.HttpCheckInfo;
import com.clustercontrol.ws.monitor.MonitorInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HttpNumericCreateDialog
extends CommonMonitorNumericDialog {
    private Text m_textTimeout = null;
    private TextWithParameterComposite m_textRequestUrl = null;

    public HttpNumericCreateDialog(Shell parent) {
        super(parent);
    }

    public HttpNumericCreateDialog(Shell parent, int monitorType) {
        super(parent);
        this.m_monitorType = monitorType;
    }

    public HttpNumericCreateDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.item1 = Messages.getString((String)"response.time.milli.sec");
        this.item2 = Messages.getString((String)"response.time.milli.sec");
        super.customizeDialog(parent);
        this.m_numericValueInfo.setInfoWarnText("0", "1000", "1000", "3000");
        this.shell.setText(Messages.getString((String)"dialog.http.create.modify"));
        Label label = null;
        GridData gridData = null;
        Group groupCheckRule = new Group((Composite)this.groupRule, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        groupCheckRule.setText(Messages.getString((String)"check.rule"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"request.url")) + " : ");
        this.m_textRequestUrl = new TextWithParameterComposite((Composite)groupCheckRule, 18436);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textRequestUrl.setLayoutData(gridData);
        this.m_textRequestUrl.setText("http://");
        this.m_textRequestUrl.setToolTipText(Messages.getString((String)"request.url.tooltip"));
        this.m_textRequestUrl.setColor(new Color((Device)parent.getDisplay(), new RGB(0, 0, 255)));
        this.m_textRequestUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HttpNumericCreateDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"time.out")) + " : ");
        this.m_textTimeout = new Text((Composite)groupCheckRule, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textTimeout.setLayoutData((Object)gridData);
        this.m_textTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HttpNumericCreateDialog.this.update();
            }
        });
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"milli.sec"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.itemName.setText(Messages.getString((String)"response.time"));
        this.measure.setText(Messages.getString((String)"time.msec"));
        this.adjustDialog();
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            info = new GetHttp().getHttp(this.monitorId);
        }
        this.setInputData(info);
    }

    @Override
    public void update() {
        super.update();
        if (this.m_textTimeout.getEnabled() && "".equals(this.m_textTimeout.getText())) {
            this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textTimeout.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
        if ("http://".equals(this.m_textRequestUrl.getText()) || !this.m_textRequestUrl.getText().startsWith("http://") && !this.m_textRequestUrl.getText().startsWith("https://")) {
            this.m_textRequestUrl.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
        } else {
            this.m_textRequestUrl.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
        }
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        super.setInputData(monitor);
        this.inputData = monitor;
        HttpCheckInfo httpInfo = monitor.getHttpCheckInfo();
        if (httpInfo == null) {
            httpInfo = new HttpCheckInfo();
            httpInfo.setUrlReplace(Integer.valueOf(0));
            httpInfo.setTimeout(Integer.valueOf(5000));
            httpInfo.setProxySet(Integer.valueOf(0));
            httpInfo.setProxyPort(Integer.valueOf(0));
        }
        if (httpInfo != null) {
            if (httpInfo.getRequestUrl() != null) {
                this.m_textRequestUrl.setText(httpInfo.getRequestUrl());
            }
            this.m_textTimeout.setText(Integer.toString(httpInfo.getTimeout()));
        }
        this.update();
        this.m_numericValueInfo.setInputData(monitor);
    }

    @Override
    protected MonitorInfo createInputData() {
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_HTP");
        HttpCheckInfo httpInfo = new HttpCheckInfo();
        httpInfo.setMonitorTypeId(this.monitorInfo.getMonitorTypeId());
        httpInfo.setMonitorId(this.monitorInfo.getMonitorId());
        if (this.m_textRequestUrl.getText() != null && !"".equals(this.m_textRequestUrl.getText().trim())) {
            httpInfo.setRequestUrl(this.m_textRequestUrl.getText());
        }
        if (this.m_textTimeout != null && !"".equals(this.m_textTimeout.getText().trim())) {
            try {
                httpInfo.setTimeout(Integer.valueOf(this.m_textTimeout.getText().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.42"));
                return null;
            }
        }
        this.monitorInfo.setHttpCheckInfo(httpInfo);
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_HTP", (String)this.monitorInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null && this.validateResult.getID() == null && !this.displayQuestion(this.validateResult)) {
            this.validateResult = null;
            return null;
        }
        this.validateResult = this.m_numericValueInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        return this.monitorInfo;
    }

    @Override
    protected boolean action() {
        boolean result = false;
        MonitorInfo info = this.inputData;
        if (info != null) {
            result = !this.updateFlg ? new AddHttp().add(info) : new ModifyHttp().modify(info);
        }
        return result;
    }

    @Override
    protected void setInfoInitialValue(MonitorInfo monitor) {
        super.setInfoInitialValue(monitor);
        HttpCheckInfo httpCheckInfo = new HttpCheckInfo();
        httpCheckInfo.setUrlReplace(Integer.valueOf(0));
        httpCheckInfo.setTimeout(Integer.valueOf(5000));
        httpCheckInfo.setProxySet(Integer.valueOf(0));
        httpCheckInfo.setProxyPort(Integer.valueOf(0));
        monitor.setHttpCheckInfo(httpCheckInfo);
    }
}

